/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

static char Version[] = "ld version 2.0  Copyright (c) 1991 Sozobon Ltd";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>
#include "syms.h"
#include "structs.h"
#include "global.h"


int   iOFormat = OBJCPM;
int   mflag;
int   vflag;
int   symout;
int   only8;
char *sTempDir;
char *oname;

#ifdef MINIX
long mstack, atol();
#endif

#ifdef TOS
#define FSEP '\\'
char *sFileSep = "\\";
#else
#define FSEP '/'
char *sFileSep = "/";
#endif

int tb;
int db;
int trelb;
int drelb;
int orelb;

static void opentmps(void);
static int  opent(char *s);
static void fpass(char *s);
static void OutputFormat(char *sFormat);

/****************************************************************************
 *                                                                          *
 * The start of it all                                                      *
 *                                                                          *
 ****************************************************************************/

int main(int argc, char **argv)

{
int iCount;
int iTempLen;

setbuf(stdout, NULL);                   /* Disable buffering on stdout      */
if((sTempDir = getenv("TMP")) == NULL)  /* Try and get temporary directory  */
#ifdef TOS                              /* or make a guess if none set      */
    sTempDir = "\\";                    /* If TOS default temp dir is root  */
#else
sTempDir = "/tmp/";                     /* if U**x then try std temp dir    */
#endif

/*
 * if the temporary directory does not end with a file seperator then we
 * must add one.
 */

 iTempLen = strlen(sTempDir);
if(sTempDir[iTempLen - 1] != FSEP)
    {
    iTempLen++;
    strcat(sTempDir, sFileSep);
    }

for(iCount = 1; iCount < argc; iCount++)    /* Pluck args one by one        */
    {
    switch(argv[iCount][0])
        {
        /*
         * decide if it is an option or a file name and act accordingly
         */
        case '-':
            if(doopt(&argv[iCount][1], argv[iCount + 1], 0))
                iCount++;
            break;
        #ifdef TOS
        case '+':
            if(doopt(&argv[iCount][1], argv[iCount + 1], 1))
                iCount++;
            break;
        #endif
        #ifdef MINIX
        case '=':
            mstack = atol(&argv[iCount][1]);
            break;
        #endif
        default:                        /* If not option then treat as file */
            opentmps();                 /* Make sure temp files are open    */
            pass1(argv[iCount]);        /* Process the file in question     */
            break;
        }
    }

pass2();                                /* Complete the link process        */
t_exit();                               /* Shut down the temporary files    */
exit(0);                                /* and exit cleanly                 */
}


/****************************************************************************
 *                                                                          *
 * Open all the temporary files, if they haven't been opened already        *
 *                                                                          *
 ****************************************************************************/

static void opentmps(void)

{
static int iDone = 0;
int        iPID;
char       sName[20];

if(iDone)                               /* Only do the following once       */
    return;

iDone = 1;                              /* Say we have done it now          */

iPID = getpid();                        /* Try to ensure unique temp files  */
sprintf(sName, "a%d", iPID);            /* in case system is multitasking   */

tb = opent(sName);                      /* Open 5 files beginning with      */
sName[0] = 'b';                         /* a, b, c, d and e respectivly     */
db = opent(sName);
sName[0] = 'c';
trelb = opent(sName);
sName[0] = 'd';
drelb = opent(sName);
sName[0] = 'e';
orelb = opent(sName);
}


/****************************************************************************
 *                                                                          *
 * Add temporary file name to temporary path, malloc string to store the    *
 * result in and then open the file.                                        *
 *                                                                          *
 ****************************************************************************/

static int opent(char *sFileName)

{
char *sTemp;

/*
 * malloc a large enough string to hold the full path.
 */

sTemp = mmalloc(strlen(sTempDir) + strlen(sFileName) + 1);

strcpy(sTemp, sTempDir);            /* Stick temporary directory in string  */
strcat(sTemp, sFileName);           /* add in the file name                 */
return t_open(sTemp);               /* and try to open it                   */
}


/****************************************************************************
 *                                                                          *
 * Process the command line options                                         *
 *                                                                          *
 ****************************************************************************/

int doopt(char *s, char *next, int lflag)

{
#ifdef TOS                              /* If TOS and option starts with +  */
if(lflag)                               /* then we convert string to lower  */
    lower(s);                           /* case before proceeding           */
#endif

while(*s)                               /* Process all args in the string   */
    {
    switch(*s)
        {
        case 'm':                       /* Produce linkage map listing on   */
            mflag++;                    /* stdout                           */
            break;

        case 'v':                       /* Verbose information option       */
            vflag++;
            break;

        case 't':                       /* Include symbol table in output   */
            symout++;                   /* file                             */
            break;

        case 'p':
        case 'b':
            /* archaic */
            break;

        case 'V':                               /* Show program version     */
            fprintf(stderr, "%s\n", Version);
            break;

        case 'F':                       /* Output format specifier          */
            OutputFormat(next);
            return(1);;

        case 'f':                       /* Process list of files in the     */
            fpass(next);                /* text file indicated in next arg  */
            return(1);                  /* 1 means next arg is an option    */
                                        /* parameter so skip over it        */
        case 'u':                       /* Undefine the following symbol    */
            sundeff(next);
            return(1);

        case 'o':                       /* Name the output file             */
            oname = next;
            return(1);

        case '8':                       /* Only allow first 8 characters in */
            only8 = 1;                  /* a symbol                         */
            break;
        }

    s++;                                /* Step to next character in args   */
    }

return(0);                   /* 0 means next arg is not an option parameter */
}


/****************************************************************************
 *                                                                          *
 * Read in a list of filenames from a text file and process them as input   *
 * object files.                                                            *
 *                                                                          *
 ****************************************************************************/

static void fpass(char *sFile)

{
FILE *pFileHndl;
char  sTemp[81];

opentmps();                             /* Make sure temp files are open    */
pFileHndl = fopen(sFile, "r");          /* Try to open file list file       */
if(pFileHndl == NULL)                   /* Bomb out if not availible        */
    {
    fprintf(stderr, "Cant open %s\n", sFile);
    exit(1);
    }

while(fscanf(pFileHndl, "%80s", sTemp) == 1) /* Pick out one line at a time */
    pass1(sTemp);                            /* and treat it as an object   */
                                             /* and add it to the lists     */
fclose(pFileHndl);                           /* Finally close the list file */
}


/****************************************************************************
 *                                                                          *
 * Display a fatal error message, tidy up and then exit                     *
 *                                                                          *
 ****************************************************************************/

void fatal(char *sMessage)

{
fprintf(stderr, "error: %s\n", sMessage);
t_exit();
exit(1);
}


/****************************************************************************
 *                                                                          *
 * Display a two part fatal error message, tidy up and then exit            *
 *                                                                          *
 ****************************************************************************/

void fatals(char *sFirst, char *sSecond)

{
fprintf(stderr, "error: %s %s\n", sFirst, sSecond);
t_exit();
exit(1);
}


/****************************************************************************
 *                                                                          *
 * Display a two part non fatal error message.                              *
 *                                                                          *
 ****************************************************************************/

void warns(char *sFirst, char *sSecond)

{
fprintf(stderr, "warning: %s %s\n", sFirst, sSecond);
}


/****************************************************************************
 *                                                                          *
 * Select the appropriate output format                                     *
 *                                                                          *
 ****************************************************************************/

static void OutputFormat(char *sFormat)

{
if(stricmp(sFormat, "TOS") == 0)
    iOFormat = OBJTOS;
else if(stricmp(sFormat, "CPM") == 0)
    iOFormat = OBJCPM;
else if(stricmp(sFormat, "CRUNCH") == 0)
    iOFormat = OBJCRUNCH;
else if(stricmp(sFormat, "COFF") == 0)
    iOFormat = OBJCOFF;
}

#ifdef TOS
/****************************************************************************
 *                                                                          *
 * Make all upper case characters in the supplied string lower case         *
 *                                                                          *
 ****************************************************************************/

lower(char *sString)

{
char cTemp;

while(*sString)
    {
    cTemp = *sString;
    if(isupper(cTemp))
        tolower(cTemp);

    *sTring++ = cTemp;
    }
}
#endif
