/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

#include "syms.h"
#include "structs.h"
#include "global.h"

#ifndef UNIXHOST
#define SWAPW(a,b)
#define SWAPL(a,b)
#else
#define SWAPW(a,b)  swapw(a,b)
#define SWAPL(a,b)  swapl(a,b)
#endif

extern int ofd;
extern int orelb;

long reloffs;
int relbeg;
long relsz = 0;

static void seerel(long lWords);
static void rputc(char cTemp);


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void relstart(void)

{
reloffs = 0;
relbeg = 1;
}


/****************************************************************************
 *                                                                          *
 * Compact the relocation information                                       *
 *                                                                          *
 ****************************************************************************/

void relout(int iSize, short *pRelocInfo)

{
short iRelocWord;
int   iOffset;
int   iCount;
long  lLastPos;

if(iOFormat == OBJCPM)
    {
    t_write(orelb, pRelocInfo, iSize);
    relsz += iSize;
    return;
    }

lLastPos  = -reloffs;                   /* Change from +ve offset to -ve    */
iCount = iSize / sizeof(short);                 /* Number of words in buf   */
for(iOffset = 0; iOffset < iCount; iOffset++)   /* Walk through buffer      */
    {
    iRelocWord = *pRelocInfo++;                 /* Get a relocation word    */
    switch(iRelocWord)                          /* and act upon it          */
        {
        case 7:                                 /* Instruction start word   */
        case 0:                                 /* Absolute reference       */
            break;                              /* Just ignore              */

        case 5:                                 /* First word of a long ref */
            iRelocWord = *pRelocInfo;           /* Fetch and act again      */
            if(iRelocWord != 0)                 /* If not absolute we must  */
                {                               /* check it out             */
                switch(iRelocWord)
                    {
                    case 1:                     /* Data segment reference   */
                    case 2:                     /* Code segment reference   */
                    case 3:                     /* BSS segment reference    */

                        seerel(iOffset - lLastPos); /* Convert to TOS reloc */
                        lLastPos = iOffset;         /* format and record    */
                        break;                      /* the current location */

                    default:                        /* Oh dear, how sad...  */
                        fatal("Bad reloc");
                    }
                }

            pRelocInfo++;                       /* Skip to next reloc and   */
            iOffset++;                          /* advance current position */
            break;

        default:
            fatal("bad reloc");
        }
    }

reloffs = iOffset - lLastPos;               /* Convert to positive offset   */
}


/****************************************************************************
 *                                                                          *
 * Write out one relocation item in the Atari TOS format                    *
 *                                                                          *
 ****************************************************************************/

static void seerel(long lWords)

{
union
    {
    long ls;
    char bs[4];
    } lb;

int iCount;

lWords *= 2;                            /* Go from word count to byte count */
if(relbeg)                                      /* The first one is unique  */
    {
    relbeg = 0;                                 /* Back to normal now       */
    lb.ls = lWords;                             /* Convert long to bytes    */
    SWAPL((char *)&lb.ls, 1);                   /* Correct byte order       */
    for(iCount = 0; iCount < 4; iCount++)       /* Write out bytes one at a */ 
        rputc(lb.bs[iCount]);                   /* time                     */
    }
else
    {
    while(lWords > 254)                         /* Write out a 1 for each   */
        {                                       /* full block of 254, 1 can */
        rputc(1);                               /* never occur normaly as   */
        lWords -= 254;                          /* all offsets are even     */
        }

    rputc((char)lWords);                        /* Write remainder out      */
    }
}


/****************************************************************************
 *                                                                          *
 * Mark the end of the relocation information                               *
 *                                                                          *
 ****************************************************************************/

void relend(void)

{
if(iOFormat == OBJTOS)
    rputc(0);

t_rewind(orelb);
bfcopy(orelb, ofd, relsz);
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static void rputc(char cTemp)

{
t_write(orelb, &cTemp, 1);
relsz++;
}
