
/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

#define OMAGIC 0x601a
#define AMAGIC 0xff65

typedef struct _generic
    {
	struct _generic *pNext;
    } GENERIC;

typedef struct _finfo
    {
	struct _finfo *pNext;	/* must be first */
	char sName[1];
    } FILENAME;

typedef struct _hdr_l
    {
	long tsize;
    long dsize;
    long bsize;
	long syms;
    } LENINFO;

#define HDRFILL	10
#define HDRSIZE	(2+HDRFILL+sizeof(LENINFO))

typedef struct _oinfo
    {
	struct _oinfo *pNext;	/* must be first */
	FILENAME *finfo;
	char      sFileName[14];
	LENINFO   oh;
	SYMCHUNK *pSymbols;
	int       havex;
	long      tbase;
    long      dbase;
    long      bbase;
    } OFILEINFO;

typedef struct _ainfo
    {
	struct _ainfo *pNext;	/* must be first */
	char      sFileName[14];
	char      used;
	long      aoffs;
	LENINFO   ah;
	SYMCHUNK *pSymbols;
	int       havex;
    } LIBINFO;

