/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

#include <stdio.h>
#include <io.h>
#include <string.h>
#include <malloc.h>
#include "syms.h"
#include "structs.h"
#include "global.h"


extern int only8;

#define NHASH 64

#ifdef NHASH
/* NHASH must be a power of 2 */
SYMBOL *ushead[NHASH];
SYMBOL *dshead[NHASH];
int hashv;
#define USHEAD ushead[hashv]
#define DSHEAD dshead[hashv]
#else
SYMBOL *ushead, *dshead;
#define USHEAD ushead
#define DSHEAD dshead
#endif

extern int vflag;

static void commhack(DRISYMBOL *sp, int n);
static SYMBOL *xlookup(SYMBOL *head, char *s, char *x);
static int smatch(char *old, char *s, char *x);
static int hash(unsigned char *s);
static DRISYMBOL *chunki(unsigned x, SYMCHUNK **chpp);
static int count1(SYMBOL *sp);
static int special(char *s);
static int notglob(int flags);
static void newdef(DRISYMBOL *sp, char *extp, OFILEINFO *op);
static void def2chk(SYMBOL *sip, DRISYMBOL *sp);
void ap1sym(DRISYMBOL *sp, SYMCHUNK *chp, int havex, OFILEINFO *op);
static int need1(DRISYMBOL *sp, SYMCHUNK *chp, int havex);
static char *getext(SYMCHUNK *chp, DRISYMBOL *sp, int havex);
static char *exten(SYMCHUNK *chp, DRISYMBOL *sp);
static void undeff(char *s, char *xp, OFILEINFO *op);

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void getsyms(int fd, long size, SYMCHUNK **spp)

{
SYMCHUNK *chp;
long n;
int k;

n = size / SYMSIZE;
if(n == 0)
    {
    *spp = 0;
    return;
    }

do
    {
    if(n > CHUNKMAX)
        k = CHUNKMAX;
    else
        k = n;

    chp = (SYMCHUNK *)mmalloc(sizeof(SYMCHUNK) +
          ((k - 1) * sizeof(DRISYMBOL)));
    rread(fd, (char *)&chp->s[0], k * SYMSIZE);
    #ifdef UNIXHOST
    symhacki((DRISYMBOL *)&chp->s[0], k);
    #endif
    commhack(&chp->s[0], k);
    chp->nsyms = k;
    *spp = chp;
    spp = &chp->pNext;
    n -= k;
    }
    while(n);

chp->pNext = 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static void commhack(DRISYMBOL *sp, int n)

{
int i;

/* Common def with value of 0 is really an external ref */

for(i = 0; i < n; i++)
    {
    if( sp->flags == COMMDEF && sp->value == 0)
        sp->flags = EXTREF;

    sp++;
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void symfree(SYMCHUNK *chp)

{
SYMCHUNK *pNext;

while(chp)
    {
    pNext = chp->pNext;
    free(chp);
    chp = pNext;
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int chkx(SYMCHUNK *chp)

{
DRISYMBOL *sp;

if(only8)
    return 0;

if(chp == 0)
    return 0;

sp = &chp->s[0];
if(sp->flags == XFLAGS && sp->value == XVALUE && strncmp(sp->name, XNAME, 8) == 0)
    return 1;

return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static SYMBOL *xlookup(SYMBOL *head, char *s, char *x)

{
while(head)
    {
    if(smatch(head->name, s, x))
        return head;

    head = head->pNext;
    }

return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static int smatch(char *old, char *s, char *x)

{
int ol;

ol = strlen(old);
if(ol < 8)
    return strcmp(old, s) == 0;

if(strncmp(old, s, 8) != 0)
    return 0;

if(strcmp(&old[8], x) == 0)
    return 1;

else if(x[0] == '*')
    return 1;

else if(old[8] == '*')
    return 2;

return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

SYMBOL *newsinfo(char *s, char *xp)

{
int slen, xlen;
SYMBOL *sp;

slen = strnlen(s, 8);
if(slen == 8 && xp)
    xlen = strlen(xp);
else
    xlen = 0;

sp = (SYMBOL *)mmalloc(slen + xlen + sizeof(SYMBOL));
memcpy(sp->name, s, slen);
sp->name[slen] = 0;
if(xlen)
    strcpy(&sp->name[8], xp);

sp->flags = sp->mark = 0;
sp->value = 0;
sp->obj   = 0;
return sp;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void sundeff(char *s)

{
hashv = hash((unsigned char *)s);
if(strlen(s) > 8)
    undeff(s, &s[8], 0L);
else
    undeff(s, 0L, 0L);
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static void undeff(char *s, char *xp, OFILEINFO *op)                  /* hashv set by caller */

{
SYMBOL *sp;

sp = newsinfo(s, xp);
sp->flags = EXTREF;
sp->obj = op;
listins((GENERIC **)&USHEAD, (GENERIC *)sp);

if(vflag > 1)
    printf("Adding undefined reference %s\n", sp->name);
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static char *exten(SYMCHUNK *chp, DRISYMBOL *sp)

{
static int maxlen = 0;
static char *cp = 0;
int k, i, n, slen;
SYMCHUNK *nchp;
DRISYMBOL *nsp;

if(maxlen == 0)
    {
    maxlen = 100;
    cp     = mmalloc(maxlen);
    }

again:
k        = chp->nsyms;
i        = sp - &chp->s[0];
slen     = 0;
cp[slen] = 0;
nchp     = chp;
nsp      = sp;

while(slen + 9 < maxlen)
    {
    i++;
    if(i < k)
        {
        nsp++;
        }
    else if(nchp->pNext == NULL)
        {
        return cp;
        }
    else
        {
        nchp = nchp->pNext;
        k = nchp->nsyms;
        i = 0;
        nsp = &nchp->s[0];
        }

    if(nsp->flags != XFLAGS || nsp->value != XVALUE)
        {
        return cp;
        }

    n = strnlen(nsp->name, 8);
    memcpy(&cp[slen], nsp->name, n);
    slen += n;
    cp[slen] = 0;

    if(n != 8)
        {
        return cp;
        }
    }

/* buffer is too small */
free(cp);
maxlen += 100;
cp = mmalloc(maxlen);
goto again;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int needed(SYMCHUNK *chp, int havex)

{
unsigned i;
int k;

while(chp)
    {
    k = chp->nsyms;
    for(i = 0; i < k; i++)
        if(need1(&chp->s[i], chp, havex))
            return 1;

    chp = chp->pNext;
    }
return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static char *getext(SYMCHUNK *chp, DRISYMBOL *sp, int havex)

{
char *extp;

if(havex)
    extp = exten(chp, sp);
else if(only8)
    extp = "";
else
    extp = "*";
return extp;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static int need1(DRISYMBOL *sp, SYMCHUNK *chp, int havex)

{
char *extp;
SYMBOL *sip;

#ifdef NHASH

hashv = hash((unsigned char *)sp->name);
#endif

if(notglob(sp->flags))
    return 0;

if(sp->flags == EXTREF || sp->flags == COMMDEF)
    return 0;

if(sp->name[7])
    extp = getext(chp, sp, havex);
else
    extp = 0;

if((sip = xlookup(USHEAD, sp->name, extp)))
    {
    if(vflag > 1)
        printf("Needed %s\n", sip->name);

    return 1;
    }

return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int p1syms(SYMCHUNK *chp, int havex, OFILEINFO *op)

{
unsigned i;
int k;

while(chp)
    {
    k = chp->nsyms;
    for(i = 0; i < k; i++)
        ap1sym(&chp->s[i], chp, havex, op);
    chp = chp->pNext;
    }
return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void ap1sym(DRISYMBOL *sp, SYMCHUNK *chp, int havex, OFILEINFO *op)

{
char *extp;
SYMBOL *sip;

if(notglob(sp->flags))
    return;

if(sp->name[7])
    extp = getext(chp, sp, havex);
else
    extp = 0;

#ifdef NHASH
hashv = hash((unsigned char *)sp->name);
#endif
if(sp->flags == EXTREF)
    {
    if(xlookup(USHEAD, sp->name, extp))
        return;
    else if(xlookup(DSHEAD, sp->name, extp))
        ;
    else
        undeff(sp->name, extp, op);
    }
else
    {
    sip = xlookup(USHEAD, sp->name, extp);
    if(sip)
        {
        listdel((GENERIC **)&USHEAD, (GENERIC *)sip);
        sip->flags = sp->flags;
        sip->value = sp->value;
        sip->obj = op;
        listins((GENERIC **)&DSHEAD, (GENERIC *)sip);

        if(vflag > 1)
            printf("Reference found %s\n", sip->name);
        }
    else
        {
        sip = xlookup(DSHEAD, sp->name, extp);
        if(sip)
            def2chk(sip, sp);
        else
            newdef(sp, extp, op);
        }
    }

return;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static void def2chk(SYMBOL *sip, DRISYMBOL *sp)

{
if(sip->flags == COMMDEF && sp->flags == COMMDEF)
    {
    if(sip->value != sp->value)
        {
        warns("common sizes differ for", sip->name);
        if(sp->value > sip->value)
            sip->value = sp->value;
        }
    }
else
    fatals("double definition of", sip->name);
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static void newdef(DRISYMBOL *sp, char *extp, OFILEINFO *op) /* hashv set by caller */

{
SYMBOL *sip;

sip = newsinfo(sp->name, extp);
sip->flags = sp->flags;
sip->value = sp->value;
sip->obj = op;
listins((GENERIC **)&DSHEAD, (GENERIC *)sip);

if(vflag > 1)
    printf("Defined symbol %s\n", sip->name);
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static int notglob(int flags)

{
if(flags & F_GLBL)
    return 0;

if(flags == EXTREF)
    return 0;

return 1;
}


/****************************************************************************
 *                                                                          *
 * See if a symbol is one of the ones we will define later                  *
 *                                                                          *
 ****************************************************************************/

static int special(char *sString)

{
if(strcmp(sString, "_end")   == 0)
    return 1;

if(strcmp(sString, "_etext") == 0)
    return 1;

if(strcmp(sString, "_edata") == 0)
    return 1;

return 0;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void end_sym(char *s, long val, int flag)

{
SYMBOL *sip;

#ifdef NHASH

hashv = hash((unsigned char *)s);
#endif

sip = xlookup(USHEAD, s, 0L);
if(sip)
    {
    listdel((GENERIC **)&USHEAD, (GENERIC *)sip);
    sip->flags = (unsigned char)flag;
    sip->value = val;
    sip->obj = 0;
    listins((GENERIC **)&DSHEAD, (GENERIC *)sip);
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void chk_undefs(void)
{
SYMBOL *sp;
int any = 0;

#ifdef NHASH

for(hashv = 0; hashv < NHASH; hashv++)
#endif
    {
    sp = USHEAD;
    while(sp)
        {
        if(!special(sp->name))
            {
            any = 1;
            printf("undefined symbol %s", sp->name);
            if(sp->obj)
                {
                printf(" from %s", sp->obj->finfo->sName);
                if(sp->obj->sFileName[0])
                    printf("(%.14s)", sp->obj->sFileName);
                }

            putchar('\n');
            }
        sp = sp->pNext;
        }
    }

if(any)
    fatal("load aborted due to undefined symbols");
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

long mkcomm(long where)

{
SYMBOL *sp;
long size, base, obase;

base = obase = where;
#ifdef NHASH
for(hashv = 0; hashv < NHASH; hashv++)
#endif
    {
    sp = DSHEAD;
    while(sp)
        {
        if(sp->flags == COMMDEF)
            {
            size = sp->value;
            sp->value = base;
            sp->flags = (F_BSS | F_GLBL | F_DEF);
            base += size;
            }
        sp = sp->pNext;
        }
    }
return base - obase;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void adjsyms(void)
{
SYMBOL *sp;

#ifdef NHASH

for(hashv = 0; hashv < NHASH; hashv++)
#endif
    {
    sp = DSHEAD;
    while(sp)
        {
        switch(sp->flags & 7)
            {
            case F_TEXT:
                sp->value += sp->obj->tbase;
                break;
            case F_DATA:
                sp->value += sp->obj->dbase;
                break;
            case F_BSS:
                sp->value += sp->obj->bbase;
                break;
            }
        sp = sp->pNext;
        }
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

long countsyms(void)
{
long n;
SYMBOL *sp;

if(only8)
    n = 0;
else
    n = 1;

#ifdef NHASH
for(hashv = 0; hashv < NHASH; hashv++)
#endif
    {
    sp = DSHEAD;
    while(sp)
        {
        n += count1(sp);
        sp = sp->pNext;
        }
    }
return n * SYMSIZE;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static int count1(SYMBOL *sp)

{
int n;

if(only8)
    return 1;
n = strlen(sp->name);
if(n == 9 && sp->name[8] == '*')
    n = 8;
if(n == 0)
    fatal("zero length name");
return(n + 7) / 8;
}


char zname[8];
#ifndef UNIXHOST
#define FIXSYM(a)
#else
#define FIXSYM(a)   fixsym(a)
#endif

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void wrsyms(int fd)

{
SYMBOL *sp;
DRISYMBOL s;

if(!only8)
    {
    memcpy(s.name, zname, 8);
    strncpy(s.name, XNAME, 8);
    s.flags = XFLAGS;
    s.mark = 0;
    s.value = XVALUE;
    FIXSYM(&s);
    write(fd, &s, SYMSIZE);
    }

#ifdef NHASH
for(hashv = 0; hashv < NHASH; hashv++)
#endif
    {
    sp = DSHEAD;
    while(sp)
        {
        memcpy(s.name, zname, 8);
        strncpy(s.name, sp->name, 8);
        s.flags = sp->flags;
        s.mark = 0;
        s.value = sp->value;
        FIXSYM(&s);
        write(fd, &s, SYMSIZE);

        if(!only8)
            {
            int n, i;

            n = strlen(sp->name);
            if(n == 9 && sp->name[8] == '*')
                n = 8;
            i = 8;
            while(n > i)
                {
                memcpy(s.name, zname, 8);
                strncpy(s.name, &sp->name[i], 8);
                s.flags = XFLAGS;
                s.mark = 0;
                s.value = XVALUE;
                i += 8;

                FIXSYM(&s);
                write(fd, &s, SYMSIZE);
                }
            }

        sp = sp->pNext;
        }
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static DRISYMBOL *chunki(unsigned x, SYMCHUNK **chpp)

{
unsigned k, i;
DRISYMBOL *sp;
SYMCHUNK *chp;

chp = *chpp;
i = 0;
while(chp)
    {
    k = chp->nsyms;
    if(x < i + k)
        {
        sp = &chp->s[x - i];
        *chpp = chp;
        return sp;
        }
    i += k;
    chp = chp->pNext;
    }
fatal("bad relocation index");
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

long findx(unsigned short x, SYMCHUNK *chp, int havex, short *relp)

{
SYMBOL *sip;
DRISYMBOL *sp;
char *extp;

x >>= 3;
sp = chunki(x, &chp);
#ifdef NHASH
hashv = hash((unsigned char *)sp->name);
#endif
if(sp->mark == 0)
    {
    if(sp->name[7])
        extp = getext(chp, sp, havex);
    else
        extp = 0;
    sip = xlookup(DSHEAD, sp->name, extp);
    if(sip == 0)
        fatal("Cant find symbol");
    switch(sip->flags & 7)
        {
        case 1:
            sp->mark = 3;
            break;
        case 2:
            sp->mark = 2;
            break;
        case 4:
            sp->mark = 1;
            break;
        default:
            fatal("Bad sym type");
        }
    sp->value = sip->value;
    }
*relp = sp->mark;
return sp->value;
}

#ifdef NHASH

/* only use 1st 8 chars for hash value! */

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

static int hash(unsigned char *s)

{
unsigned char c;
register i, n = 0;

for(i = 1; i < 5; i++)
    {
    c = s[i];
    if(!c)
        break;
    n = (n << 1) | c;
    }
return n & (NHASH - 1);
}
#endif
