/*
 * Copyright (c) 1991 by Sozobon, Limited.  Author: Johann Ruegg
 *
 * Permission is granted to anyone to use this software for any purpose
 * on any computer system, and to redistribute it freely, with the
 * following restrictions:
 * 1) No charge may be made other than reasonable charges for reproduction.
 * 2) Modified versions must be clearly marked as such.
 * 3) The authors are not responsible for any harmful consequences
 *    of using this software, even if they result from defects in it.
 */

#include <stdio.h>
#include <io.h>
#include <string.h>
#include <malloc.h>
#include "syms.h"
#include "structs.h"
#include "global.h"

extern int vflag;
#define FBSIZE 1000

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void fbcopy(int fr, int to, long cnt)

{
char buf[FBSIZE];
int k;

while(cnt > 0)
    {
    if(cnt > FBSIZE)
        k = FBSIZE;
    else
        k = cnt;
    rread(fr, buf, k);
    t_write(to, buf, k);
    cnt -= k;
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void bfcopy(int fr, int to, long cnt)

{
char buf[FBSIZE];
int k;

while(cnt > 0)
    {
    if(cnt > FBSIZE)
        k = FBSIZE;
    else
        k = cnt;
    t_read(fr, buf, k);
    wwrite(to, buf, k);
    cnt -= k;
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

char *mmalloc(int size)

{
char *rv;

again:
rv = malloc(size);
if(rv == 0)
    {
    if(t_frees())
        goto again;

    fatal("out of memory");
    }

if(vflag > 2)
    printf("malloc'ed  %x bytes at %lx\n", size, rv);

return rv;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int rread(int fd, char *buf, int cnt)

{
if(read(fd, buf, cnt) != cnt)
    fatal("read error");

if(vflag > 2)
    printf("file %d read: buffer %lx, bytes %d\n", fd, buf, cnt);

return cnt;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int wwrite(int fd, char *buf, int cnt)

{
if(write(fd, buf, cnt) != cnt)
    fatal("write error");

if(vflag > 2)
    printf("file %d write: buffer %lx, bytes %d\n", fd, buf, cnt);

return cnt;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

long llseek(int fd, long ofs, int how)

{
long rv;

rv = lseek(fd, ofs, how);
if(rv < 0)
    fatal("lseek error");

if(vflag > 2)
    printf("file %d seek: position %lx, method %d\n", fd, ofs, how);

return rv;
}

#ifdef UNIXHOST
#define lread read
#else
long lread();
#endif

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

int strnlen(char *s, int max)

{
int i;

for(i = 0; i < max; i++)
    if(*s++ == 0)
        return i;
return max;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void listins(GENERIC **hpp, GENERIC *np)

{
np->pNext = *hpp;
*hpp = np;
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void listadd(GENERIC **hpp, GENERIC *np)

{
GENERIC *tp;

np->pNext = 0;

if(*hpp == 0)
    {
    *hpp = np;
    }
else
    {
    tp = *hpp;
    while(tp->pNext)
        tp = tp->pNext;
    tp->pNext = np;
    }
}


/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/

void listdel(GENERIC **hpp, GENERIC *np)

{
GENERIC *tp;

if(*hpp == np)
    {
    *hpp = np->pNext;
    np->pNext = 0;
    }
else
    {
    tp = *hpp;
    while(tp->pNext)
        {
        if(tp->pNext == np)
            {
            tp->pNext = np->pNext;
            np->pNext = 0;
            return;
            }
        tp = tp->pNext;
        }
    fatal("listdel error");
    }
}
