#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "timer.h"
#include "arp.h"
#include "arpdump.h"		/* Prototypen */

void
arp_dump(struct mbuf **bpp)
{
	struct arp arp;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;
	printf("ARP: len %d",len_mbuf(*bpp));
	if(ntoharp(&arp,bpp) == -1){
		printf(" bad packet\n");
		return;
	}
	if(arp.hardware < NHWTYPES)
		printf(" hwtype %s",arptypes[arp.hardware]);
	else
		printf(" hwtype %u",arp.hardware);
	printf(" prot 0x%x hwlen %u prlen %u",
		arp.protocol,arp.hwalen,arp.pralen);
	switch(arp.opcode){
	case ARP_REQUEST:
		printf(" op REQUEST");
		break;
	case ARP_REPLY:
		printf(" op REPLY");
		break;
	default:
		printf(" op %u",arp.opcode);
		break;
	}
	printf(" target %s\n",inet_ntoa(arp.tprotaddr));
}
