#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "enet.h"
#include "trace.h"
#include "iface.h"
#include "arpdump.h"
#include "ipdump.h"
#include "enetdump.h"

void
ether_dump(struct mbuf ** bpp, 
                      int check /* Not used */ )
{
	struct ether ehdr;
	char s[20],d[20];

	ntohether(&ehdr,bpp);
	pether(s,ehdr.source);
	pether(d,ehdr.dest);
	printf("Ether: %s->%s type 0x%x len %u\n",s,d,ehdr.type,
		ETHERLEN + len_mbuf(*bpp));

	switch(ehdr.type){
		case IP_TYPE:
			ip_dump(bpp,1);
			break;
		case ARP_TYPE:
			arp_dump(bpp);
			break;
	}
}
