; Projekt : TCP/IP fr Atari-ST
; Modul   : ETHSTART.S
; Aufruf  : wird bei einem LANCE-IR (Autointerrupt #5) angesprungen
; Funktion: Sichert alle Prozessor-Register,
;           ruft eth_isr() in ETH.C auf,
;           ldt die Prozessor-Register wieder,
;           RTE


		IMPORT	eth_isr			; eigentliche ISR aus ETH.C
		EXPORT	eth_start		;
		
		TEXT

eth_start:
		ori.w	#$0700, sr		; IR's maskieren
		movem.l	d0-a6, -(a7)	; Register auf Superv.-Stack
		jsr		eth_isr			; eth_isr() aufrufen
		movem.l (a7)+, d0-a6	; Register restaurieren
		rte						; fertig

		END
