; Projekt : TCP/IP fr Atari-ST
; Modul   : ETHSTART.S
; Aufruf  : wird bei einem LANCE-IR (Autointerrupt #5) angesprungen
; Funktion: Sichert alle Prozessor-Register,
;           ruft eth_isr() in ETH.C auf,
;           ldt die Prozessor-Register wieder,
;           RTE


		IMPORT	eth_isr			; eigentliche ISR aus ETH.C
		EXPORT	eth_start		;
		
		TEXT

eth_start:
		ori.w	#$0700, sr		; IR's maskieren
		movem.l	d0-a6, -(a7)	; Register auf Superv.-Stack
		move.l	a7, ssp_save	; ssp retten
		andi.w	#$DFFF, sr		; in user-mode
		jsr		eth_isr			; eth_isr() aufrufen
		move.l	ssp_save, -(a7)	; ssp auf Userstack
		move.w	#32, -(a7)		; Set Supervisor-Mode
		trap	#1				; Gemdos
; muss der User-Stack aufgeraeumt werden?
		move.l	usp, a0			; User-Stack aufrumen
		addq.w	#6, a0			; 6 Bytes
		move.l	a0, usp
		movem.l (a7)+, d0-a6	; Register restaurieren
		rte						; fertig

		BSS
ssp_save:
		DS.l	1				; 1 Long fr SSP
		
		END
