/* Internet Control Message Protocol */

/* Message types */
#define	ECHO_REPLY	0	/* Echo Reply */
#define	DEST_UNREACH	3	/* Destination Unreachable */
#define	QUENCH		4	/* Source Quench */
#define	REDIRECT	5	/* Redirect */
#define	ECHO		8	/* Echo Request */
#define	TIME_EXCEED	11	/* Time-to-live Exceeded */
#define	PARAM_PROB	12	/* Parameter Problem */
#define	TIMESTAMP	13	/* Timestamp */
#define	TIME_REPLY	14	/* Timestamp Reply */
#define	INFO_RQST	15	/* Information Request */
#define	INFO_REPLY	16	/* Information Reply */

/* Internal format of an ICMP header (checksum is missing) */
struct icmp {
	char type;
	char code;
 	union icmp_args {
		int32 unused;
		char pointer;
		int32 address;
		struct {
			int16 id;
			int16 seq;
		} echo;
	} args;
};
#define	ICMPLEN		8	/* Length of ICMP header on the net */
#define	NULLICMP	(union icmp_args *)0
	
/* Destination Unreachable codes */
#define	NET_UNREACH	0	/* Net unreachable */
#define	HOST_UNREACH	1	/* Host unreachable */
#define	PROT_UNREACH	2	/* Protocol unreachable */
#define	PORT_UNREACH	3	/* Port unreachable */
#define	FRAG_NEEDED	4	/* Fragmentation needed and DF set */
#define	ROUTE_FAIL	5	/* Source route failed */

/* Time Exceeded codes */
#define	TTL_EXCEED	0	/* Time-to-live exceeded */
#define	FRAG_EXCEED	1	/* Fragment reassembly time exceeded */

/* Redirect message codes */
#define	REDR_NET	0	/* Redirect for the network */
#define	REDR_HOST	1	/* Redirect for the host */
#define	REDR_TOS	2	/* Redirect for Type of Service, or-ed with prev */

struct icmp_errors {
	unsigned checksum;		/* ICMP Checksum errors */
	unsigned nospace;		/* alloc_mbuf failed someplace */
	unsigned noloop;		/* No ICMP in response to an ICMP */
	unsigned bdcsts;		/* Ignore broadcast ICMPs */
};
#define	ICMP_TYPES	17
struct icmp_stats {
	unsigned input[ICMP_TYPES];	/* ICMP input stats by type */
	unsigned output[ICMP_TYPES];	/* ICMP output stats by type */
};


/* ICMP messages, decoded */
extern char *icmptypes[],*unreach[],*exceed[],*redirect[];

/* Process an incoming ICMP packet */
void icmp_input(struct mbuf *bp,	/* Pointer to ICMP message */
			    char protocol,	/* Should always be ICMP_PTCL */
			    int32 source,	/* Sender of ICMP message */
 			    int32 dest,		/* Us */
			    char tos,		/* Type of Service */
			    int16 length,	/* Length of ICMP message */
			    char rxbroadcast);

/* Return an ICMP response to the sender of a datagram */
void icmp_output(struct ip *ip,		/* Header of offending datagram */
				 struct mbuf *bp,	/* Data portion of datagram */
				 char type,			/* Codes to send */
				 char code,
				 union icmp_args *args);

/* Generate ICMP header in network byte order, link data, compute checksum */
struct mbuf *htonicmp(struct icmp *icmp,struct mbuf *data);

/* Pull off ICMP header */
void ntohicmp(struct icmp *icmp,struct mbuf **bpp);
