/* Miscellaneous machine independent utilities */

#include <string.h>
#include "global.h"
#include "misc.h"

/* Convert hex-ascii to integer */
int
htoi(char *s)
{
	int i = 0;
	char c;

	while((c = *s++) != '\0'){
		if(c == 'x')
			continue;	/* allow 0x notation */
		if('0' <= c && c <= '9')
			i = (i * 16) + (c - '0');
		else if('a' <= c && c <= 'f')
			i = (i * 16) + (c - 'a' + 10);
		else if('A' <= c && c <= 'F')
			i = (i * 16) + (c - 'A' + 10);
		else
			break;
	}
	return i;
}
/* replace terminating end of line marker(s) with null */
void
rip(register char *s)
{
	register char *cp;

	if( (cp = index(s,'\r')) != NULLCHAR)
		*cp = '\0';
	if( (cp = index(s,'\n')) != NULLCHAR)
		*cp = '\0';
}