/* Miscellaneous servers */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "timer.h"
#include "tcp.h"
#include "smisc.h"
#include "main.h"
#include "iface.h"

static struct tcb *disc_tcb,*echo_tcb;
/* Start up discard server */
void 
discard_start(int argc,char *argv[])
{
	struct socket lsocket;

	lsocket.address = ip_addr;
	if(argc < 2)
		lsocket.port = 9;
	else
		lsocket.port = atoi(argv[1]);
	disc_tcb = open_tcp(&lsocket,NULLSOCK,TCP_SERVER,0,disc_recv,NULLVFP,misc_state,0,(char *)NULL);
}
/* Start echo server */
void
echo_start(int argc,char *argv[])
{
	struct socket lsocket;

	lsocket.address = ip_addr;
	if(argc < 2)
		lsocket.port = 7;
	else
		lsocket.port = atoi(argv[1]);
	echo_tcb = open_tcp(&lsocket,NULLSOCK,TCP_SERVER,0,echo_recv,echo_trans,misc_state,0,(char *)NULL);

}

/* Shut down miscellaneous servers */
void 
discard_stop(void)
{
	if(disc_tcb != NULLTCB)
		close_tcp(disc_tcb);
}

void 
echo_stop(void)
{
	if(echo_tcb != NULLTCB)
		close_tcp(echo_tcb);
}

/* Discard server receiver upcall */
static
void
disc_recv(struct tcb *tcb,int16 cnt)
{
	struct mbuf *bp;

	if(recv_tcp(tcb,&bp,cnt) > 0)
		free_p(bp);			/* Discard */
}

/* Echo server receive
 * Copies only as much will fit on the transmit queue
 */
static
void
echo_recv(struct tcb *tcb,int16 cnt)
{
	struct mbuf *bp;
	int acnt;

	if(cnt == 0){
		close_tcp(tcb);
		return;
	}
	acnt = min(cnt,tcb->snd.wnd);
	if(acnt > 0){
		/* Get only as much will fit in the send window */
		recv_tcp(tcb,&bp,tcb->snd.wnd);
		send_tcp(tcb,bp);
	}
}
/* Echo server transmit
 * Copies anything that might have been left in the receiver queue
 */
static
void
echo_trans(struct tcb *tcb,int16 cnt)
{
	struct mbuf *bp;

	if(tcb->rcvcnt > 0){
		/* Get only as much will fit in the send window */
		recv_tcp(tcb,&bp,cnt);
		send_tcp(tcb,bp);
	}
}

/* Log connection state changes; also respond to remote closes */
static
void
misc_state(register struct tcb *tcb,char old,char new)
{
	switch(new){
	case ESTABLISHED:
		log(tcb,"open %d",tcb->conn.local.port);
		break;
	case CLOSE_WAIT:
		close_tcp(tcb);
		break;
	case CLOSED:
		log(tcb,"close %d",tcb->conn.local.port);
		del_tcp(tcb);
		/* Clean up if server is being shut down */
		if(tcb == disc_tcb)
			disc_tcb = NULLTCB;
		else if(tcb == echo_tcb)
			echo_tcb = NULLTCB;
		break;
	}
}
