/* ************** Prototypen ************* */

void tcp_input(struct mbuf *bp,   /* Data field, if any */
			   char protocol,     /* Should always be TCP_PTCL */
			   int32 source,      /* Remote IP address */
			   int32 dest,        /* Our IP address */
			   char tos,          /* Type of Service */
			   int16 length,      /* Length of data field */
			   char rxbroadcast); /* Incoming broadcast - discard if true */

void tcp_icmp(int32 source,       /* Original IP datagram source (i.e. us) */
		 int32 dest,         /* Original IP datagram dest (i.e., them) */
		 char type,		     /* ICMP error codes */
		 char code,
		 struct mbuf **bpp); /* First 8 bytes of TCP header */

static void reset(int32 source,   			/* Remote IP address */
	  			  int32 dest,     			/* Our IP address */
	  			  char tos,     			/* Type of Service */
	  			  int16 length,   			/* Length of data portion */
	  			  register struct tcp *seg);/* Offending TCP header */

static void update(register struct tcb *tcb,register struct tcp *seg);
static int in_window(struct tcb *tcb,int32 seq);
static void proc_syn(register struct tcb *tcb,char tos,struct tcp *seg);
void send_syn(register struct tcb *tcb);
static void add_reseq(struct tcb *tcb,
					  char tos,
					  struct tcp *seg,
					  struct mbuf *bp,
					  int16 length);
static void get_reseq(register struct tcb *tcb,
					  char *tos,
					  struct tcp *seg,
					  struct mbuf **bp,
					  int16 *length);
static int trim(register struct tcb *tcb,
			    register struct tcp *seg,
			    struct mbuf **bp,
			    int16 *length);
