#ifndef __TELNET
#define __TELNET

#define	LINESIZE	256	/* Length of local editing buffer */
#define TELNET_PORT	23	/* TCP port for telnet service */

/* Telnet command characters */
#define	IAC		255	/* Interpret as command */
#define	WILL		251
#define	WONT		252
#define	DO		253
#define	DONT		254

/* Telnet options */
#define	TN_TRANSMIT_BINARY	0
#define	TN_ECHO			1
#define	TN_SUPPRESS_GA		3
#define	TN_STATUS		5
#define	TN_TIMING_MARK		6
#define	NOPTIONS		6

/* Telnet protocol control block */
struct telnet {
	struct tcb *tcb;
	char state;

#define	TS_DATA	0	/* Normal data state */
#define	TS_IAC	1	/* Received IAC */
#define	TS_WILL	2	/* Received IAC-WILL */
#define	TS_WONT	3	/* Received IAC-WONT */
#define	TS_DO	4	/* Received IAC-DO */
#define	TS_DONT	5	/* Received IAC-DONT */

	char local[NOPTIONS];	/* Local option settings */
	char remote[NOPTIONS];	/* Remote option settings */

	struct session *session;	/* Pointer to session structure */
};
#define	NULLTN	(struct telnet *)0
extern int refuse_echo;

struct telnet *open_telnet();

#endif

int dotelnet(int argc,char *argv[]);
int unix_send_tel(char *buf,int16 n);
int send_tel(char *buf,int16 n);
void tel_input(register struct telnet *tn,struct mbuf *bp);
void rcv_char(register struct tcb *tcb,int16 cnt);
void tn_tx(struct tcb *tcb,int16 cnt);
void t_state(register struct tcb *tcb,char old,char new);
static void free_telnet(struct telnet *tn);
static void willopt(struct telnet *tn,int opt);
static void wontopt(struct telnet *tn,int opt);
static void doopt(struct telnet *tn,int opt);
static void dontopt(struct telnet *tn,int opt);
static void answer(struct telnet *tn,int r1,int r2);


