#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "trace.h"

#define NULLFUNC (int(*)(struct mbuf **,int))0

/* Redefined here so that programs calling dump in the library won't pull
 * in the rest of the package
 */
#ifdef TRACE
static char nospace[] = "No space!!\n";
#endif

int (*func)(struct mbuf **tbp,int i);

#ifdef TRACE
void
dump(struct interface *interface,
	 int direction,
	 unsigned type,
	 struct mbuf *bp)
{
	struct mbuf *tbp;

	if((interface->trace & direction) == 0)
		return;	/* Nothing to trace */

	switch(direction){
	case IF_TRACE_IN:
		printf("%s recv:\n",interface->name);
		break;
	case IF_TRACE_OUT:
		printf("%s sent:\n",interface->name);
		break;
	}
	if(type < NTRACE)
		func = tracef[type];
	else
		func = NULLFUNC;

	dup_p(&tbp,bp,0,len_mbuf(bp));
	if(tbp == NULLBUF){
		printf(nospace);
		fflush(stdout);
		return;
	}
	if(func != NULLFUNC)
		(*func)(&tbp,1);
	if(interface->trace & IF_TRACE_ASCII){
		/* Dump only data portion of packet in ascii */
		ascii_dump(&tbp);
	} else if(interface->trace & IF_TRACE_HEX){
		/* Dump entire packet in hex/ascii */
		free_p(tbp);
		dup_p(&tbp,bp,0,len_mbuf(bp));
		if(tbp != NULLBUF)
			hex_dump(&tbp);
		else
			printf(nospace);
	}
	free_p(tbp);
	fflush(stdout);
}
#endif

/* Dump an mbuf in hex */
void
hex_dump(struct mbuf **bpp)
{
	int16 n;
	int16 address;
	char buf[16];

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	address = 0;
	while((n = pullup(bpp,buf,16)) != 0){
		fmtline(address,buf,n);
		address += n;
	}
}
/* Dump an mbuf in ascii */
void
ascii_dump(struct mbuf **bpp)
{
	char c;
	int16 tot;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	tot = 0;
	while(pullup(bpp,&c,1) == 1){
		if((tot % 64) == 0)
			printf("%04x  ",tot);
		if(isprint(c))
			putchar(c);
		else
			putchar('.');
		tot++;
		if((tot % 64) == 0)
			printf("\n");
	}
	if((tot % 64) != 0)
		printf("\n");
}
/* Print a buffer up to 16 bytes long in formatted hex with ascii
 * translation, e.g.,
 * 0000: 30 31 32 33 34 35 36 37 38 39 3a 3b 3c 3d 3e 3f  0123456789:;<=>?
 */
void
fmtline(int16 addr,char *buf,int16 len)
{
	char line[80];
	char *aptr,*cptr;
	int16 c;

	for(cptr = line;cptr < &line[80];cptr++)
		*cptr = ' ';
	ctohex(line,(int16)hibyte(addr));
	ctohex(line+2,(int16)lobyte(addr));
	aptr = &line[6];
	cptr = &line[55];
	while(len-- != 0){
		c = *buf++ & 0xff;
		ctohex(aptr,c);
		aptr += 3;
		c &= 0x7f;
		if(isprint(c)){
			*cptr++ = c;
		} else {
			*cptr++ = '.';
		}
	}
	*cptr++ = '\r';
	*cptr++ = '\n';
	fwrite(line,1,(unsigned)(cptr-line),stdout);
}

/* Convert byte to two ascii-hex characters */
static
void
ctohex(char *buf,int16 c)
{
	static char hex[] = "0123456789abcdef";

	buf[0] = hex[hinibble(c)];
	buf[1] = hex[lonibble(c)];
}

