#include "netuser.h"

/* User Datagram Protocol definitions */

#define	NUDP	20

/* Structure of a UDP protocol header */
struct udp {
	int16 source;	/* Source port */
	int16 dest;	/* Destination port */
	int16 length;	/* Length of header and data */
	int16 checksum;	/* Checksum over pseudo-header, header and data */
};
#define	UDPHDR	8	/* Length of UDP header */

/* User Datagram Protocol control block
 * Each entry on the receive queue consists of the
 * remote socket structure, followed by any data
 */
struct udp_cb {
	struct udp_cb *prev;	/* Linked list pointers */
	struct udp_cb *next;
	struct socket socket;	/* Local port accepting datagrams */
	void (*r_upcall)(struct socket *socket,int rcvcnt);	/* Function to call when one arrives */
	struct mbuf *rcvq;	/* Queue of pending datagrams */
	int rcvcnt;		/* Count of pending datagrams */
};
extern struct udp_cb *udps[];	/* Hash table for UDP structures */
#define	NULLUDP	(struct udp_cb *)0

/* UDP statistics counters */
struct udp_stat {
	int16 rcvd;		/* Packets received */
	int16 sent;		/* Packets sent */
	int16 cksum;		/* Checksum errors */
	int16 unknown;		/* Unknown socket */
	int16 bdcsts;		/* Incoming broadcasts */
};

/* UDP primitives */
void udp_dump();

int open_udp(struct socket *lsocket,void (*r_upcall)());
int send_udp(struct socket *lsocket,	/* Source socket */
			 struct socket *fsocket,	/* Destination socket */
			 char tos,					/* Type-of-service for IP */
			 char ttl,					/* Time-to-live for IP */
			 struct mbuf *bp,			/* Data field, if any */
			 int16 length,				/* Length of data field */
			 int16 id,					/* Optional ID field for IP */
			 char df);					/* Don't Fragment flag for IP */
int recv_udp(struct socket *lsocket,	/* Local socket to receive on */
			 struct socket *fsocket,	/* Place to stash incoming socket */
			 struct mbuf **bp);			/* Place to stash data packet */
int del_udp(struct socket *lsocket);
void udp_input(struct mbuf *bp,
			   char protocol,
			   int32 source,		/* Source IP address */
			   int32 dest,			/* Dest IP address */
			   char tos,
			   int16 length,
			   char rxbroadcast);	/* The only protocol that accepts 'em */
struct mbuf *htonudp(struct udp *udp,struct mbuf *bp,struct pseudo_header *ph);
void ntohudp(struct udp *udp,struct mbuf **bpp);
