/* UDP-related user commands */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "udp.h"
#include "internet.h"
#include "cmdparse.h"
#include "udpcmd.h"

struct cmds udpcmds[] = {
	"status",	doudpstat,	0,	NULLCHAR,	NULLCHAR,	0,
	NULLCHAR,	NULLFP,		0,
		"udp subcommands: status",	NULLCHAR,	0
};

int
doudp(int argc,char *argv[])
{
	return subcmd(udpcmds,argc,argv);
}

/* Dump UDP statistics and control blocks */
int 
doudpstat(int argc,char *argv[])
{
	extern struct udp_stat udp_stat;
	register struct udp_cb *udp;
	register int i;

	printf("sent %u rcvd %u bdcsts %u cksum err %u unknown socket %u\n",
	udp_stat.sent,udp_stat.rcvd,udp_stat.bdcsts,udp_stat.cksum,udp_stat.unknown);
	printf("    &UCB Rcv-Q  Local socket\n");
	for(i=0;i<NUDP;i++){
		for(udp = udps[i];udp != NULLUDP; udp = udp->next){
			printf("%8lx%6u  %s\n",(long)udp,udp->rcvcnt,
			 psocket(&udp->socket));
		}
	}
	return 0;
}

