/*****************************************************************************/
/*                                                                           */
/* SCRN.H   -   Bildschirm Steuerung VT-52 ( (c) RDS-Software 08.08.1985)    */
/*                                                                           */
/*****************************************************************************/
                                 /*                                          */
#define _p(c)  putchar(c)        /* Nur eine Abkuerzung fuer das Kommende... */
#define _pe(c) _p(ESC),_p(c)     /*                                          */
                                 /*                                          */
/*****************************************************************************/
/*   Die folgenden Funktionen loeschen Bereiche des Bildschirms              */
/*****************************************************************************/
                                          /*                                 */
#define cls()        _pe('E')             /* Bildschirm ganz loeschen        */
#define clrr()       _pe('J')             /* Cursor bis Ende                 */
#define clrh()       _pe('d')             /* Home   bis Cursor               */
#define clrl()       _pe('l')             /* Zeile ganz, CR ausgeben         */
#define clrc()       _pe('o')             /* Zeile bis Cursor                */
#define clre()       _pe('K')             /* Cursor bis Zeilenende           */
                                          /*                                 */
/*****************************************************************************/
/*   Die folgenden Funktionen bewegen den Cursor                             */
/*****************************************************************************/
                                          /*                                 */
                                          /* Cursor in Pos. X/Y setzen       */
#define locate(x,y)  _pe('Y'),_p((y)+32),_p((x)+32)   /*                     */
                                          /*                                 */
#define home()       _pe('H')             /* Cursor Home                     */
#define crs_up()     _pe('A')             /* Cursor up   ohne Scrollen       */
#define crs_down()   _pe('B')             /* Cursor down ohne Scrollen       */
#define crs_right()  _pe('C')             /* Cursor right                    */
#define crs_left()   _pe('D')             /* Cursor left                     */
#define crs_sup()    _pe('I')             /* Cursor up   mit Scrollen        */
#define crs_sdown()  _p(LF)               /* Cursor down mit Scrollen        */
#define crs_sve()    _pe('j')             /* Cursorposition saven            */
#define crs_get()    _pe('k')             /* Cursorposition nach save holen  */
                                          /*                                 */
/*****************************************************************************/
/*   Sonstige Funktionen ...                                                 */
/*****************************************************************************/
                                          /*                                 */
#define lins()       _pe('L')             /* Zeile einfuegen                 */
#define ldel()       _pe('M')             /* Zeile ausloeschen               */
#define color(x)     _pe('b'),_p(x)       /* Farbe x setzen                  */
#define mode(x)      _pe('c'),_p(x)       /* Attribut x setzen               */
#define crs_on()     _pe('e')             /* Cursor einschalten              */
#define crs_off()    _pe('f')             /* Cursor ausschalten              */
#define rvs_on()     _pe('p')             /* Reverse on                      */
#define rvs_off()    _pe('q')             /* Reverse off                     */
#define wrap()       _pe('w')             /* Zeilenumbruch an                */
#define nowrap()     _pe('v')             /* Zeilenumbruch aus               */
                                          /*                                 */
/*****************************************************************************/
                                          /*                                 */
#define SCREEN_X   80                     /* Anzahl Spalten                  */
#define SCREEN_Y   25                     /* Anzahl Zeilen                   */
                                          /*                                 */
/*****************************************************************************/
