*
*  TESTPROGRAMM FUER ASSEMBLER UNTER TOS
*
* DAS PROGRAMM FRAGT DIE TASTATUR AB UND ZEIGT SCANCODE UND TASTENCODE
* AUF DEM BILDSCHIRM AN
*
*
CR    .EQU     $0D
LF    .EQU     $0A
ESC   .EQU     $1B
*
   .GLOBL   _MAIN
*
*
_MAIN:
      MOVE.L   #SIGNON,-(SP)
      MOVE     #$9,-(SP)
      TRAP     #1          * SIGNON- MELDUNG AUSGEBEN
      ADDQ.L   #6,SP
*
LOOP:
      MOVE.W   #7,-(SP)
      TRAP     #1          * CONSOLE INPUT OHNE ECHO
      ADDQ.L   #2,SP
*
      MOVE.L   D0,D2
      CMP.B    #3,D2       * ABBRECHEN MIT CONTROL- C
      BEQ      EXIT
*
      MOVE.L   #LEADIN,-(SP)
      MOVE     #9,-(SP)
      TRAP     #1          * LEAD- IN- STRING
      ADDQ.L   #6,SP
*
* TASTATURCODE AUSGEBEN
*
      MOVE.B   #" ",D1     * D1 IST REGISTER FUER PRAEFIX
      MOVE.B   #" ",D3     * D3 IST REGISTER FUER POSTFIX
      MOVE.B   D2,D4       * D4 IST REGISTER FUER ASCII- ZEICHEN
      CMP.B    #$80,D2
      BCS      NOHIB       * HIGHBIT IST NICHT GESETZT
HIBIT:
      MOVE.B   #".",D3
      BCLR     #7,D4       * HIGHBIT RUECKSETZEN
NOHIB:
      CMP.B    #" ",D4
      BGE      NOCNT       * KEIN CONTROLCODE
      MOVE.B   #"^",D1
      BSET     #6,D4
NOCNT:
      MOVE.W   D1,-(SP)
      MOVE     #2,-(SP)
      TRAP     #1          * PRAEFIX AUSGEBEN
      ADDQ.L   #4,SP
      MOVE.W   D4,-(SP)
      MOVE     #2,-(SP)
      TRAP     #1          * ASCII- ZEICHEN AUSGEBEN
      ADDQ.L   #4,SP
      MOVE.W   D3,-(SP)
      MOVE     #2,-(SP)
      TRAP     #1          * POSTFIX AUSGEBEN
      ADDQ.L   #4,SP
*
      MOVE.L   #DELIM0,-(SP)
      MOVE     #9,-(SP)
      TRAP     #1
      ADDQ.L   #6,SP
*
      BSR      HEXOU2
*
      MOVE.L   #DELIM1,-(SP)
      MOVE     #$9,-(SP)
      TRAP     #1          * DELIMITER 1 AUSGEBEN
      ADDQ.L   #6,SP
*
* SCANCODE AUSGEBEN
*
      SWAP     D2          * SCANCODE IM UNTEREN WORD
      JSR      HEXOU2
      MOVE.L   #DELIM2,-(SP)
      MOVE     #9,-(SP)
      TRAP     #1          * 2. DELIMITER AUSGEBEN
      ADDQ     #6,SP
*
      BRA      LOOP



*
* 2 DIGITS HEX AUS D2 AUSGEBEN
*
HEXOU2:
      MOVE.B   D2,D1
      LSR.B    #4,D1       * HIGHER NIBBLE
      JSR      HEXOU1
      MOVE.B   D2,D1
      AND.B    #$0F,D1     * LOWER NIBBLE
*
* 1 DIGIT HEX AUS D1 AUSGEBEN
*
HEXOU1:
      ADD.B    #"0",D1
      CMP.B    #":",D1
      BLT      MKHX1
      ADD.B    #7,D1
MKHX1:
      MOVE.W   D1,-(SP)
      MOVE     #2,-(SP)
      TRAP     #1          * HEXDIGIT AUSGEBEN
      ADDQ     #4,SP
      RTS
*
*
EXIT:
      RTS
*
*
SIGNON:
      DC.B     ESC,"E",LF  * CLEAR SCREEN
      DC.B     "Anzeige Tastencode - Scancode    ...   abbrechen mit control-C"
      DC.B     CR,LF,LF,0
*
LEADIN:
      DC.B     ESC,"Y",5+31,1+31    * CURSOR ZEILE 5, SPALTE 1
      DC.B     "Tastencode = ",0
DELIM0:
      DC.B     ",  ",0
DELIM1:
      DC.B     "H,  Scancode = ",0
DELIM2:
      DC.B     "H",CR,LF,0
*
*
   .END

