MODULE APDemo;

(* ------------------------------------------------------------------------

        APDemo : Application Library Demo Program

 This program demonstrates the use of several of the Modula-2/ST application
 library modules. Extensive comments within the source should aid you in
 your understanding of these modules.

   ------------------------------------------------------------------------ *)
(*
        Version     :  1.10b  24-Apr-86  Paul Curtis, Modula-2 Software Ltd.
                           Fixed some comments for final release
                       1.10a  21-Apr-86  Phil Camp, Modula-2 Software Ltd.
                           Added more library usage
                       1.00a  15-Apr-86  Paul Curtis, Modula-2 Software Ltd.
                           Original "Squiral" demo

*)

(* -------------------------------------------------------------- *)
(* (c) Copyright Modula-2 Software Ltd. 1986. All Rights Reserved *)
(* -------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc. 1986.      All Rights Reserved *)
(* -------------------------------------------------------------- *)

  (* IMPORTs from the application library *)
  IMPORT Windows, GraphicWindows, TextWindows, DisplayDriver;
  FROM ApplicationBase IMPORT CloseApplication;
  FROM EventDispatcher IMPORT DispatchEvents;
  FROM DisplayDriver IMPORT Clear, ClipRectangle, CloseDisplay;

  (* IMPORTs from the standard library *)
  FROM Storage IMPORT CreateHeap;

  (* IMPORTs from the GEM library *)
  IMPORT AESWindows, AESGraphics, GEMAESbase;

  VAR OpenWindows: CARDINAL; (* Count of open windows *)

  (* ------------------------------------------------------------------- *)

  MODULE SquiralWindows;
  (* This is a local module to control the graphics windows, each of which
     has a simple "squiral" pattern drawn in it. *)

    FROM GraphicWindows IMPORT OpenGraphicWindow, CloseGraphicWindow,
      WindowElements, Window, Reason, SetPen, Move, Turn, TurnTo, Update, Done;
    FROM Windows IMPORT WindowElement, AllElements;
    FROM DisplayDriver IMPORT Clear, ClipRectangle;
    FROM AESWindows IMPORT WindowUpdate;
    FROM AESGraphics IMPORT GrafMouse;
    FROM GEMAESbase IMPORT BeginMouseControl, EndMouseControl,
      BeginUpdate, EndUpdate, MouseOn, MouseOff;

    IMPORT OpenWindows;

    EXPORT InitSquirals;

    CONST
      angle = 122;
      MaxLength = 190;

    PROCEDURE DoSquiral(w: Window; length: CARDINAL);
      (* Recursive routine to draw a "squial" pattern in the window *)
    BEGIN
      IF length < MaxLength THEN
        Move(w,length); (* Move the pen *)
        Turn(w,angle);  (* Turn the pen by angle *)
        DoSquiral(w,length+2); (* Call ourself until length too big *)
      END
    END DoSquiral;

    PROCEDURE Restore(w: Window; r: Reason; I1,I2,I3,I4: INTEGER);
      (* This is the main control routine for the squiral windows. It is
         called by the library module GraphicsWindows when the user acts
         upon a window and a refresh is needed. *)
    BEGIN
      (* Tell GraphicsWindows we are updating *)
      Update := TRUE;

      (* Tell the GEM AES that we are updating the windows *)
      WindowUpdate(BeginMouseControl);
      WindowUpdate(BeginUpdate);
      GrafMouse(MouseOff,0);
      IF r = Redraw THEN    (* All or portion of window needs refreshing *)
        (* Set clip rectangle to area supplied by GraphicWindows *)
        ClipRectangle(I1,I2,I3,I4); 
        (* Clear the rectangle to white *)
        Clear;
        SetPen(w,118,102);  (* Move the pen back to origin in the window *)
        TurnTo(w,0);        (* Reset angle *)

        (* Draw the squiral to refresh only the clipped area *)
        DoSquiral(w,7);
      ELSIF r = Closed THEN (* user closed a squiral window *)
        DEC(OpenWindows); 
      END;

      (* tell GEM AES that we have finished doing the update *)
      WindowUpdate(EndMouseControl);
      WindowUpdate(EndUpdate);

      GrafMouse(MouseOn,0);

      (* Tell GraphicsWindows we are finished updating *)
      Update := FALSE
    END Restore;

    PROCEDURE NewWindow;
      (* Open the next squiral window *)
    VAR w: Window;
    BEGIN
      (* OpenWindows is used to offset the origin of earch window *)
      OpenGraphicWindow(w,WindowElements{Moveable,CloseButton,Title},
        30+(OpenWindows*10),30+(OpenWindows*10),230,230,
        " Squiral Window ",Restore);
      IF Done THEN INC(OpenWindows) END
    END NewWindow;

    PROCEDURE InitSquirals;
      (* Start all the squiral windows *)
    VAR i: CARDINAL;
    BEGIN
      FOR i := 0 TO 3 DO
        NewWindow        (* open squiral windows *)
      END
    END InitSquirals;

  END SquiralWindows;

  (* ------------------------------------------------------------------- *)

  MODULE TextualWindows;
    (* This is a local module to control the text windows, each of which
       has a simple text pattern drawn in it. *)

    FROM TextWindows IMPORT OpenTextWindow, CloseTextWindow, Write, 
      AssignRestoreProc, Reason, WriteString, WriteLn, Window, Done;
    FROM Windows IMPORT AllElements, DrawInfo;

    IMPORT OpenWindows;

    EXPORT InitTexts;

    PROCEDURE RestoreText(Win: Window; Rea: Reason; I1,I2,I3,I4: INTEGER);
      (* This is the main control routine for the text windows. It is called
         by the library module TextWindows when the user acts upon a window
         and a refresh or other action is needed. *)
    BEGIN
      (* Determine the reason for the refresh call then show it in window *)
      CASE Rea OF
        Closed:
          DEC(OpenWindows)  (* user closed a window *)
      | Topped:      DrawInfo(Win,"Topped")
      | PageUp:      DrawInfo(Win,"PageUp")
      | PageDown:    DrawInfo(Win,"PageDown")
      | RowUp:       DrawInfo(Win,"RowUp")
      | RowDown:     DrawInfo(Win,"RowDown")
      | PageLeft:    DrawInfo(Win,"PageLeft")
      | PageRight:   DrawInfo(Win,"PageRight")
      | ColumnLeft:  DrawInfo(Win,"ColumnLeft")
      | ColumnRight: DrawInfo(Win,"ColumnRight")
      | NewTop:      DrawInfo(Win,"NewTop")
      ELSE (* don't process *)
      END
    END RestoreText;

    PROCEDURE InitTexts;
    VAR i, i2: CARDINAL;
      w: Window;
    BEGIN
      (* open the text windows *)
      FOR i := 0 TO 2 DO
        OpenTextWindow(w,AllElements,30+(OpenWindows*10),30+(OpenWindows*10),
                       200,200," Text Window ");
        IF Done THEN (* window opened *)
          INC(OpenWindows);
          (* assign the new restore procedure *)
          AssignRestoreProc(w,RestoreText);
          (* put some text in the window *)
          FOR i2 := 0 TO 20 DO
            WriteString(w,"Modula-2/ST Application library demo program.");
            WriteLn(w)
          END
        END
      END
    END InitTexts;

  END TextualWindows;

(* ------------------------------------------------------------------- *)

BEGIN
  (* Create a large heap because the TextWindows module needs quite a lot *)
  IF NOT(CreateHeap(16*1024,TRUE)) THEN HALT END;
  OpenWindows := 0;
  (* init all the windows *)
  InitSquirals;
  InitTexts;
  REPEAT
    DispatchEvents;
  UNTIL OpenWindows = 0; (* until all windows have been closed *)
  (* close the library modules correctly *)
  CloseDisplay;
  CloseApplication;
END APDemo.
