MODULE Spooler;

(* ---------------------------------------------------------- *)
(* Copyright (c) 1985, 1986, 1987.Modula-2 Software Ltd.  UK  *)
(*                           and  TDI Software, Inc.      USA *)
(* ---------------------------------------------------------- *)

(* Spooler desk accessory.

   Original Author : PLC, Modula-2 Software Ltd,. UK

   Version         : 0.00b  24-Apr-86  PLC, Modula-2 Software Ltd.
                       Fixed Alloc bug.
                     0.00a  13-Mar-86  PLC, Modula-2 Software Ltd.
                       Original.

*)

(* Spooler information.

   This is a small spooler desk accessory to show how limited multitasking
   can be accomplished under GEM and how a desk accessory can be programmed.
   The 512 byte stack allocated by the runtime support is ample for this
   accessory. After linking, rename SPOOLER.PRG to SPOOLER.ACC using the
   file menu "Show Info" option. Copy SPOOLER.ACC to a boot disk and reboot
   the system. The Spooler should install itself in the Desk menu.
*)

(*$T-,$S-*)

FROM SYSTEM IMPORT ADR, ADDRESS;
FROM AESApplications IMPORT ApplInitialise;
FROM GEMAESbase IMPORT AccessoryOpen, MesageEvent, TimerEvent, AESCallResult;
FROM AESForms IMPORT FileSelectorInput, FormAlert;
FROM AESMenus IMPORT MenuRegister;
FROM AESEvents IMPORT EventMultiple;
FROM GEMDOS IMPORT Alloc, Free, Open, Close, Read, Seek, PrnOS, PrnOut,
  beginning, end;

CONST
  MaxPrinterSpeed = 80;  (* 80 cps. Could handle higher rates *)

CONST
  (* number of milliseconds to wait for next character output *)
  SensePeriod = 1000 DIV MaxPrinterSpeed;

CONST 
  Title = "  Spooler";

VAR
  applID: INTEGER;  (* desk application ID *)
  menuID: INTEGER;  (* menu ID *)
  Msg: ARRAY [0..16] OF INTEGER;  (* message buffer *)
  handle, events, x: INTEGER;
  i, place: CARDINAL;
  path: ARRAY [0..39] OF CHAR;
  file: ARRAY [0..19] OF CHAR;
  printing: BOOLEAN;  (* TRUE if currently printfile a file *)
  adr: ADDRESS;  (* base address of file memory buffer *)
  prnadr: POINTER TO CHAR;
  length: LONGCARD;  (* length of file, and of memory block *)

PROCEDURE DoSpool(VAR x: ARRAY OF CHAR): BOOLEAN;
VAR res: INTEGER;
  lc: LONGCARD;
BEGIN
  (* open file *)
  Open(x,0,handle);
  IF handle <= 0 THEN
    res := FormAlert(1,"[2][File not found][ OK ]");
    RETURN FALSE
  END;

  (* get file length *)
  Seek(0,handle,end,length);
  Seek(0,handle,beginning,lc);

  (* grab some memory for the file buffer *)
  Alloc(length,adr);
  IF adr = 0 THEN                                               (*0.00b*)
    (* not enough memory... *)
    IF Close(handle) THEN END;
    res := FormAlert(1,"[1][Not enough memory][ OK ]");
    RETURN FALSE
  END;

  (* read file into buffer *)
  lc := length;
  Read(handle,lc,adr);
  IF Close(handle) THEN END;

  (* take care of read errors *)
  IF lc # length THEN
    res := FormAlert(1,"[2][Read error][ OK ]");
    RETURN FALSE
  END;

  (* set print start address in memory, return "good spool request" *)
  prnadr := adr;
  RETURN TRUE
END DoSpool;


BEGIN
  (* initialise application & install desk accessory *)
  applID := ApplInitialise();
  menuID := MenuRegister(applID,Title);

  printing := FALSE;
  LOOP
    (* set event flags according to print status. This stops the
       accessory from soaking up processor time waiting for a tick
       when it isn't printing. *)
    IF printing THEN events := MesageEvent + TimerEvent
    ELSE events := MesageEvent
    END;
    events := EventMultiple(events,0,0,0,
                            0,0,0,0,0,
                            0,0,0,0,0,
                            ADR(Msg),
                            SensePeriod,0,
                            x,x,x,x,
                            x,x);
    IF ODD(events DIV MesageEvent) THEN
      (* got a message *)
      IF (Msg[0] = AccessoryOpen) THEN
        IF printing THEN
          x := FormAlert(2,"[3][Already spooling][ STOP | OK ]") ;
          IF x = 1 THEN (* STOP *)
            printing := FALSE;
            (* free memory allocated to file buffer *)
            IF Free(adr) THEN END
          END
        ELSE
          path := "A:\*.*";
          file[0] := 0C;

          (* open up file selector *)
          FileSelectorInput(ADR(path),ADR(file),x);

          IF (AESCallResult # 0) & (x = 1) THEN
            (* OK and no error, strip off ambiguous file specification *)
            i := 0;
            place := 0;
            WHILE path[i] # 0C DO
              IF path[i] = "\" THEN place := i END;
              INC(i)
            END;

            (* put filename onto end of path to get full specification *)
            i := 0;
            WHILE file[i] # 0C DO
              path[place] := file[i];
              INC(place); INC(i)
            END;

            (* see if we can spool it *)
            printing := DoSpool(path)
          END
        END
      END
    ELSIF ODD(events DIV TimerEvent) THEN
      (* timer event occured *)
      IF PrnOS() THEN
        (* printer waiting for character *)
        IF LONGCARD(prnadr)-LONGCARD(adr) = length THEN
          (* come to end of buffer, stop printing *)
          printing := FALSE;
          (* free memory allocated to file buffer *)
          IF Free(adr) THEN END
        ELSE
          PrnOut(prnadr^);  (* print buffer character *)
          INC(prnadr)       (* advance to next buffer position *)
        END
      END
    END
  END
END Spooler.
