IMPLEMENTATION MODULE Cube;

(* throw up a rotating cube on the Atari 520 ST --- Chris Hall, 1985 *)

(* --------------------------------------------------------------- *)
(* (c) Copyright Modula 2 Software Ltd 1986.  All rights reserved. *)
(* --------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc 1985, 1986. All rights reserved. *)
(* --------------------------------------------------------------- *)

(*$A+*)
FROM GEMVDIbase IMPORT
     (* types *) VDIWorkInType, VDIWorkOutType ;

FROM VDIControls IMPORT
     (* procs *) OpenVirtualWorkstation, CloseVirtualWorkstation ;

FROM VDIOutputs IMPORT
     (* procs *) PolyLine ;

FROM VDIAttribs IMPORT
     (* procs *) SetWritingMode, SetColour;

FROM AESGraphics IMPORT
     (* procs *) GrafHandle;

FROM GemDem IMPORT WorkY, WorkHeight ;


CONST lines      = 12;     (* a cube has 12 lines *)
      vertices   = 8;      (* and eight corners   *)
      maxNoLines = 100;
      distance   = 2000.0; (* viewing distance    *)
      sinphi     = (* sin (PI/16) *) 0.195090322;
      cosphi     = (* cos (PI/16) *) 0.980785280;

TYPE LineSegment  = ARRAY [0..3] OF INTEGER;
     PolyLineType = ARRAY [1..lines] OF LineSegment;

VAR start,
    finish     : ARRAY [1..lines]    OF CARDINAL;
    x, y, z    : ARRAY [1..vertices] OF REAL;
    x2d, y2d   : ARRAY [1..vertices] OF INTEGER;
    whichArray : BOOLEAN;
    polyLine   : ARRAY BOOLEAN OF PolyLineType;
    lineLength : REAL ;    (* length of cube line *)
    addingX    : REAL ;    (* for centering image *)
    addingY    : REAL ;


PROCEDURE XRotation;

VAR i    : CARDINAL;
    Y, Z : REAL;

BEGIN
  FOR i := 1 TO vertices DO
    Y := y [i]; Z := z [i];
    y [i] := Y * cosphi - Z * sinphi;
    z [i] := Z * cosphi + Y * sinphi;
  END; (* FOR *)
END XRotation;


PROCEDURE YRotation;

VAR i    : CARDINAL;
    X, Z : REAL;

BEGIN
  FOR i := 1 TO vertices DO
    X := x [i]; Z := z [i];
    x [i] := X * cosphi - Z * sinphi;
    z [i] := Z * cosphi + X * sinphi;
  END; (* FOR *)
END YRotation;


PROCEDURE ZRotation;

VAR i    : CARDINAL;
    X, Y : REAL;

BEGIN
  FOR i := 1 TO vertices DO
    X := x [i]; Y := y [i];
    x [i] := X * cosphi - Y * sinphi;
    y [i] := Y * cosphi + X * sinphi;
  END; (* FOR *)
END ZRotation;


PROCEDURE DrawShape;

VAR i : INTEGER;
    d : BOOLEAN;

BEGIN
  d := NOT whichArray;
  FOR i := 1 TO lines DO
    polyLine [whichArray, i, 0] := x2d [start[i]];
    polyLine [whichArray, i, 1] := y2d [start[i]];
    polyLine [whichArray, i, 2] := x2d [finish[i]];
    polyLine [whichArray, i, 3] := y2d [finish[i]];
    PolyLine (handle, 2, polyLine [whichArray, i]);  (* draw new cube *)
    PolyLine (handle, 2, polyLine [d, i]);           (* undraw old cube *)
  END; (*FOR *)
  whichArray := NOT whichArray;
END DrawShape;


PROCEDURE ConvertToXYpairs;

VAR i : CARDINAL;
    f : REAL;

BEGIN
  FOR i := 1 TO vertices DO
    f := 1000.0 / (distance - z [i]);
    x2d [i] := INTEGER(TRUNC( x [i] * f + addingX ));
    y2d [i] := INTEGER(TRUNC( y [i] * f + addingY ));
  END; (* FOR *)
END ConvertToXYpairs;


PROCEDURE SetPoints; (* put points into array *)

BEGIN
  x [1] := -lineLength; y [1] :=  lineLength; z [1] :=  lineLength;
  x [2] :=  lineLength; y [2] :=  lineLength; z [2] :=  lineLength;
  x [3] :=  lineLength; y [3] := -lineLength; z [3] :=  lineLength;
  x [4] := -lineLength; y [4] := -lineLength; z [4] :=  lineLength;
  x [5] := -lineLength; y [5] :=  lineLength; z [5] := -lineLength;
  x [6] :=  lineLength; y [6] :=  lineLength; z [6] := -lineLength;
  x [7] :=  lineLength; y [7] := -lineLength; z [7] := -lineLength;
  x [8] := -lineLength; y [8] := -lineLength; z [8] := -lineLength;
END SetPoints;


PROCEDURE SetLines;

BEGIN
  start [1]  := 1; finish [1]  := 2;
  start [2]  := 2; finish [2]  := 3;
  start [3]  := 3; finish [3]  := 4;
  start [4]  := 4; finish [4]  := 1;
  start [5]  := 1; finish [5]  := 5;
  start [6]  := 2; finish [6]  := 6;
  start [7]  := 3; finish [7]  := 7;
  start [8]  := 4; finish [8]  := 8;
  start [9]  := 5; finish [9]  := 6;
  start [10] := 6; finish [10] := 7;
  start [11] := 7; finish [11] := 8;
  start [12] := 8; finish [12] := 5;
END SetLines;

VAR c, d   : CARDINAL;
    b      : BOOLEAN;
    j      : INTEGER;
    handle : INTEGER;
    In     : VDIWorkInType;
    Out    : VDIWorkOutType;

PROCEDURE DoCube ;
BEGIN 
  FOR c := 0 TO 9 DO In [c] := 1 END;
  In [10] := 2;
  handle := GrafHandle (j, j, j, j);
  OpenVirtualWorkstation (In, handle, Out);
  lineLength := FLOAT(CARDINAL((WorkHeight-WorkY) DIV 2 - 10)) ;
  addingX := FLOAT(CARDINAL(Out[0] DIV 2)) ;
  addingY := FLOAT(CARDINAL(Out[1] DIV 2)) ;
  j := SetWritingMode (handle, 3);
  FOR b := FALSE TO TRUE DO
    FOR c := 1 TO lines DO
      FOR d := 0 TO 3 DO
        polyLine [b, c, d] := 0
      END;
    END;
  END;
  whichArray := FALSE;
  SetPoints;
  SetLines;
  FOR c := 1 TO 2 DO
    YRotation;
    ZRotation;
    END; (* FOR *)
  FOR c := 1 TO 1000 DO
    XRotation;
    ConvertToXYpairs;
    DrawShape;
  END;
  CloseVirtualWorkstation (handle);
END DoCube ;

END Cube.
