IMPLEMENTATION MODULE Fractal;

(* Atari 520 ST demo module : Draws fractal tree.      *)

(* --------------------------------------------------------------- *)
(* (c) Copyright Modula 2 Software Ltd 1986.  All rights reserved. *)
(* --------------------------------------------------------------- *)
(* (c) Copyright TDI Software Inc 1985, 1986. All rights reserved. *)
(* --------------------------------------------------------------- *)

(*$T-*)(*$S-*)(*$A+*)

FROM GEMVDIbase IMPORT
     (* types *) VDIWorkInType, VDIWorkOutType ;

FROM VDIControls IMPORT
     (* procs *) OpenVirtualWorkstation, CloseVirtualWorkstation ;

FROM VDIOutputs IMPORT
     (* procs *) PolyLine;

FROM VDIAttribs IMPORT
     (* procs *) SetLineColour ;

FROM AESGraphics IMPORT
     (* procs *) GrafHandle;

FROM GemDem IMPORT
     (* Vars  *) WorkX, WorkY, WorkWidth, WorkHeight, Colour ;

CONST xScaler = 1.0;
      yScaler = 1.0;

VAR (* these are used inside 'split' *)
    xMax           : REAL ;
    yMax           : REAL ;
    dx,dy, 
    cosphi, sinphi : REAL;
    tab            : ARRAY [0..20] OF REAL;
    Points         : ARRAY [0..3] OF INTEGER;


PROCEDURE split ( sx, sy, ex, ey : REAL; level : CARDINAL );

VAR midx, midy, oldlen, newlen, costheta, sintheta : REAL; i : INTEGER ;

BEGIN
  IF Colour AND ( level > 10 ) THEN
    i := SetLineColour(handle,3) ;
  ELSE
    i := SetLineColour(handle,1) ;
  END ;
  midx := (sx + ex) / 2.0;
  midy := (sy + ey) / 2.0;
  dx := ex - sx;
  dy := ey - sy;
  oldlen := tab [level-1] * 150.0 ;
  newlen := tab [level] * 150.0;
  costheta := dx / oldlen;
  sintheta := dy / oldlen;
  (* draw a line from sx,sy to midx,midy *)
  Points [0] := TRUNC (sx);
  Points [1] := TRUNC (yMax - sy);
  Points [2] := TRUNC (midx);
  Points [3] := TRUNC (yMax - midy);
  PolyLine (handle, 2, Points);
  IF level < maxlevel THEN
    split (midx, midy, newlen*(costheta*cosphi-sintheta*sinphi)+midx,
                       newlen*(sintheta*cosphi+costheta*sinphi)+midy, level+1);
    split (midx, midy, newlen*(costheta*cosphi+sintheta*sinphi)+midx,
                       newlen*(sintheta*cosphi-costheta*sinphi)+midy, level+1);
  END; (* IF *)
END split;


CONST SplitAngle      = 20.0; (* these give a pretty one *)
      SplitProportion = 0.22; (* discovered by Jon Gray. *)
      maxlevel        = 13;

VAR i      : CARDINAL;
    j      : INTEGER;
    In     : VDIWorkInType;
    Out    : VDIWorkOutType;
    handle : INTEGER;

PROCEDURE DoFractal ;
 VAR mx, my : REAL ;
BEGIN
  xMax := FLOAT(CARDINAL(WorkX+WorkWidth)) ;
  yMax := FLOAT(CARDINAL(WorkY+WorkHeight)) ;
  handle := GrafHandle (j, j, j, j);
  FOR i := 0 TO 9 DO In [i] := 1 END;
  In [10] := 2; (* use raster coordinates *)
  OpenVirtualWorkstation (In, handle, Out);
  tab[0] := 3.0;
  cosphi := (* cos (SplitAngle) *) 0.93969262;
  sinphi := (* sin (SplitAngle) *) 0.342020143;
  FOR i := 1 TO HIGH(tab) DO tab[i] := SplitProportion * tab[0] END;
  mx := FLOAT(CARDINAL(WorkX+(WorkWidth DIV 2))) ; (* Mid x point *)
  my := FLOAT(CARDINAL(WorkY+(WorkHeight DIV 2)-50)) ; (* mid Y point *)
  split (mx, 0.0,mx, my, 1);
  CloseVirtualWorkstation (handle);
END DoFractal

END Fractal.
