; Desert Scene Demo of 2-1/2D Cell Animation by David Snyder
; Uses standalone capabilities of CYBER CONTROL.  (ie, CAD-3D 2.0 does
;   not need to be present to create this animation.)
; ***  IMPORTANT NOTE ABOUT MOVING THE FOLDER FROM THE MASTER DISK:  ***
; This is set up to run out of a folder on drive A called DESERT.
;   (just one level deep, instead of two levels as it is on the
;   master disk.
; Change all path/filename references accordingly if you don't
;   have the files set up that way.
; NOTE:  When this animation is displayed with ANIMATE2.PRG, turn
;   buffering ON.
mono

loadbak L,"a:\desert\desbak.pc1",y

input " Watch (0) or Record (1) ? ",option

if option then rstart "a:\desert",m:goto Skipwatch
watch on
@Skipwatch
scrollx = 0:mtns1x = 50:mtns2x = 10:chained = 0:frame = 0

; Change the step value in the for/next line to a 2 to create an 810K file.
; Change it to an 8 to create a 230K file (for single-sided drives).
;   (however, with a step value of 8, the 230K file is so rough that
;   it's hard to get a clear idea of what the 2-1/2D effect is doing.
; If you have two single sided drives, or one double-sided drive,
;   you'll have no problem using the default value of 4.  If you have
;   one double and one single-sided drive (or 2 doubles), go ahead and
;   change it to 8 now, but make sure you have a formatted disk in drive B.
; Using the current value (4), will produce a roughly 450K file.
; All files could be on drive A with a step value of 4 if you're using
;   a double-sided disk.
for I = 1 to 160 step 4:; Set to 420K now.
Backset L

getimage "a:\desert\rdlin.bl1",w,h
overlay L,scrollx,160:overlay L,scrollx+320,160:overlay L,scrollx+640,160
overlay L,scrollx+960,160
scrollx = -6 * I


getimage "a:\desert\mtn12.bl1",w1,h1
overlay L,mtns1x,45:overlay L,mtns1x+320,45
mtns1x = 50 + ( -2 * I )

getimage "a:\desert\mtn34.bl1",w2,h2
overlay L,mtns2x,48:overlay L,mtns2x+320,48:overlay L,mtns2x+640,48
mtns2x = 10 + ( -4 * I )

getimage "a:\desert\sign.bl1",w3,h3
overlay L,160+scrollx,90:overlay L,480+scrollx,90:overlay L,800+scrollx,90
overlay L,1120+scrollx,90

if option then record
frame = frame + 1

if FREEDISK<10000 & option then gosub dochain

next I
if option then rstop:end
watch off:end
; The next line sets up auto-chaining to drive B if you've got a two-
; drive system -- a blank formatted disk must be in drive B.
@dochain:chained = 1:? "chained":rchain "b:desert2":return
