
; Tree-structure demo: Luxo Jr. (Jr.)
; (With apologies to Pixar)
; by Tom Hudson
; Lamp and geometric objects created with CAD-3D
; Floor created with FUNCTION.CTL (15 grids, Z=0)
;
; This animation control file demonstrates hierarchical object definition
; and also shows how to slave a light source to a 3D model!

input "Watch (0) or Record (1)?",option

; Load LAMP.3D2, set up tree structure & lamp movement splines

load3d "a:\lamp\lamp.3d2"
gosub DEFINELAMP
gosub DEFSPLINES

; Set up camera

zoom 79:perspec 999:cam1 39,19,0:mono:draft

; Start watching or recording, depending upon option selected

if option then rstart "a:\lamp",m:view solid:goto RUNIT
watch on:view wire

; Run the sequence!
;
; NOTE: "frame" runs from 0-98 because we have set up a 100-point spline,
; which runs from 0-99, and the 99th spline position is the same as the
; 0th spline position.  To avoid a duplicate frame at the end of the
; animation, we stop at 98.

@RUNIT
for frame=0 to 98
load3d "a:\lamp\lamp.3d2"

; Position the lamp!

position botarm,s1x(frame),0,s1z(frame)
position toparm,s2x(frame),0,0
position shade,s3x(frame),0,s3z(frame)
treeset base

; Locate lampshade & bulb centerpoint, move light source B to that point!

clrgrp:select shade:grpcent cx,cy,cz
direct b,6,cx/100,cy/100,cz/100:lton b

; Generate superview and record if necessary

allgrp:superview
if option then record
next frame

; Animation is complete, stop watching/recording

if option then rstop:end
watch off:end

;**************************** Subroutines ******************************

; Define the lamp!  Set up objects in lamp, set up their operational
; limits, and define their relationships to each other.
;
; NOTE: The "elbow", "shoulder" and "pivot" objects are used as both
; pivot points and tree objects.  This is perfectly OK -- they function
; fine as pivot points, and since they are used as tree objects, they are
; shown after TREESET.  This allows us to avoid unnecessary pivot objects!
; All three pivot objects are related to the object which pivots around
; them, with themselves referenced as their own pivot points.  Since none
; of these pivot objects are ever POSITIONed, this relationship is fine.
; If they were POSITIONed, they would simply rotate about their own
; center points.

@DEFINELAMP
treeclr
treeadd base,shoulder,botarm,elbow,toparm,pivot,shade
limit botarm,0,90,0,0,-180,180
limit toparm,-140,0,0,0,0,0
limit shade,-45,45,0,0,-90,90
relate botarm,base,shoulder
relate shoulder,botarm,shoulder
relate toparm,botarm,elbow
relate elbow,toparm,elbow
relate pivot,toparm,pivot
relate shade,toparm,pivot
return

; This subroutine defines the splines that are used to move
; all of the joints in the object.
;
; The first and last position in each spline is the same, allowing our
; animation to loop back to the starting point.

@DEFSPLINES

; Bottom arm spline

defpt 1,45,0,-30
defpt 1,30,0,-70
defpt 1,20,0,-100
defpt 1,40,0,-60
defpt 1,40,0,-20
defpt 1,60,0,0
defpt 1,45,0,-30
defspline 1,100,S

; Top arm spline

defpt 2,-40,0,0
defpt 2,-50,0,0
defpt 2,-90,0,0
defpt 2,-120,0,0
defpt 2,-80,0,0
defpt 2,-40,0,0
defspline 2,100,S

; Lamp shade spline

defpt 3,0,0,0
defpt 3,-30,0,0
defpt 3,-10,0,0
defpt 3,20,0,-30
defpt 3,10,0,30
defpt 3,0,0,0
defspline 3,100,S

return

