; Omni Extruder/Animator Version 1.0 -- MONO/STEREO RUBBERNECK
; by Darrel Anderson
; for Cyber Control
;
; Requires the following files in drive A: THROUGHOUT the recording:
; ZZSPLINE.3D2 ZZCROSEC.3D2 ROBOHEAD.3D2
; L_RUBBER.PC1 R_RUBBER.PC1 (R_RUBBER.PC1 for STEREO only)
; FLEXDATA.DAT OMNI_50.CAP
;
; Double Sided Disk has room for all files + Stereo recording.
; Single Sided Disk has room for all files + Mono Recording.
; ("Twisting" the disk to increase storage is recommended so
; you can fit the data files in the RUBERNEK folder on your
; same disk as the animation is being recorded onto.
; 
; Convert .PC1 files to .PC3 files for HIGH-REZ recording.
; Disk Space requirements for HIGH-REZ unknown. See Cyber-Control
; Documentation for chaining techniques.
;
; Make sure that the RUBERNEK folder from your master Cyber Control
; disk has been moved to a freshly-formatted (preferably double-sided)
; data disk on which the animation will be recorded.  All the
; RUBERNEK files must be in that folder (just one level deep compared
; to two folder deep, as it is on the Cyber Control disk) and the
; disk must be in Drive A.  If you want to change the drive/path
; for this animation, just do a Find on A:\RUBERNEK\ and change
; it to whatever drive/path you want.
;
dim xrotary(50),yrotary(50),zrotary(50),xpnt(20),ypnt(20),zpnt(20)
@SELECTMODE
input "Enter 0:Mono 1:Stereo",opt0
if opt0 > 1 | opt0 < 0 then goto SELECTMODE 

;_____________________________________________________SPECFIC_TREE_INFO___
;-------------------------------------------------------------------------
dim csrot(100),trot(40),px(50),py(50),pz(50)
@NECKSPLINE
defpt 1,0,0,0
defpt 1,15,5,-20
defpt 1,35,30,-40
defpt 1,-15,-10,0
defpt 1,0,0,0
defspline 1,50,S

for l=0 to 49
px(l)=s1x(l):py(l)=s1y(l):pz(l)=s1z(l)
next l

;____________________________________________________________SETUP_TREE___
load3d "A:\RUBERNEK\ROBOHEAD.3D2"
status totv,usedv,totf,usedf,objx
others=objx

merge3d "A:\RUBERNEK\ZZSPLINE.3D2"
status totv,usedv,totf,usedf,objs
exkeyz=objs-others

treeclr
treeadd spline0,spline1,spline2,spline3

treeadd eyes,head,crane,Ring12_a,HeadRad,antenna

relate spline1,spline0,spline0
relate spline2,spline1,spline1
relate spline3,spline2,spline2

relate head,spline3,spline3
relate eyes,head,head
relate crane,head,head
relate Ring12_a,head,head
relate HeadRad,head,head
relate antenna,head,head
;__________________________________MULTI_OBJECT_CREATION/RECORDING_LOOP___
if opt0 = 1 then stereo 
for frame=0 to 49
zoom 30:perspec 800
cam2 2500,-2500,200,0,0,-650,0:backgnd yes,yes
load3d "A:\RUBERNEK\ROBOHEAD.3D2"
merge3d "A:\RUBERNEK\ZZSPLINE.3D2"
status totv,usedv,totf,usedf,objz

position spline1, px(i),py(i),pz(i):gosub ROTARRAY
position spline2, px(i),py(i),pz(i):gosub ROTARRAY
position spline3, px(i),py(i),pz(i):gosub ROTARRAY
treeset spline0:goto REINIT

@ROTARRAY
trot(ex)=px(i):trot(ex+1)=py(i):trot(ex+2)=pz(i):ex=ex+3
return
@REINIT
i=i+1
ex=0:faceix=0:vertix=0:treeobj=1:treeani=1:scalsent=0
@NEWSTART
if frame=0 then loadbak L,"A:\RUBERNEK\L_RUBBER.PC1",Y
if frame=0 & opt0=1 then loadbak R,"A:\RUBERNEK\R_RUBBER.PC1",Y
;_______________________________________________END_OF_SPECFIC_SECTION____
if opt0=0 & frame=0 then view s:rstart "A:\RUBERNEC.DLT",m
if opt0=1 & frame=0 then view s:rstart "A:\SRNECK.DLT",s
;__________________________________________________CROSS_SECTION_MERGE____
@MERGEIT
group c:clrgrp
merge3d "A:\RUBERNEK\ZZCROSEC.3D2"
if scalsent then return
status totv,usedv,totf,usedf,objs
if treeani=1 then seckeyz=objs-objz:goto READDATA
;____________________________________________________________READ_DATA____
@READDATA
fopen "A:\RUBERNEK\FLEXDATA.DAT"
ftrap ENDODATA
fread segments,csplinez,cst,est,xst,yst,rst
fread rotopt,mrotopt,xmrotz,ymrotz,zmrotz,scaling,xscalz,yscalz
if rotopt=1 & mrotopt=0 then fread xrot,yrot,zrot
if mrotopt=1 then gosub DATMROT
if scaling=1 then gosub DATSCALE
@ENDODATA:fclose
halfseg=(segments+1)/2
if treeobj then treeseg=segments/(exkeyz-1):gosub TREEARRAY
goto STARTIT

@DATMROT
if xmrotz=0 then goto YROTDAT
for loop=0 to xmrotz-1
fread dat:defpt 5,dat,0,0:next loop
gosub DROTSPLINE
for fil=0 to segments
xrotary(fil)=s5x(fil):next fil
@YROTDAT
if ymrotz=0 then goto ZROTDAT
for loop=0 to ymrotz-1
fread dat:defpt 5,0,dat,0:next loop
for fil=0 to segments
gosub DROTSPLINE
yrotary(fil)=s5y(fil):next fil
@ZROTDAT
if zmrotz=0 then return
for loop=0 to zmrotz-1
fread dat:defpt 5,0,0,dat:next loop
gosub DROTSPLINE
for fil=0 to segments
zrotary(fil)=s5z(fil):next fil
return
@DROTSPLINE
if rst=0 then defspline 5,segments+1,B
if rst=1 then defspline 5,segments+1,L
if rst=2 then defspline 5,segments+1,S
return

@DATSCALE
if xscalz=0 then goto YSCALDAT
for xloop=0 to xscalz-1
fread xdat:defpt 1,xdat,0,0:next xloop
if xst=0 then defspline 1,segments+1,B
if xst=1 then defspline 1,segments+1,L
if xst=2 then defspline 1,segments+1,S
@YSCALDAT
if yscalz=0 then return
for yloop=0 to yscalz-1
fread ydat:defpt 2,0,ydat,0:next yloop
if yst=0 then defspline 2,segments+1,B
if yst=1 then defspline 2,segments+1,L
if yst=2 then defspline 2,segments+1,S
return

;________________________________________________________________START____
@STARTIT
xrot=xrot/segments:yrot=yrot/segments:zrot=zrot/segments
center universe:color=14
gosub XTRUDSPLINE
;_____________________________________________________________MAIN_LOOP___
@FLY

for seg=0 to segments
if rotopt=0 then gosub AUTOROT:bell:next seg:goto ADDFACES
;if scaling=1 | rotopt=1 then gosub SCALEIT
if rotopt=3 then gosub SCALEIT
if scaling=0 & rotopt=2 then gosub CSECSPLINE
for vx=0 to csplinez-1
if crosstype=1 then goto NOCSPLINE
addvertex vertix,s3x(vx)+s4x(seg),s3y(vx)+s4y(seg),s3z(vx)+s4z(seg)
vertix=vertix+1
next vx:bell:next seg
goto ADDFACES

@NOCSPLINE
addvertex vertix,xpnt(vx)+s4x(seg),ypnt(vx)+s4y(seg),zpnt(vx)+s4z(seg)
vertix=vertix+1
next vx:bell:next seg

goto ADDFACES
;________________________________________________________AUTO_ROTATION____
@AUTOROT
group c
D=1:DD=0
if seg+1>halfseg then D=0:DD=1

vecx=s4x(seg+D)-s4x(seg-DD)
vecy=s4y(seg+D)-s4y(seg-DD)
vecz=s4z(seg+D)-s4z(seg-DD)

@AROT2
magv=sqr(vecx*vecx + vecy*vecy + vecz*vecz)
magp=sqr(vecx*vecx + vecy*vecy)
sth=vecy/magp:cth=vecx/magp:cph=vecz/magv:sph=magp/magv

if sph>.70 then goto AROT3
if magp<200 & vecz>0 then gosub AROTSPECIAL:goto AROT4
if magp<200 & vecz<0 then sph=0:cph=-1:if seg>0 then sth=oldsth:cth=oldcth
;if oldvecy*vecy<0 & sph<.50 then gosub AROTSPECIAL:goto AROT3
flag=0

@AROT3
;if sph<.49 & flag= 1 then gosub AROTSPECIAL
@AROT4
oldvecy=vecy
if scaling then gosub SCALEIT:goto AROT5
gosub CSECSPLINE

@AROT5
for cspix=0 to csplinez-1
pxf=s3x(cspix)*sth+s3y(cspix)*cph*cth+s4x(seg)
pyf=(s3y(cspix)*cph*sth)-(s3x(cspix)*cth)+s4y(seg)
pzf=(-1*s3y(cspix))*sph+s4z(seg)
addvertex vertix,pxf,pyf,pzf:vertix=vertix+1
next cspix
oldsth=sth:oldcth=cth
return

@AROTSPECIAL
sth=1:cth=0:if seg>0 then sth=oldsth:cth=oldcth
flag=1
return
;______________________________________________________________SCALING____
@SCALEIT
group a:clrgrp
kill mark0,mark1,mark2:if seckeyz>3 then kill mark3
if seckeyz>4 then kill mark4:if seckeyz>5 then kill mark5
if seckeyz>6 then kill mark6:if seckeyz>7 then kill mark7
if seckeyz>8 then kill mark8:if seckeyz>9 then kill mark9
if seckeyz>10 then kill mark10:if seckeyz>11 then kill mark11
if seckeyz>12 then kill mark12:if seckeyz>13 then kill mark13
if seckeyz>14 then kill mark14:if seckeyz>15 then kill mark15
if seckeyz>16 then kill mark16:if seckeyz>17 then kill mark17
if seckeyz>18 then kill mark18:if seckeyz>19 then kill mark19

scalsent=1
gosub MERGEIT
if scaling=0 then goto SCALEIT2
scalx=s1x(seg):scaly=s2y(seg)
@RESCALE
if scalx<50 then axisscale 50,100,100:scalx=scalx*2
if scaly<50 then axisscale 100,50,100:scaly=scaly*2
if scalx<50 | scaly<50 then goto RESCALE
axisscale scalx,scaly,100

@SCALEIT2
if rotopt then gosub MANUALROT
if mrotopt then gosub SPLINEROT
if rotopt=3 then gosub TREEROT
gosub CSECSPLINE
return
;_____________________________________________________ROTATION_OPTIONS____
@TREEROT
e=0:group c
if seg=0 then return
for loop=1 to seg 
rotate csrot(e),0,0
rotate 0,csrot(e+1),0
rotate 0,0,csrot(e+2)
e=e+3:next loop:return

@MANUALROT
xrotx=xrot*seg:yrotx=yrot*seg:zrotx=zrot*seg
group c
rotate xrotx,0,0
rotate 0,yrotx,0
rotate 0,0,zrotx
return

@SPLINEROT
group c:
rotate xrotary(seg),0,0
rotate 0,yrotary(seg),0
rotate 0,0,zrotary(seg)
return

;____________________________________________________SPLINE_DEFINITION____
@XTRUDSPLINE
group b
for points=0 to exkeyz-1
gosub XTRUDPOINTS
defpt 4,spx,spy,spz
next points
if est=0 then defspline 4,segments+1,B
if est=1 then defspline 4,segments+1,L
if est=2 then defspline 4,segments+1,S
return

@CSECSPLINE
group b
for cpoint=0 to seckeyz-1
gosub SECTIONPOINTS
if crosstype=1 then gosub CSEC:next cpoint:return
defpt 3,scx,scy,scz
next cpoint
if cst=0 then defspline 3,csplinez,B
if cst=1 then defspline 3,csplinez,L
if cst=2 then defspline 3,csplinez,S
return
@CSEC
xpnt(cpoint)=scx:ypnt(cpoint)=scy:zpnt(cpoint)=scz
return

@SECTIONPOINTS
group b:clrgrp
if cpoint=0 then select mark0:grpcent scx,scy,scz:return
if cpoint=1 then select mark1:grpcent scx,scy,scz:return
if cpoint=2 then select mark2:grpcent scx,scy,scz:return
if cpoint=3 then select mark3:grpcent scx,scy,scz:return
if cpoint=4 then select mark4:grpcent scx,scy,scz:return
if cpoint=5 then select mark5:grpcent scx,scy,scz:return
if cpoint=6 then select mark6:grpcent scx,scy,scz:return
if cpoint=7 then select mark7:grpcent scx,scy,scz:return
if cpoint=8 then select mark8:grpcent scx,scy,scz:return
if cpoint=9 then select mark9:grpcent scx,scy,scz:return
if cpoint=10 then select mark10:grpcent scx,scy,scz:return
if cpoint=11 then select mark11:grpcent scx,scy,scz:return
if cpoint=12 then select mark12:grpcent scx,scy,scz:return
if cpoint=13 then select mark13:grpcent scx,scy,scz:return
if cpoint=14 then select mark14:grpcent scx,scy,scz:return
if cpoint=15 then select mark15:grpcent scx,scy,scz:return
if cpoint=16 then select mark16:grpcent scx,scy,scz:return
if cpoint=17 then select mark17:grpcent scx,scy,scz:return
if cpoint=18 then select mark18:grpcent scx,scy,scz:return
if cpoint=19 then select mark19:grpcent scx,scy,scz:return

@XTRUDPOINTS
group b:clrgrp
if points=0 then select spline0:grpcent spx,spy,spz:return
if points=1 then select spline1:grpcent spx,spy,spz:return
if points=2 then select spline2:grpcent spx,spy,spz:return
if points=3 then select spline3:grpcent spx,spy,spz:return
if points=4 then select spline4:grpcent spx,spy,spz:return
if points=5 then select spline5:grpcent spx,spy,spz:return
if points=6 then select spline6:grpcent spx,spy,spz:return
if points=7 then select spline7:grpcent spx,spy,spz:return
if points=8 then select spline8:grpcent spx,spy,spz:return
if points=9 then select spline9:grpcent spx,spy,spz:return
if points=10 then select spline10:grpcent spx,spy,spz:return
if points=11 then select spline11:grpcent spx,spy,spz:return
if points=12 then select spline12:grpcent spx,spy,spz:return
if points=13 then select spline13:grpcent spx,spy,spz:return
if points=14 then select spline14:grpcent spx,spy,spz:return
if points=15 then select spline15:grpcent spx,spy,spz:return
if points=16 then select spline16:grpcent spx,spy,spz:return
if points=17 then select spline17:grpcent spx,spy,spz:return
if points=18 then select spline18:grpcent spx,spy,spz:return
if points=19 then select spline19:grpcent spx,spy,spz:return

;_________________________________________________________________________
@TREEARRAY
afil=0:oinc=0
for oloop=1 to exkeyz-1
for loop=1 to treeseg
csrot(afil)=trot(oinc)/treeseg
csrot(afil+1)=trot(oinc+1)/treeseg
csrot(afil+2)=trot(oinc+2)/treeseg
afil=afil+3
next loop:oinc=oinc+3:next oloop
;? "Tree-Rotation array defined",frame
return

;________________________________________________________________BUILD____
@ADDFACES
si=csplinez:faceix=0:vertix=0

for faceloop= 1 to segments
for loop=0 to csplinez-2
addface faceix+0,vertix,vertix+si,vertix+si+1,1,1,0,color
addface faceix+1,vertix,vertix+si+1,vertix+1,0,1,1,color
faceix=faceix+2:vertix=vertix+1 
next loop
addface faceix+0,vertix,vertix+si,vertix+1,1,1,0,color
addface faceix+1,vertix,vertix+1,vertix-si+1,0,1,1,color
faceix=faceix+2:vertix=vertix+1 
next faceloop
;________________________________________________________________FINISH___
@CAPBASES
bell
fopen "A:\RUBERNEK\OMNI_50.CAP"
ftrap EOFILE
@CAPLOOP
caps=0
for capz=1 to csplinez-2
fread cf1,cf2,cf3
addface faceix+caps,cf1,cf2,cf3,1,1,1,color
addface faceix+caps+1,vertix+cf1,vertix+cf3,vertix+cf2,1,1,1,color
caps=caps+2
next capz:FCLOSE:goto UPLOADIT
@EOFILE
fclose
;_____________________________________________________UPLOAD\RECORD____
@UPLOADIT
faces=faceix+caps:verts=vertix+csplinez
group d
upload Omni,verts,faces:select Omni
zoom 30:perspec 800
cam2 2500,-2500,200,0,0,-650,0
view s
deselect spline0,spline1,spline2,spline3
bell:superview:anti:record
next frame
