; Omni Extruder Version 2.0
; by Darrel Anderson with help from Jeff Anderson
; for 3D-Control language
;___________________________________________________________LOAD\MERGE____

alert "Omni Extruder|Custom Modeling Tool|for CAD-3D|by Darrel Anderson"
DIM xrotary(100),yrotary(100),zrotary(100),xpnt(20),ypnt(20),zpnt(20)

@LOADIT
load3d "A:\OMNIFILE\ZZSPLINE.3D2"
status totv,usedv,totf,usedf,objs
exkeyz=objs

@MERGEIT
group c:clrgrp
merge3d "A:\OMNIFILE\ZZCROSEC.3D2"
if scalsent then return
status totv,usedv,totf,usedf,objs
seckeyz=objs-exkeyz
;_____________________________________________INPUT- OBJECT_PARAMETERS____
@GETSEGS
input "Enter number of segments.  0:ReadData",segments
if segments=0 then goto READDATA
if segments<3 | segments>100 then bell:goto GETSEGS
halfseg=(segments+1)/2:savesegs=segments
@GETCROSS
input "Number of points in cross-section spline",csplinez
if csplinez<1 then csplinez=seckeyz:crosstype=1
if csplinez>100 | csplinez<seckeyz then goto GETCROSS
savecspli=csplinez
;__________________________________________________INPUT- MAIN_OPTIONS____
@OPTIONS
input "0:Options  1:Defaults  2:ReadData",opt
if opt=0 then goto GETOPT0
if opt=1 then goto GETDEFAULT
if opt=2 then saves=2:goto READDATA
;________________________________________________INPUT- SPLINE_OPTIONS____
@GETOPT0
input "Spline Types;  0:Default(All B)  1:Set",ss
if ss=0 then goto GETOPT1

@CSPLITYPE
input "Cross-section spline;  0:B  1:L  2:S",cst
if cst<0 | cst>2 then goto CSPLITYPE
@ESPLITYPE
input "Extrusion spline;  0:B  1:L  2:S",est
if est<0 | est>2 then goto ESPLITYPE
@XSPLITYPE
input "X-scaling spline;  0:B  1:L  2:S",xst
if xst<0 | xst>2 then goto XSPLITYPE
@YSPLITYPE
input "Y-scaling spline;  0:B  1:L  2:S",yst
if yst<0 | yst>2 then goto YSPLITYPE
@RSPLITYPE
input "Rotation spline;  0:B  1:L  2:S",rst
if rst<0 | rst>2 then goto RSPLITYPE
;__________________________________________INPUT- INCREMENTAL_ROTATION____
@GETOPT1
input "0:Auto Rotation  1:Set Rotation  2:None",rotopt
if rotopt<0 | rotopt>2 then bell:goto GETOPT1 
if rotopt=0 | rotopt=2 then goto GETOPT2
input "Rotation...  0:Incremented  1:Splined",mrotopt
if mrotopt>0 then goto XROTDEF

@GETXROT
input "X rotation (degrees) of cross-section",xrot:xrot=int(xrot)
if abs (xrot/segments)>180 then bell:goto GETXROT
@GETYROT
input "Y rotation (degrees) of cross-section",yrot:yrot=int(yrot)
if abs (yrot/segments)>180 then bell:goto GETYROT
@GETZROT
input "Z rotation (degrees) of cross-section",zrot:zrot=int(zrot)
if abs (zrot/segments)>180 then bell:goto GETZROT
goto GETOPT2
;______________________________________________INPUT- SPLINED_ROTATION____
@XROTDEF
input "First X-rotation of cross-section 1:Nix",xmrot
if xmrot=1 then defpt 5,0,0,0:defpt 5,0,0,0:goto XROTSPLINE
if abs (xmrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto XROTDEF
defpt 5,xmrot,0,0:xmrotz=1
@NEXTXROT
input "Next X-rotation of cross-section 1:Done",xmrot
if xmrot=1 then goto XROTSPLINE
if abs (xmrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto XROTDEF
defpt 5,xmrot,0,0:xmrotz=xmrotz+1:goto NEXTXROT
@XROTSPLINE
if xmrotz>segments then alert "Too many key points/segments":goto XROTDEF
gosub ROTSPLINE
for fil=0 to segments
xrotary(fil)=s5x(fil):next fil
alert "X-Rotation spline defined"

@YROTDEF
input "First Y-rotation of cross-section 1:Nix",ymrot
if ymrot=1 then defpt 5,0,0,0:defpt 5,0,0,0:goto YROTSPLINE
if abs (ymrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto YROTDEF
defpt 5,0,ymrot,0:ymrotz=1
@NEXTYROT
input "Next Y-rotation of cross-section 1:Done",ymrot
if ymrot=1 then goto YROTSPLINE
if abs (ymrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto YROTDEF
defpt 5,0,ymrot,0:ymrotz=ymrotz+1:goto NEXTYROT
@YROTSPLINE
if ymrotz>segments then alert "Too many key points/segments":goto YROTDEF
gosub ROTSPLINE
for fil=0 to segments
yrotary(fil)=s5y(fil):next fil
alert "Y-Rotation spline defined"

@ZROTDEF
input "First Z-rotation of cross-section 1:Nix",zmrot
if zmrot=1 then defpt 5,0,0,0:defpt 5,0,0,0:goto ZROTSPLINE
if abs (zmrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto ZROTDEF
defpt 5,0,0,zmrot:zmrotz=1
@NEXTZROT
input "Next Z-rotation of cross-section 1:Done",zmrot
if zmrot=1 then goto ZROTSPLINE
if abs (zmrot) >180 then bell:alert ">180 & > -180 PLEASE" :goto ZROTDEF
defpt 5,0,0,zmrot:zmrotz=zmrotz+1:goto NEXTZROT
@ZROTSPLINE
if zmrotz>segments then alert "Too many key points/segments":goto ZROTDEF
gosub ROTSPLINE
for fil=0 to segments
zrotary(fil)=s5z(fil):next fil
alert "Z-Rotation spline defined"
goto GETOPT2

@ROTSPLINE
if rst=0 then defspline 5,segments+1,B
if rst=1 then defspline 5,segments+1,L
if rst=2 then defspline 5,segments+1,S
return
;_______________________________________________________INPUT- SCALING____
@GETOPT2
input "Cross-section scaling;  0:None  1:Set",scaling
if scaling<0 | scaling>1 then bell:goto GETOPT2
if scaling=0 then goto STARTIT

@GETXSCALE
input "First X-scaling % of cross-section 0:Nix",xpcnt
if xpcnt=0 then defpt 1,100,0,0:defpt 1,100,0,0:goto XSCALESPLINE
if xpcnt<1 | xpcnt>100 then bell:alert "% MUST BE <= 100":goto GETXSCALE
defpt 1,xpcnt,0,0:xscalz=1
@NEXTXSCALE
input "Next X-scaling % of cross-section 0:Done",xpcnt
if xpcnt<1 then goto XSCALESPLINE
if xpcnt>100 then bell:alert "% MUST BE <= 100":goto NEXTXSCALE
defpt 1,xpcnt,0,0:xscalz=xscalz+1:goto NEXTXSCALE
@XSCALESPLINE
if xscalz>segments then alert "Too many % key points|for # of segments"
if xst=0 then defspline 1,segments+1,B
if xst=1 then defspline 1,segments+1,L
if xst=2 then defspline 1,segments+1,S
alert "X-Scaling Defined"

@GETYSCALE
input "First Y-scaling % of cross-section 0:Nix",ypcnt
if ypcnt=0 then defpt 2,0,100,0:defpt 2,0,100,0:goto YSCALESPLINE
if ypcnt<1 | ypcnt>100 then bell:alert "% MUST BE <= 100":goto GETYSCALE
defpt 2,0,ypcnt,0:yscalz=1
@NEXTYSCALE
input "Next Y-scaling % of cross-section 0:Done",ypcnt
if ypcnt<1 then goto YSCALESPLINE
if ypcnt>100 then bell:alert "% MUST BE <= 100":goto NEXTYSCALE
defpt 2,0,ypcnt,0:yscalz=yscalz+1:goto NEXTYSCALE
@YSCALESPLINE
if yscalz>segments then alert "Too many % key points|for # of segments"
if yst=0 then defspline 2,segments+1,B
if yst=1 then defspline 2,segments+1,L
if yst=2 then defspline 2,segments+1,S
alert "Y-Scaling defined"
goto STARTIT
;_____________________________________________________________DEFAULTS____
@GETDEFAULT
rotopt=0:scaling=0
goto STARTIT
;____________________________________________________________READ_DATA____
@READDATA
input "Hit Return if DataFile ready. 1:abort",dx:if dx>0 then goto GETSEGS
fopen "A:\OMNIFILE\OX_DATA.DAT"
ftrap ENDODATA
fread segments,csplinez,cst,est,xst,yst,rst
fread rotopt,mrotopt,xmrotz,ymrotz,zmrotz,scaling,xscalz,yscalz
if rotopt=1 & mrotopt=0 then fread xrot,yrot,zrot
if mrotopt=1 then gosub DATMROT
if scaling=1 then gosub DATSCALE
halfseg=(segments+1)/2
@ENDODATA:fclose
if saves=2 then segments=savesegs:csplinez=savecspli
goto STARTIT

@DATMROT
if xmrotz=0 then goto YROTDAT
for loop=0 to xmrotz-1
fread dat:defpt 5,dat,0,0:next loop
gosub DROTSPLINE
for fil=0 to segments
xrotary(fil)=s5x(fil):next fil
@YROTDAT
if ymrotz=0 then goto ZROTDAT
for loop=0 to ymrotz-1
fread dat:defpt 5,0,dat,0:next loop
for fil=0 to segments
gosub DROTSPLINE
yrotary(fil)=s5y(fil):next fil
@ZROTDAT
if zmrotz=0 then return
for loop=0 to zmrotz-1
fread dat:defpt 5,0,0,dat:next loop
gosub DROTSPLINE
for fil=0 to segments
zrotary(fil)=s5z(fil):next fil
return
@DROTSPLINE
if rst=0 then defspline 5,segments+1,B
if rst=1 then defspline 5,segments+1,L
if rst=2 then defspline 5,segments+1,S
return

@DATSCALE
if xscalz=0 then goto YSCALDAT
for xloop=0 to xscalz-1
fread xdat:defpt 1,xdat,0,0:next xloop
if xst=0 then defspline 1,segments+1,B
if xst=1 then defspline 1,segments+1,L
if xst=2 then defspline 1,segments+1,S
@YSCALDAT
if yscalz=0 then return
for yloop=0 to yscalz-1
fread ydat:defpt 2,0,ydat,0:next yloop
if yst=0 then defspline 2,segments+1,B
if yst=1 then defspline 2,segments+1,L
if yst=2 then defspline 2,segments+1,S
return

;________________________________________________________________START____
@STARTIT
input "GO?",xx
xrot=xrot/segments:yrot=yrot/segments:zrot=zrot/segments
center universe:color=rez(0)+13
gosub XTRUDSPLINE
;_____________________________________________________________MAIN_LOOP___
@FLY
zoom 80:perspec 700:cam1 30,40,0:draft:view w:clrbgnd:backgnd yes,no
for seg=0 to segments
if rotopt=0 then gosub AUTOROT:bell:next seg:goto ADDFACES
if scaling=1 | rotopt=1 then gosub SCALEIT
if scaling=0 & rotopt=2 then gosub CSECSPLINE
for vx=0 to csplinez-1
if crosstype=1 then goto NOCSPLINE
addvertex vertix,s3x(vx)+s4x(seg),s3y(vx)+s4y(seg),s3z(vx)+s4z(seg)
vertix=vertix+1
next vx:bell:next seg
goto ADDFACES

@NOCSPLINE
addvertex vertix,xpnt(vx)+s4x(seg),ypnt(vx)+s4y(seg),zpnt(vx)+s4z(seg)
vertix=vertix+1
next vx:bell:next seg

goto ADDFACES
;________________________________________________________AUTO_ROTATION____
@AUTOROT
group c
D=1:DD=0
if seg+1>halfseg then D=0:DD=1

vecx=s4x(seg+D)-s4x(seg-DD)
vecy=s4y(seg+D)-s4y(seg-DD)
vecz=s4z(seg+D)-s4z(seg-DD)

@AROT2
magv=sqr(vecx*vecx + vecy*vecy + vecz*vecz)
magp=sqr(vecx*vecx + vecy*vecy)
sth=vecy/magp:cth=vecx/magp:cph=vecz/magv:sph=magp/magv

if sph>.70 then goto AROT3
if magp<200 & vecz>0 then gosub AROTSPECIAL:goto AROT4
if magp<200 & vecz<0 then sph=0:cph=-1:if seg>0 then sth=oldsth:cth=oldcth
;if oldvecy*vecy<0 & sph<.50 then gosub AROTSPECIAL:goto AROT3
flag=0

@AROT3
;if sph<.49 & flag= 1 then gosub AROTSPECIAL
@AROT4
oldvecy=vecy
if scaling then gosub SCALEIT:goto AROT5
gosub CSECSPLINE

@AROT5
for cspix=0 to csplinez-1
pxf=s3x(cspix)*sth+s3y(cspix)*cph*cth+s4x(seg)
pyf=(s3y(cspix)*cph*sth)-(s3x(cspix)*cth)+s4y(seg)
pzf=(-1*s3y(cspix))*sph+s4z(seg)
addvertex vertix,pxf,pyf,pzf:vertix=vertix+1
next cspix
oldsth=sth:oldcth=cth
return

@AROTSPECIAL
sth=1:cth=0:if seg>0 then sth=oldsth:cth=oldcth
flag=1
return
;______________________________________________________________SCALING____
@SCALEIT
group a:clrgrp
kill mark0,mark1,mark2:if seckeyz>3 then kill mark3
if seckeyz>4 then kill mark4:if seckeyz>5 then kill mark5
if seckeyz>6 then kill mark6:if seckeyz>7 then kill mark7
if seckeyz>8 then kill mark8:if seckeyz>9 then kill mark9
if seckeyz>10 then kill mark10:if seckeyz>11 then kill mark11
if seckeyz>12 then kill mark12:if seckeyz>13 then kill mark13
if seckeyz>14 then kill mark14:if seckeyz>15 then kill mark15
if seckeyz>16 then kill mark16:if seckeyz>17 then kill mark17
if seckeyz>18 then kill mark18:if seckeyz>19 then kill mark19

scalsent=1
gosub MERGEIT
if scaling=0 then goto SCALEIT2
scalx=s1x(seg):scaly=s2y(seg)
@RESCALE
if scalx<50 then axisscale 50,100,100:scalx=scalx*2
if scaly<50 then axisscale 100,50,100:scaly=scaly*2
if scalx<50 | scaly<50 then goto RESCALE
axisscale scalx,scaly,100

@SCALEIT2
if rotopt then gosub MANUALROT
if mrotopt then gosub SPLINEROT
gosub CSECSPLINE
return
;_____________________________________________________ROTATION_OPTIONS____
@MANUALROT
xrotx=xrot*seg:yrotx=yrot*seg:zrotx=zrot*seg
group c
rotate xrotx,0,0
rotate 0,yrotx,0
rotate 0,0,zrotx
return

@SPLINEROT
group c:
rotate xrotary(seg),0,0
rotate 0,yrotary(seg),0
rotate 0,0,zrotary(seg)
return

;____________________________________________________SPLINE_DEFINITION____
@XTRUDSPLINE
group b
for points=0 to exkeyz-1
gosub XTRUDPOINTS
defpt 4,spx,spy,spz
next points
if est=0 then defspline 4,segments+1,B
if est=1 then defspline 4,segments+1,L
if est=2 then defspline 4,segments+1,S
return

@CSECSPLINE
group b
for cpoint=0 to seckeyz-1
gosub SECTIONPOINTS
if crosstype=1 then gosub CSEC:next cpoint:return
defpt 3,scx,scy,scz
next cpoint
if cst=0 then defspline 3,csplinez,B
if cst=1 then defspline 3,csplinez,L
if cst=2 then defspline 3,csplinez,S
return
@CSEC
xpnt(cpoint)=scx:ypnt(cpoint)=scy:zpnt(cpoint)=scz
return

@SECTIONPOINTS
group b:clrgrp
if cpoint=0 then select mark0:grpcent scx,scy,scz:return
if cpoint=1 then select mark1:grpcent scx,scy,scz:return
if cpoint=2 then select mark2:grpcent scx,scy,scz:return
if cpoint=3 then select mark3:grpcent scx,scy,scz:return
if cpoint=4 then select mark4:grpcent scx,scy,scz:return
if cpoint=5 then select mark5:grpcent scx,scy,scz:return
if cpoint=6 then select mark6:grpcent scx,scy,scz:return
if cpoint=7 then select mark7:grpcent scx,scy,scz:return
if cpoint=8 then select mark8:grpcent scx,scy,scz:return
if cpoint=9 then select mark9:grpcent scx,scy,scz:return
if cpoint=10 then select mark10:grpcent scx,scy,scz:return
if cpoint=11 then select mark11:grpcent scx,scy,scz:return
if cpoint=12 then select mark12:grpcent scx,scy,scz:return
if cpoint=13 then select mark13:grpcent scx,scy,scz:return
if cpoint=14 then select mark14:grpcent scx,scy,scz:return
if cpoint=15 then select mark15:grpcent scx,scy,scz:return
if cpoint=16 then select mark16:grpcent scx,scy,scz:return
if cpoint=17 then select mark17:grpcent scx,scy,scz:return
if cpoint=18 then select mark18:grpcent scx,scy,scz:return
if cpoint=19 then select mark19:grpcent scx,scy,scz:return

@XTRUDPOINTS
group b:clrgrp
if points=0 then select spline0:grpcent spx,spy,spz:return
if points=1 then select spline1:grpcent spx,spy,spz:return
if points=2 then select spline2:grpcent spx,spy,spz:return
if points=3 then select spline3:grpcent spx,spy,spz:return
if points=4 then select spline4:grpcent spx,spy,spz:return
if points=5 then select spline5:grpcent spx,spy,spz:return
if points=6 then select spline6:grpcent spx,spy,spz:return
if points=7 then select spline7:grpcent spx,spy,spz:return
if points=8 then select spline8:grpcent spx,spy,spz:return
if points=9 then select spline9:grpcent spx,spy,spz:return
if points=10 then select spline10:grpcent spx,spy,spz:return
if points=11 then select spline11:grpcent spx,spy,spz:return
if points=12 then select spline12:grpcent spx,spy,spz:return
if points=13 then select spline13:grpcent spx,spy,spz:return
if points=14 then select spline14:grpcent spx,spy,spz:return
if points=15 then select spline15:grpcent spx,spy,spz:return
if points=16 then select spline16:grpcent spx,spy,spz:return
if points=17 then select spline17:grpcent spx,spy,spz:return
if points=18 then select spline18:grpcent spx,spy,spz:return
if points=19 then select spline19:grpcent spx,spy,spz:return
;________________________________________________________________BUILD____
@ADDFACES
si=csplinez:faceix=0:vertix=0

for faceloop= 1 to segments
for loop=0 to csplinez-2
addface faceix+0,vertix,vertix+si,vertix+si+1,1,1,0,color
addface faceix+1,vertix,vertix+si+1,vertix+1,0,1,1,color
faceix=faceix+2:vertix=vertix+1 
next loop
addface faceix+0,vertix,vertix+si,vertix+1,1,1,0,color
addface faceix+1,vertix,vertix+1,vertix-si+1,0,1,1,color
faceix=faceix+2:vertix=vertix+1 
next faceloop
;________________________________________________________________FINISH___
@CAPBASES
bell
fopen "A:OMNIFILE\OMNI_50.CAP"
ftrap EOFILE
@CAPLOOP
for capz=1 to csplinez-2
fread cf1,cf2,cf3
addface faceix+caps,cf1,cf2,cf3,1,1,1,color
addface faceix+caps+1,vertix+cf1,vertix+cf3,vertix+cf2,1,1,1,color
caps=caps+2
next capz:FCLOSE:goto UPLOADIT
@EOFILE
fclose
;_______________________________________________________________UPLOAD____
@UPLOADIT
faces=faceix+caps:verts=vertix+csplinez
group a
upload Omni,verts,faces:clrgrp:select Omni
zoom 80:perspec 700:cam1 120,40,0:superview:bell:end
