;SIMPLIFY.CTL.  by Darrel Anderson
;Used to transform CROSS-SECTION file objects into 1 point objects. Using 
;these single point object files in OMNI_EXT.CTL speeds up object creation.
;Load the CROSS-SECTION file you want to convert into CAD-3D before running.
;When finished all "mark" objects will have been converted to single points.
;Save this new group of objects with a new filname.  Keep the original
;file, these 1 point objects are difficult to manipulate in CAD.

input "number of marks to convert",seckeyz

DIM xpnt(20),ypnt(20),zpnt(20)
addvertex 0,0,0,0:addface 0,0,0,0,1,1,1,color:upload p,1,1
gosub CSECSPLINE
for L=0 to seckeyz-1
group a:clrgrp:select p:moveto xpnt(L),ypnt(L),zpnt(L)
if L=0 then kill mark0:clone p,mark0
if L=1 then kill mark1:clone p,mark1
if L=2 then kill mark2:clone p,mark2
if L=3 then kill mark3:clone p,mark3
if L=4 then kill mark4:clone p,mark4
if L=5 then kill mark5:clone p,mark5
if L=6 then kill mark6:clone p,mark6
if L=7 then kill mark7:clone p,mark7
if L=8 then kill mark8:clone p,mark8
if L=9 then kill mark9:clone p,mark9
if L=10 then kill mark10:clone p,mark10
if L=11 then kill mark11:clone p,mark11
if L=12 then kill mark12:clone p,mark12
if L=13 then kill mark13:clone p,mark13
if L=14 then kill mark14:clone p,mark14
if L=15 then kill mark15:clone p,mark15
if L=16 then kill mark16:clone p,mark16
if L=17 then kill mark17:clone p,mark17
if L=18 then kill mark18:clone p,mark18
if L=19 then kill mark19:clone p,mark19
next L:kill p:allgrp:bell:end

@CSECSPLINE
group b
for cpoint=0 to seckeyz-1
gosub SECTIONPOINTS
xpnt(cpoint)=scx:ypnt(cpoint)=scy:zpnt(cpoint)=scz
next cpoint:return

@SECTIONPOINTS
group b:clrgrp
if cpoint=0 then select mark0:grpcent scx,scy,scz:return
if cpoint=1 then select mark1:grpcent scx,scy,scz:return
if cpoint=2 then select mark2:grpcent scx,scy,scz:return
if cpoint=3 then select mark3:grpcent scx,scy,scz:return
if cpoint=4 then select mark4:grpcent scx,scy,scz:return
if cpoint=5 then select mark5:grpcent scx,scy,scz:return
if cpoint=6 then select mark6:grpcent scx,scy,scz:return
if cpoint=7 then select mark7:grpcent scx,scy,scz:return
if cpoint=8 then select mark8:grpcent scx,scy,scz:return
if cpoint=9 then select mark9:grpcent scx,scy,scz:return
if cpoint=10 then select mark10:grpcent scx,scy,scz:return
if cpoint=11 then select mark11:grpcent scx,scy,scz:return
if cpoint=12 then select mark12:grpcent scx,scy,scz:return
if cpoint=13 then select mark13:grpcent scx,scy,scz:return
if cpoint=14 then select mark14:grpcent scx,scy,scz:return
if cpoint=15 then select mark15:grpcent scx,scy,scz:return
if cpoint=16 then select mark16:grpcent scx,scy,scz:return
if cpoint=17 then select mark17:grpcent scx,scy,scz:return
if cpoint=18 then select mark18:grpcent scx,scy,scz:return
if cpoint=19 then select mark19:grpcent scx,scy,scz:return

