; SPLINE PREVIEW PROGRAM Version 1.0
; by Darrel Anderson
; for CAD-3D 2.02 and Cyber Control 
;________________________________________________________________START____
status totv,usedv,totf,usedf,obj0

@STARTOPT
input "0:Auto  1:Merge  2:No Load  3:Restart",start
if start<0 | start>3 then bell:goto STARTOPT
if start=1 then mergeopt=1:goto SELECT
if start=2 then noload=1:goto SELECT
if start=3 then kill trace:goto STARTOPT
@SELECT
input "Key-Point Source  0:Spline  1:Mark",source
if source<0 | source>1 then goto SELECT
if noload then goto OPTION
if mergeopt then goto MERGE
@LOAD
group a
if source=0 then load3d "A:\OMNIFILE\ZZSPLINE.3D2"
if source=1 then load3d "A:\OMNIFILE\ZZCROSEC.3D2"
status totv,usedv,totf,usedf,obj1
keys=obj1:goto OPTION
@MERGE
group a
if source=0 then merge3d "A:\OMNIFILE\ZZSPLINE.3D2"
if source=1 then merge3d "A:\OMNIFILE\ZZCROSEC.3D2"
status totv,usedv,totf,usedf,obj1
keys=obj1-obj0:goto OPTION
;________________________________________________________________INPUT____
@OPTION
input "Choose; 0:Construct  1:Map  2:Fly",opt
if opt<0 | opt1>2 then bell:goto OPTION

@GETTYPE
input "Choose Spline type;  0:B  1:L  2:S",stype
if stype<0 | stype>2 then goto GETTYPE

@GETKEYS
if start<2 then goto GETPOINTS
input "Enter number of Key Points used.",keys
if keys<2 | keys >20 then bell:goto GETKEYS
@GETPOINTS
input "Enter number of spline points to trace.",spoints
if spoints> (40-(keys+1)) & opt=0 then bell:goto GETPOINTS

@SHOWKEY
input "0:Show Key Points  1:Hide Key Points",seekey
if seekey<0 | seekey>1 then bell:goto SHOWKEY

@SETCAM
input "Camera Settings;  0:Default  1:Set",camopt
if camopt<0 | camopt>1 then bell:goto SETCAM
if camopt=0 then goto STARTIT

@GETZOOM
input "Enter Zoom",izoom
if izoom<1 | izoom>999 then bell:goto GETZOOM

@GETPERSPEC
input "Enter Perspective",iperspec
if iperspec<0 | iperspec>999 then bell:goto GETPERSPEC
if opt=2 then gosub LOOKOPT:goto STARTIT

@GETHORIZONTAL
input "Enter Cameras' Horizontal position",horiz
if abs (horiz)>180 then bell:goto GETHORIZONTAL

@GETVERTICAL
input "Enter Cameras' Vertical position",vertical
if abs (vertical)>180 then bell:goto GETVERTICAL

@STARTIT
if opt<2 then group a:clrgrp:wedge trace,14:scale 50:rotate 0,90,0
zoom izoom:perspec iperspec:cam1 horiz,vertical,0
if camopt=0 & opt<2 then zoom 70:perspec 700:cam1 30,30,0:
watch on
gosub DEFSPLINE
if opt=0 then goto CONSTRUCT
if opt=1 then goto MAP
if opt=2 then goto FLY

@LOOKOPT
input "Aim Cam2 at; 0:Spline path  1:Cad-Center",lookat
if lookat<0 | lookat>1 then bell:goto @LOOKOPT
return

;___________________________________________________________OPERATIONS____
@CONSTRUCT
watch on:backgnd no,no
group a:clrgrp:clrbgnd
for loop=0 to spoints
group c:clrgrp:select trace
moveto s1x(loop),s1y(loop),s1z(loop)
gosub CLONES
if seekey=0 then group a:allgrp
if seekey=1 then group b:select trace
superview
next loop
kill trace:for delay=1 to 50:next delay:end

@MAP
watch on:backgnd yes,no
group a:allgrp:clrbgnd
if seekey=1 then group c:clrgrp:select trace
for loop=0 to spoints
group c:clrgrp:select trace
moveto s1x(loop),s1y(loop),s1z(loop)
if seekey=0 then group a:allgrp
if seekey=1 then group c:clrgrp:select trace
superview:vtobgnd
next loop
kill trace:for delay=0 to 100:next delay
end

@FLY
i=3:halfway=spoints/2
if camopt=0 then zoom 30:perspec999
watch on:backgnd no,no
group a:clrgrp:clrbgnd
if seekey=0 then group a:allgrp
if seekey=1 then group b
for loop=0 to spoints-1
if loop=halfway then i=-3
if lookat=1 then cam2 s1x(loop),s1y(loop),s1z(loop),0,0,0,0:goto SKIP
cam2 s1x(loop),s1y(loop),s1z(loop),s1x(loop+i),s1y(loop+i),s1z(loop+i),0
@SKIP
superview
next loop
for delay=0 to 100:next delay:end
;______________________________________________________________SPLINE____
@DEFSPLINE
group d
for points=0 to keys-1
if source=0 then gosub SPLINEPOINTS
if source=1 then gosub MARKPOINTS
defpt 1,spx,spy,spz
next points
if stype=0 then defspline 1,spoints+1,B
if stype=1 then defspline 1,spoints+1,L
if stype=2 then defspline 1,spoints+1,S
clrgrp:return

@SPLINEPOINTS
group d
if points=0 then clrgrp:select spline0:grpcent spx,spy,spz:return
if points=1 then clrgrp:select spline1:grpcent spx,spy,spz:return
if points=2 then clrgrp:select spline2:grpcent spx,spy,spz:return
if points=3 then clrgrp:select spline3:grpcent spx,spy,spz:return
if points=4 then clrgrp:select spline4:grpcent spx,spy,spz:return
if points=5 then clrgrp:select spline5:grpcent spx,spy,spz:return
if points=6 then clrgrp:select spline6:grpcent spx,spy,spz:return
if points=7 then clrgrp:select spline7:grpcent spx,spy,spz:return
if points=8 then clrgrp:select spline8:grpcent spx,spy,spz:return
if points=9 then clrgrp:select spline9:grpcent spx,spy,spz:return
if points=10 then clrgrp:select spline10:grpcent spx,spy,spz:return
if points=11 then clrgrp:select spline11:grpcent spx,spy,spz:return
if points=12 then clrgrp:select spline12:grpcent spx,spy,spz:return
if points=13 then clrgrp:select spline13:grpcent spx,spy,spz:return
if points=14 then clrgrp:select spline14:grpcent spx,spy,spz:return
if points=15 then clrgrp:select spline15:grpcent spx,spy,spz:return
if points=16 then clrgrp:select spline16:grpcent spx,spy,spz:return
if points=17 then clrgrp:select spline17:grpcent spx,spy,spz:return
if points=18 then clrgrp:select spline18:grpcent spx,spy,spz:return
if points=19 then clrgrp:select spline19:grpcent spx,spy,spz:return

@MARKPOINTS
group d
if points=0 then clrgrp:select mark0:grpcent spx,spy,spz:return
if points=1 then clrgrp:select mark1:grpcent spx,spy,spz:return
if points=2 then clrgrp:select mark2:grpcent spx,spy,spz:return
if points=3 then clrgrp:select mark3:grpcent spx,spy,spz:return
if points=4 then clrgrp:select mark4:grpcent spx,spy,spz:return
if points=5 then clrgrp:select mark5:grpcent spx,spy,spz:return
if points=6 then clrgrp:select mark6:grpcent spx,spy,spz:return
if points=7 then clrgrp:select mark7:grpcent spx,spy,spz:return
if points=8 then clrgrp:select mark8:grpcent spx,spy,spz:return
if points=9 then clrgrp:select mark9:grpcent spx,spy,spz:return
if points=10 then clrgrp:select mark10:grpcent spx,spy,spz:return
if points=11 then clrgrp:select mark11:grpcent spx,spy,spz:return
if points=12 then clrgrp:select mark12:grpcent spx,spy,spz:return
if points=13 then clrgrp:select mark13:grpcent spx,spy,spz:return
if points=14 then clrgrp:select mark14:grpcent spx,spy,spz:return
if points=15 then clrgrp:select mark15:grpcent spx,spy,spz:return
if points=16 then clrgrp:select mark16:grpcent spx,spy,spz:return
if points=17 then clrgrp:select mark17:grpcent spx,spy,spz:return
if points=18 then clrgrp:select mark18:grpcent spx,spy,spz:return
if points=19 then clrgrp:select mark19:grpcent spx,spy,spz:return
;________________________________________________________________CLONE____
@CLONES
group b
if loop=0 then clone trace,trace1:return
if loop=1 then clone trace,trace2:return
if loop=2 then clone trace,trace3:return
if loop=3 then clone trace,trace4:return
if loop=4 then clone trace,trace5:return
if loop=5 then clone trace,trace6:return
if loop=6 then clone trace,trace7:return
if loop=7 then clone trace,trace8:return
if loop=8 then clone trace,trace9:return
if loop=9 then clone trace,trace10:return
if loop=10 then clone trace,trace11:return
if loop=11 then clone trace,trace12:return
if loop=12 then clone trace,trace13:return
if loop=13 then clone trace,trace14:return
if loop=14 then clone trace,trace15:return
if loop=15 then clone trace,trace16:return
if loop=16 then clone trace,trace17:return
if loop=17 then clone trace,trace18:return
if loop=18 then clone trace,trace19:return
if loop=19 then clone trace,trace20:return
if loop=20 then clone trace,trace21:return
if loop=21 then clone trace,trace22:return
if loop=22 then clone trace,trace23:return
if loop=23 then clone trace,trace24:return
if loop=24 then clone trace,trace25:return
if loop=25 then clone trace,trace26:return
if loop=26 then clone trace,trace27:return
if loop=27 then clone trace,trace28:return
if loop=28 then clone trace,trace29:return
if loop=29 then clone trace,trace30:return
if loop=30 then clone trace,trace31:return
if loop=31 then clone trace,trace32:return
if loop=32 then clone trace,trace33:return
if loop=33 then clone trace,trace34:return
if loop=34 then clone trace,trace35:return
if loop=35 then clone trace,trace36:return
if loop=36 then clone trace,trace37:return
if loop=37 then clone trace,trace38:return
if loop=38 then clone trace,trace39:return
if loop=39 then clone trace,trace40:return
if loop=40 then clone trace,trace41:return
if loop=41 then clone trace,trace42:return
if loop=42 then clone trace,trace43:return
if loop=43 then clone trace,trace44:return
if loop=44 then clone trace,trace45:return
if loop=45 then clone trace,trace46:return
if loop=46 then clone trace,trace47:return
if loop=47 then clone trace,trace48:return
if loop=48 then clone trace,trace49:return
