; CAD-3D Function object maker
; By Tom Hudson
;
; Set up function Z=function(X,Y) inside loop below
; Default function: Z=(cos(X)+cos(Y))*2000
; Use grid size = 10, grid scale = 20
; Try Z=rnd(0)*1000 with various grid sizes and scale=1
; Try Z=(Y*sin(X)+X*sin(Y)) with grid size 37 and scale=25
; Any function may be used to set Z!

alert "CAD-3D Function generator|      by Tom Hudson"

status totv,usev,totf,usef,totob
availv=totv-usev:availf=totf-usef

@GETCOLOR
input "Enter grid color (1-15)",color:color=int(color)
if color<1 | color>15 then bell:goto GETCOLOR

@GETGRID
input "Enter grid size (5-37)",grid:grid=int(grid)
if grid<5 | grid>37 then bell:goto GETGRID

verts=grid*grid:faces=(grid-1)*(grid-1)*2
if verts>availv | faces>availf then bell:alert "Grid too big!":goto GETGRID

@GETSCALE
input "Enter grid scale",sc:sc=abs(sc)
if sc=0 then bell:alert "Bad scale!":goto GETSCALE

gstart=-(grid-1)/2*sc:gend=-gstart+sc/2
realstep=8000/(grid-1)

; CALCULATE GRAPH ALTITUDES
; EQUATION INSIDE THIS LOOP Z=f(X,Y)!
; KEEP Z<4500

vertix=0
realx=-4000:for X=gstart to gend step sc
realy=-4000:for Y=gstart to gend step sc
Z=(cos(X)+cos(Y))*2000
addvertex vertix,realx,realy,Z:vertix=vertix+1
realy=realy+realstep:next Y
realx=realx+realstep:next X

; BUILD FACES (VIEW FROM TOP ONLY)

faceix=0
for X=0 to grid-2
for Y=0 to grid-2
base=X+Y*grid
addface faceix,base,base+grid,base+grid+1,1,1,0,color
addface faceix+1,base,base+grid+1,base+1,0,1,1,color
faceix=faceix+2
next Y
next X

upload GRID,vertix,faceix:clrgrp:select GRID:home:bell:end
