
; Tree-structure demo: Pseudo-human Hand
; by Tom Hudson

input "Watch (0) or Record (1)?",option

load3d "A:\TUTORIAL\HAND.3d2"
gosub DEFINEHAND
gosub DEFSPLINES

zoom 80:perspec 999:cam1 -35,40,0
final:view solid:mono

if option then rstart "B:\HAND",m:goto RUNIT
watch on

@RUNIT

for frame=0 to 98
load3d "A:\TUTORIAL\HAND.3d2"

fing1=(frame+20)%99
fing2=(frame+40)%99
fing3=(frame+60)%99
fing4=(frame+80)%99

position palm,s2x(frame),0,0
position thumb1,0,0,s1x(frame)
position thumb2,0,0,s1x(frame)
position finger11,-s1x(fing1),0,0
position finger12,-s1x(fing1),0,0
position finger21,-s1x(fing2),0,0
position finger22,-s1x(fing2),0,0
position finger31,-s1x(fing3),0,0
position finger32,-s1x(fing3),0,0
position finger41,-s1x(fing4),0,0
position finger42,-s1x(fing4),0,0
treeset arm
superview
if option then record
next frame

if option then rstop:end
watch off:end

; Define the hand!  Set up objects in arm, set up their operational
; limits, and define their relationships to each other.

@DEFINEHAND
treeclr
treeadd arm,palm,thumb1,thumb2,finger11,finger12,finger21,finger22
treeadd finger31,finger32,finger41,finger42
limit palm,-90,70,0,0,0,0
limit thumb1,0,0,0,0,0,90
limit thumb2,0,0,0,0,0,90
limit finger11,-90,0,0,0,0,0
limit finger12,-90,0,0,0,0,0
limit finger21,-90,0,0,0,0,0
limit finger22,-90,0,0,0,0,0
limit finger31,-90,0,0,0,0,0
limit finger32,-90,0,0,0,0,0
limit finger41,-90,0,0,0,0,0
limit finger42,-90,0,0,0,0,0
relate palm,arm,wrist
relate thumb1,palm,kt1
relate thumb2,thumb1,kt2
relate finger11,palm,k11
relate finger21,palm,k21
relate finger31,palm,k31
relate finger41,palm,k41
relate finger12,finger11,k12
relate finger22,finger21,k22
relate finger32,finger31,k32
relate finger42,finger41,k42
return

@DEFSPLINES

; This subroutine defines the splines that are used to move
; all of the joints in the object.  The first spline is used for the
; fingers and thumbs, the index is offset for each finger.  The second
; spline pivots the palm.

; Finger spline

defpt 1,45,0,0
defpt 1,90,0,0
defpt 1,90,0,0
defpt 1,45,0,0
defpt 1,0,0,0
defpt 1,0,0,0
defpt 1,45,0,0
defspline 1,100,B

; Palm spline

defpt 2,0,0,0
defpt 2,-40,0,0
defpt 2,0,0,0
defpt 2,40,0,0
defpt 2,40,0,0
defpt 2,0,0,0
defspline 2,100,B

return

 