
; Tree-structure demo: Robot Arm
; by Tom Hudson

input "Watch (0) or Record (1)?",option

load3d "A:\TUTORIAL\ROBOTARM.3D2"
gosub DEFINEARM
gosub DEFSPLINES

zoom 140:perspec 999:cam1 -15,40,0
final:view solid:mono

if option then rstart "B:\ROBOTARM",m:goto RUNIT
watch on

@RUNIT

for frame=0 to 78
load3d "A:\TUTORIAL\ROBOTARM.3D2"
position rotater,0,0,s1x(frame)
position lowarm,0,s2x(frame),0
position uparm,0,s3x(frame),0
position wrist,0,s4x(frame),0
position claw,0,0,s5x(frame)
treeset base
superview
if option then record
next frame

if option then rstop:end
watch off:end

; Define the robot arm!  Set up objects in arm, set up their operational
; limits, and define their relationships to each other.

@DEFINEARM
treeclr
treeadd base,rotater,lowarm,uparm,wrist,claw
limit rotater,0,0,0,0,-180,180
limit lowarm,0,0,-70,70,0,0
limit uparm,0,0,-90,90,0,0
limit wrist,0,0,-90,90,0,0
limit claw,0,0,0,0,-180,180
relate rotater,base,robase
relate lowarm,rotater,shoulder
relate uparm,lowarm,elbow
relate wrist,uparm,uwrist
relate claw,wrist,wclaw
return

@DEFSPLINES

; This subroutine defines five independent splines that are used to move
; each of the five joints in the object.

; Rotater spline

defpt 1,0,0,0
defpt 1,40,0,0
defpt 1,45,0,0
defpt 1,45,0,0
defpt 1,-60,0,0
defpt 1,0,0,0
defspline 1,80,L

; Lower arm spline

defpt 2,0,0,0
defpt 2,70,0,0
defpt 2,70,0,0
defpt 2,50,0,0
defpt 2,30,0,0
defpt 2,40,0,0
defpt 2,0,0,0
defspline 2,80,B

; Upper arm spline

defpt 3,0,0,0
defpt 3,0,0,0
defpt 3,-30,0,0
defpt 3,-10,0,0
defpt 3,10,0,0
defpt 3,10,0,0
defpt 3,0,0,0
defspline 3,80,L

; Wrist spline

defpt 4,0,0,0
defpt 4,20,0,0
defpt 4,40,0,0
defpt 4,-10,0,0
defpt 4,-50,0,0
defpt 4,-60,0,0
defpt 4,-30,0,0
defpt 4,0,0,0
defspline 4,80,B

; Claw spline

defpt 5,-180,0,0
defpt 5,180,0,0
defspline 5,80,B

return

