program mars;

const pclen=3999;

type redcode=record
               opcode:byte;
               typ1  :byte;
               arg1  :integer;
               typ2  :byte;
               arg2  :integer;
             end;

var a        : array[0..7999] of redcode;
    pcstack  : array[1..2,0..pclen] of integer;
    pcptr    : array[1..2] of integer;
    pc       : array[1..2] of integer;
    name     : array[1..2] of string;
    arg      : redcode;
    i,imax   : long_integer;
    j,k,hpc  : integer;
    redfile  : file of redcode;

function randomize : long_integer;
  xbios(17);

function random:integer;
var a:long_integer;
begin
  a:=randomize;
  random:=a mod 6000
end;

procedure gotoxy(x,y:byte);
begin
  write(chr(27),'Y',chr(32+y),chr(32+x));
end;

procedure linie(x1,y1,x2,y2:integer);
begin
  line(x1,y1,x2,y2,1,1,1,1,-1,1);
end;

procedure graf(pc,s:integer);
var x,y:integer;
begin
  x:=(pc mod 160)*4;         
  y:=(pc div 160)*4+100;     

  if s=1 then begin
    line(x+1,y,x+1,y+2,0,0,0,0,-1,0);
    line(x,y+1,x+2,y+1,0,0,0,0,-1,0);
    linie(x,y,x+2,y+2);
    linie(x,y+2,x+2,y);
  end
  else
  begin
    linie(x,y,x,y+2);
    linie(x+1,y,x+1,y+2);
    linie(x+2,y,x+2,y+2);
  end;   
end;

procedure pcgraf(pc:integer);
var x,y:integer;
begin
  x:=(pc mod 160)*4;         
  y:=(pc div 160)*4+100;     

  line(x+3,y,x+3,y+3,1,1,1,1,-1,2);
  line(x,y+3,x+3,y+3,1,1,1,1,-1,2);
end;

procedure upper(var x:string);
var l:integer;
begin
  for l:=1 to length(x) do
    if (ord(x[l])>96) and (ord(x[l])<123) then
      x[l]:=chr(ord(x[l])-ord('a')+ord('A'));
end;
 
begin

  pc[1]:=0;
  pc[2]:=random+1000;
  pcptr[1]:=-1;
  pcptr[2]:=-1;

  for i:=1 to 2 do begin
    write('Name des ',i,'. Programms: ');
    readln(name[i]);
    j:=0;

    reset(redfile,concat(name[i],'.RED'));
    while not eof(redfile) do begin
      a[pc[i]+j]:=redfile^;
      get(redfile);
      j:=j+1;
    end;
    close(redfile);
    upper(name[i]);
  end;

  writeln;
  write('Spieldauer in Befehlen: ');
  readln(imax);

  write(chr(27),'E',chr(27),'v',chr(27),'f');
  gotoxy(15,1);
  write(name[1]);
  gotoxy(55,1);
  write(name[2]);
  gotoxy(35,0);
  write('Zeit:');
  line(0,98,639,98,1,1,1,1,-1,0);
  line(0,301,639,301,1,1,1,1,-1,0);

  for i:=1 to 15 do begin
    graf(-6755+i,1);
    graf(-6835+i,2);
  end;

(*  for i:=0 to 7999 do begin
    a[i].opcode:=0;
    a[i].typ1:=0;
    a[i].typ2:=0;
    a[i].arg1:=0;
    a[i].arg2:=0;
  end; *)
  for i:=0 to pclen do begin
    pcstack[1,i]:=-1;
    pcstack[2,i]:=-1;
  end;
  pcstack[1,0]:=pc[1];
  pcstack[2,0]:=pc[2];


  for i:=1 to imax do         (* Hauptschleife *)
    for j:=1 to 2 do begin    (* jeder Spieler *)

      pcptr[j]:=(pcptr[j]+1) mod (pclen+1);       
      k:=0;
      while (pcstack[j,pcptr[j]]=-1) or (pcstack[j,pcptr[j]]=9999) do
        if pcstack[j,pcptr[j]]=-1 then begin
          pcptr[j]:=0;
          k:=k+1;
          if k>1 then begin
            gotoxy(30,3);
            writeln(name[j],' ist zerstrt!');
            gotoxy(30,4);
            writeln('Gewinner ist: ',name[3-j]);
            readln(name[1]);
            halt;
          end;
        end
        else
           pcptr[j]:=(pcptr[j]+1) mod (pclen+1);

        gotoxy(j*40-25,3);
        writeln(pcptr[j],'  ');
      
      pc[j]:=pcstack[j,pcptr[j]];

      arg.opcode:=0;
      arg.typ1:=0;
      arg.typ2:=0;
      arg.arg1:=0;
      arg.arg2:=0;

      graf(pc[j],j);
      gotoxy(41,0);
      write(i);

      case a[pc[j]].typ1 of   (* absolute Adresse des 1. Arguments *)

        0 : arg.arg1:=a[pc[j]].arg1;                    (* # : absolut *)

        1 : arg.arg1:=(pc[j]+a[pc[j]].arg1) mod 8000;   (*     relativ *)

        2 : begin                                       (* @ : indirekt *)
              arg.arg1:=(pc[j]+a[pc[j]].arg1) mod 8000;
              arg.arg1:=(arg.arg1+a[arg.arg1].arg2) mod 8000;
            end;

        3 : begin                                       (* < : ind. dec *)
              arg.arg1:=(pc[j]+a[pc[j]].arg1) mod 8000;
              hpc:=arg.arg1;
              arg.arg1:=(arg.arg1+a[arg.arg1].arg2) mod 8000;
              a[hpc].arg2:=(a[hpc].arg2+7999) mod 8000;
            end;

        otherwise: begin
                  writeln('Fehler: Ungueltige Adressierungsart in ',name[j]);
                  halt;
                   end; 
      end;

      case a[pc[j]].typ2 of   (* absolute Adresse des 2. Arguments *)

        0 : arg.arg2:=a[pc[j]].arg2;                    (* # : absolut *)

        1 : arg.arg2:=(pc[j]+a[pc[j]].arg2) mod 8000;   (*     relativ *)

        2 : begin                                       (* @ : indirekt *)
              arg.arg2:=(pc[j]+a[pc[j]].arg2) mod 8000;
              arg.arg2:=(arg.arg2+a[arg.arg2].arg2) mod 8000;
            end;

        3 : begin                                       (* < : ind. dec. *)
              arg.arg2:=(pc[j]+a[pc[j]].arg2) mod 8000;
              hpc:=arg.arg2;
              arg.arg2:=(arg.arg2+a[arg.arg2].arg2) mod 8000;
              a[hpc].arg2:=(a[hpc].arg2+7999) mod 8000;
            end;

       end;

      case a[pc[j]].opcode of (* Befehlsausfuehrung *)

        0 : pcstack[j,pcptr[j]]:=9999;         (* DAT : nicht ausfuehrbar *)

        1 : if a[pc[j]].typ1=0 then begin      (* MOV : kopieren *)
              a[arg.arg2].opcode:=0;           (* absolut schreiben *)
              a[arg.arg2].typ1:=0;
              a[arg.arg2].typ2:=0;
              a[arg.arg2].arg1:=0;
              a[arg.arg2].arg2:=arg.arg1;
              graf(arg.arg2,j);
            end
            else
            begin 
              a[arg.arg2].opcode:=a[arg.arg1].opcode; (* rel. schreiben *)
              a[arg.arg2].typ1:=a[arg.arg1].typ1;
              a[arg.arg2].typ2:=a[arg.arg1].typ2;
              a[arg.arg2].arg1:=a[arg.arg1].arg1;
              a[arg.arg2].arg2:=a[arg.arg1].arg2;
              graf(arg.arg2,j);
            end;

        2 : begin                     (* ADD : Addition *)
              if a[pc[j]].typ1>0 then
                arg.arg1:=a[arg.arg2].arg2;
              a[arg.arg2].arg2:=(a[arg.arg2].arg2+arg.arg1) mod 8000;
            end;

        3 : begin                     (* SUB : Subtrakion *)
              if a[pc[j]].typ1>0 then
                arg.arg1:=a[arg.arg2].arg2;
              a[arg.arg2].arg2:=(a[arg.arg2].arg2-arg.arg1+8000) mod 8000;
            end;

        4 : PCstack[j,pcptr[j]]:=(arg.arg1+7999) mod 8000;  (* JMP *)

        5 : if a[arg.arg2].arg2=0 then        (* JMZ : Sprung wenn 0 *)
              PCstack[j,pcptr[j]]:=(arg.arg1+7999) mod 8000;

        6 : if a[arg.arg2].arg2<>0 then            (* JMN : Sprung wenn nicht 0 *)
              PCstack[j,pcptr[j]]:=(arg.arg1+7999) mod 8000;

        7 : begin                             (* DJN : Dec. & Jump not 0 *)
              a[arg.arg2].arg2:=(a[arg.arg2].arg2+7999) mod 8000;
              if a[arg.arg2].arg2<>0 then
                pcstack[j,pcptr[j]]:=(arg.arg1+7999) mod 8000;
            end;

        8 : begin                             (* CMP : Vergleiche *)
              if a[pc[j]].typ1>0 then
                arg.arg1:=a[arg.arg1].arg2;
              if a[pc[j]].typ2>0 then
                arg.arg2:=a[arg.arg2].arg2;
              if arg.arg1<>arg.arg2 then
                pcstack[j,pcptr[j]]:=(pc[j]+1) mod 8000;
            end;

        9 : begin                             (* SPL : spalten *)
              k:=pcptr[j]+1;
              while (pcstack[j,k]<>-1) and (pcstack[j,k]<>9999) do begin
                k:=k+1;
                if k>pclen then k:=0;
              end;
              pcstack[j,k]:=arg.arg1;

 
(*              gotoxy(1,0);
              writeln(pcstack[j,k]);
              for k:=arg.arg1-10 to arg.arg1+10 do
                writeln(k,' ',a[k].opcode);
              readln(name[1]);
*)
            end;

        otherwise : begin
                 writeln('Fehler: nicht implementierter Befehl in ',name[j]);
                 halt;
        end; 
      end;

      if (pcstack[j,pcptr[j]]<9999) and (pcstack[j,pcptr[j]]>-1)  then
        pcstack[j,pcptr[j]]:=(pcstack[j,pcptr[j]]+1) mod 8000;
    end;
  readln(name[1]);
end.
