
#include <vdi.h>
#include <tos.h>
#include <stdio.h>
#include <string.h>
#include <portab.h>

#include "midnight.h"	/* ACC_str + MOD_str + defines fr Module + ACC */

extern MOD_str MOD_struct;
#define Ms MOD_struct


char	Fonts[17*17];			/* Platz fr bis zu 16 Fontnamen		*/
char	melde[1000]= "DON'T PANIC\0Kaffeepause...\0Teepause...\0\
Bin gleich wieder da !\0Nicht stren, ich denke...\0I'am BUSY\0\0";
				/* Vorgegebene Strings. Existiert eine Datei MESSAGE.DAT*/
				/* in der durch 0 (NUL) getrennte Strings stehen, so	*/
				/* werden diese hier eingeschrieben.					*/

Value	Values[6]=
	{	T_POPUP,0,(long)Fonts,
			"Fontauswahl",
		T_EDIT,1,500,"Punktgre des Fonts",
		T_POPUP,0,(long)"jumping\0\3 scrollen\0\2 scrollen\0\
\4 scrollen\0\1 scrollen\0\0",
			"Art der Bewegung",
		T_POPUP,0,(long)melde,
			"Sprche",
		T_BUTTON,0,(long)"Farbscroll","\0",
		T_TITEL|T_END,0,0,"V1.0, HzN 1.93 (Blabla..)"
	};

Value	*Value_s = Values;		/* zeigt auf eine Liste von Pointern	*/


/*
	GRUNDLEGENDES !
	Da die Module ab und zu einmal aufgerufen werden und eben nicht
	kontinuierlich die Kontrolle ber die Register haben, kann es bei
	Benutzung einer Variablen ber mehrere Programmteile (M_INIT,M_SWITCH...)
	zu Problemen kommen, da ja inzwischen wieder 'Sonstwer' in den Registern
	'rumgespielt hat. Deshalb sind solche Variablen als 'static' zu deklarieren,
	im Notfall (wenn's nicht klappt) auch als Volatile.
	Sicher ist sicher...
*/



int		pxy[10];
char	str[100];
volatile static int handle;		/* darf nicht im Register stehn			*/
int		Set_num,col;
ACC_str	*As;

void texter( void );


ULONG MOD_main( int Mode, ACC_str *ACCs )
{
	int i;
	long l;
	char *ch;

	As= ACCs;
	switch( Mode )
	{	case M_INIT:
			MOD_struct.U.b = 0x003f;
			v_opnvwk( As->work_in,&handle,As->work_out );
			if( !handle ) return( 0 );

			strcpy( Fonts,"Sytemfont       " );
			if( vq_gdos() )			/* wenn GEDS, dann Fonts scannen	*/
			{	Set_num= vst_load_fonts( handle,0 );
				if( Set_num>15 ) Set_num=15;	/* Maximal 16 Fants!	*/
				if( Set_num<Ms.Werte[0] ) Ms.Werte[0]= Set_num;
				for( i=1;i<=Set_num;i++ )
				{	ch= &Fonts[i*17];
					strcpy( ch,"                " );
					vqt_name( handle,i,str );	/* Fontnamen holen		*/
					strncpy( ch,str,strlen( str ) );
				}
			}
			else Ms.Werte[0]= 0;

			strcpy( &Ms.MyName[strlen(Ms.MyName)-3],"DAT" );
			if( (i=Fopen( Ms.MyName,FO_READ ))>=0 )
			{	l=Fseek( 0,i,2 );
				Fseek( 0,i,0 );
				if( l<998 )
				{	Fread( i,l,melde );
					melde[l]=0;
					melde[l+1]=0;
				}
				Fclose( i );
			}

			pxy[0]=As->x;
			pxy[1]=As->y;
			pxy[2]=As->x+As->w;
			pxy[3]=As->y+As->h;
			vs_clip( handle,1,pxy );
			break;
		case M_SWITCH:
			v_bar( handle,pxy );
			break;
		case M_DO_IT:
			if( vq_gdos() )
				vst_font( handle,vqt_name( handle,Ms.Werte[0]+1,str ) );
			vst_alignment( handle,0,2,&i,&i );
			vst_point( handle,Ms.Werte[1],&i,&i,&i,&i );
			vqt_attributes( handle,pxy );
			vsf_perimeter( handle,0 );
			pxy[0]= pxy[8];
			pxy[1]= pxy[9];

			col= 2;
			vswr_mode( handle,MD_TRANS );

			texter();

			break;
		case M_EXIT:
			if( handle )
			{	if( Set_num && vq_gdos() ) vst_unload_fonts( handle,0 );
				v_clsvwk( handle );
			}
			break;
	}

	return( 1 );
}


int txt_and_wait( char *str,int x,int y,long wait )
{
	int ex;
	int p[4];

	vst_color( handle,0 );
	if( As->planes>1 )
	{	ex= 1<<(As->planes>8?8:As->planes);
		if( Ms.Werte[4] ) col= (--col%(ex-2))+2;
		vst_color( handle,col );
	}
	v_gtext( handle,x,y,str );
	ex= 0;
	if( ex=EVNT_ask(wait) ) return(ex);
	p[0]= x;
	p[1]= y;
	p[2]= x+pxy[0]-1;
	p[3]= y+pxy[1]-1;
	v_bar( handle,p );
/*	vst_color( handle,1 );
	v_gtext( handle,x,y,str );*/
	return(ex);
}

void get_col( void )
{
	if( !Ms.Werte[4] )
		col=( Random()%((1<<(As->planes>8?8:As->planes))-2)+2 );
}

void texter( void )
{
	int x,y, ex;
	char *cp;

	ex=0;
	cp= melde;
	for( x=0;x<Ms.Werte[3];x++ )
	{	for( ;*cp;cp++ );
		cp++;
	}
	strcpy( str,cp );
	pxy[0] *= strlen( str );
	switch( Ms.Werte[2] )
	{
		case 0:
			for(;;)
			{	x= Random()%(As->w-pxy[0])+As->x;
				y= Random()%(As->h-pxy[1])+As->y;
				get_col();
				if( txt_and_wait( str,x,y,1000 ) ) break;
			}
			break;

		case 1:
			while( !ex )
			{	x= -pxy[0];
				y= Random()%(As->h-pxy[1])+As->y;
				get_col();
				for( ;(x<As->w+As->x) && !ex;x+=4 )
				{	ex= txt_and_wait( str,x,y,100 );
				}
			}
			break;

		case 2:
			while( !ex )
			{	x= Random()%(As->w-pxy[0])+As->x;
				y= -pxy[1];
				get_col();
				for( ;(y<As->h+As->y) && !ex;y+=4 )
				{	ex= txt_and_wait( str,x,y,100 );
				}
			}
			break;
		case 3:
			while( !ex )
			{	x= As->x+As->w;
				y= Random()%(As->h-pxy[1])+As->y;
				get_col();
				for( ;(x>-pxy[0]) && !ex;x-=4 )
				{	ex= txt_and_wait( str,x,y,100 );
				}
			}
			break;

		case 4:
			while( !ex )
			{	x= Random()%(As->w-pxy[0])+As->x;
				y= As->y+As->h;
				get_col();
				for( ;(y>-pxy[1]) && !ex;y-=4 )
				{	ex= txt_and_wait( str,x,y,100 );
				}
			}
			break;
	}
}

