****************************************************************
*                                                              *
*  Assemblermodul fr Zugriff auf das Interface zu ST-Digital  *
*                                                              *
*  Erich Eder, 1989                                            *
*                                                              *
****************************************************************

; Der Modul bietet die im folgenden beschriebenen Funktionen, die
; auch aus Hochsprachen heraus aufgerufen werden knnen.
; Eventuelle Argumente werden dabei als Worte auf dem Stack ber-
; geben. Da jedoch bei Programmen, die in Lattice-C geschrieben
; sind, die Argumente mindestens Langwortlnge haben, mu hierfr
; das Symbol ARGOFF von 4 auf 6 gendert werden.
; Rckgabewerte stehen (falls vorhanden) als Langwort (oder Wort)
; im Register R0.
; Zerstrt werden durch die Routinen nur die Registerinhalte von
; D0, D1 und A0.
;
; Diesen Quellcode knnen Sie - auch in vernderter Form - fr
; Ihre eigenen Programme verwenden.


 XDEF IF_INIT
****************************************************************
* void if_init (ddir)                                          *
*--------------------------------------------------------------*
* Initialisiert das Interface.                                 *
*                                                              *
* Zu bergeben ist ein 16-Bit-Wert, der die Datenrichtung der  *
* einzelnen Anschlsse festlegt, wobei Bit 0 fr den Pin 0     *
* steht, usw. Ein gelschtes Bit spezifiziert einen Eingang,   *
* ein gesetztes einen Ausgang.                                 *
* Eine Reinitialisierung ist mglich.                          *
****************************************************************

 XDEF IF_READ
****************************************************************
* int if_read ()                                               *
*--------------------------------------------------------------*
* Liest Eingabebits.                                           *
*                                                              *
* Zurckgegeben wird ein 16-Bit-Wert, bei dem jedes Bit, dem   *
* Eingang zugeordnet ist (gem Initialisierung), den Zustand  *
* des am entsprechenden Pin anliegenden Signals trgt (0=low,  *
* 1=high). Die Zustnde der als Ausgnge festgelegten Bits ist *
* undefiniert.                                                 *
****************************************************************

 XDEF IF_WRITE
****************************************************************
* void if_write (data)                                         *
*--------------------------------------------------------------*
* Gibt Zustnde an die Ausgnge.                               *
*                                                              *
* Zu bergeben ist ein 16-Bit-Wert, der die Zustnde beinhal-  *
* tet, die an die Ausgnge angelegt werden sollen. Relevant    *
* sind dabei nur die als Ausgnge spezifizierten Bits.         *
****************************************************************

 XDEF IF_STOP
****************************************************************
* void if_stop ()                                              *
*--------------------------------------------------------------*
* Stellt Parallelport wieder auf Druckerbetrieb um.            *
*                                                              *
* (Keine Argumente oder Rckgabewerte)                         *
****************************************************************


****************************************************************

ARGOFF    EQU  4           ; Normalfall
*ARGOFF    EQU  6          ; Fr Lattice-C

SND_BADR  EQU  $FF8800     ; Basisadresse Soundchip

MFP_PORT  EQU  $FFFA01     ; Adresse MFP-Port
MFP_DDIR  EQU  $FFFA05     ; Adresse MFP-Datenrichtungsregister

;---------------------------------------------------------------
   TEXT

PIAPUT:
* Hilfsroutine: Schreibt Byte in PIA-Register
;  in: D0.B = Byte
;      D1.B = Registernummer
;      A0.L = Basisadresse Soundchip

   MOVE.B   #15,(A0)       ; Parallelport selektieren
   MOVE.B   D1,2(A0)       ; PIA-Registernr. ausgeben
   MOVE.B   #14,(A0)       ; mit 
   MOVE.B   (A0),D1        ;  Strobe-
   OR       #$20,D1        ;  Impuls
   MOVE.B   D1,2(A0)       ;  in
   AND      #$DF,D1        ;  Hilfsregister
   MOVE.B   D1,2(A0)       ;  bernehmen
   MOVE.B   #15,(A0)
   MOVE.B   D0,2(A0)       ; Datum ausgeben
   BSET     #0,MFP_PORT    ; Mit Busy-Impuls (Enable)
   BCLR     #0,MFP_PORT    ; an PIA bergeben
   RTS


PIAGET:
* Hilfsroutine: Byte aus PIA-Register lesen
;  in: D0.B = Registernummer
;      A0.L = Basisadresse Soundchip
; out: D0.B = Registerinhalt

   MOVE.B   #15,(A0)
   OR       #%100,D0       ; R/W-Bit fr Lesevorgang setzen
   MOVE.B   D0,2(A0)       ; Registernummer ausgeben
   MOVE.B   #14,(A0)       ; .
   MOVE.B   (A0),D0        ; .
   OR       #$20,D0        ; . Strobe-
   MOVE.B   D0,2(A0)       ; . Impuls
   AND      #$DF,D0        ; .
   MOVE.B   D0,2(A0)       ; .
   MOVE.B   #7,(A0)        ; Parallelport
   MOVE.B   (A0),D1        ;  als
   AND      #127,D1        ;  Eingang
   MOVE.B   D1,2(A0)       ;  schalten
   MOVE.B   #15,(A0)       ;
   BSET     #0,MFP_PORT    ; Busy (->Enable) high
   MOVE.B   (A0),D0        ; Registerinhalt lesen
   BCLR     #0,MFP_PORT    ; Busy low
   MOVE.B   #7,(A0)        ; Parallelport
   OR       #128,D1        ;  wieder
   MOVE.B   D1,2(A0)       ;  Ausgang
   RTS

;---------------------------------------------------------------

IF_INIT:
* initialisiert Interface
;  in: Datenrichtung

   MOVE     ARGOFF(SP),ARG
   PEA      INIT           ; Zugriff nur im Supervisor-Mode mglich
   MOVE     #38,-(SP)
   TRAP     #14            ; supexec
   ADDQ.L   #6,SP
   RTS
INIT:
   LEA      SND_BADR,A0    ; Soundchip-Adresse laden
   MOVE     SR,-(SP)
   MOVE     #$2700,SR      ; Keine Interrupts mehr
   BSET     #0,MFP_DDIR    ; Busy wird Ausgang
   BCLR     #0,MFP_PORT    ; Busy low
   MOVE.B   #15,(A0)       ;
   MOVE.B   #%1000,2(A0)   ; Resetbit ausgeben (wird erst
   MOVE.B   #14,(A0)       ;  im Hilfs-Flip-Flop invertiert!)
   MOVE.B   (A0),D0
   AND      #$DF,D0
   MOVE.B   D0,2(A0)       ; Strobe erst mal auf low
   OR       #$20,D0
   MOVE.B   D0,2(A0)       ; Reset mit Strobeimpuls bergeben
   AND      #$DF,D0
   MOVE.B   D0,2(A0)

   MOVEQ    #%000,D0       ; CRA2-Bit lschen
   MOVEQ    #%01,D1
   BSR      PIAPUT
   MOVE.B   ARG+1,D0       ; Datenrichtung fr Port A -> DDRA
   MOVEQ    #%00,D1
   BSR      PIAPUT
   MOVEQ    #%100,D0       ; CRA2-Bit setzen
   MOVEQ    #%01,D1
   BSR      PIAPUT
   MOVEQ    #%000,D0       ; CRB2-Bit lschen
   MOVEQ    #%11,D1
   BSR      PIAPUT
   MOVE.B   ARG,D0         ; Datenrichtung fr Port B -> DDRB
   MOVEQ    #%10,D1
   BSR      PIAPUT
   MOVEQ    #%100,D0       ; CRB2-Bit setzen
   MOVEQ    #%11,D1
   BSR      PIAPUT
   MOVE     (SP)+,SR       ; Interrupts wieder mglich
   RTS

;---------------------------------------------------------------

IF_STOP:
* Parallelport wieder auf Druckerbetrieb schalten

   PEA      STOPA          ; Ausfhrung im Supervisor-Mode
   MOVE     #38,-(SP)
   TRAP     #14            ; supexec
   ADDQ.L   #6,SP
   RTS
STOPA:
   LEA      SND_BADR,A0    ; Soundchip-Adresse laden
   MOVE     SR,D1
   MOVE     #$2700,SR      ; Interrupts disablen
   BCLR     #0,MFP_DDIR    ; Busy wieder Eingang
   MOVE.B   #14,(A0)
   MOVE.B   (A0),D0
   OR       #$20,D0
   MOVE.B   D0,2(A0)       ; Strobe auf low
   MOVE     D1,SR          ; Interrupts enablen
   RTS

;---------------------------------------------------------------

IF_READ:
* liest Eingabebits
; out: Eingabebits

   PEA      READ           ; Ausfhrung im Supervisor-Mode
   MOVE     #38,-(SP)
   TRAP     #14            ; supexec
   ADDQ.L   #6,SP
   CLR.L    D0             ; Returnwert bergeben
   MOVE     RETURN,D0
   RTS
READ:
   LEA      SND_BADR,A0    ; Soundchip-Adresse laden
   MOVE     SR,-(SP)
   MOVE     #$2700,SR      ; Interrupts disablen
   MOVEQ    #%00,D0        ; Port A -> niederwertiges Byte
   BSR      PIAGET
   MOVE.B   D0,RETURN+1
   MOVEQ    #%10,D0        ; Port B -> hherwertiges Byte
   BSR      PIAGET
   MOVE.B   D0,RETURN
   MOVE     (SP)+,SR       ; Interrupts enablen
   RTS

;---------------------------------------------------------------

IF_WRITE:
* Gibt Zustnde an die Ausgnge
*  in: Daten

   MOVE     ARGOFF(SP),ARG
   PEA      WRITE          ; Ausfhrung im Supervisor-Mode
   MOVE     #38,-(SP)
   TRAP     #14            ; supexec
   ADDQ.L   #6,SP
   RTS
WRITE:
   LEA      SND_BADR,A0    ; Soundchip-Adresse laden
   MOVE     SR,-(SP)
   MOVE     #$2700,SR      ; Interrupts disablen
   MOVE.B   ARG+1,D0     ; niederwertiges Byte -> Port A
   MOVEQ    #%00,D1
   BSR      PIAPUT
   MOVE.B   ARG,D0       ; hherwertiges Byte -> Port B
   MOVEQ    #%10,D1
   BSR      PIAPUT
   MOVE     (SP)+,SR       ; Interrupts enablen
   RTS

****************************************************************

   BSS

ARG:      DS 1             ; Hilfsvaribale fr Argumentwerte
RETURN:   DS 1             ; Hilfsvariable fr Rckgabewert

   END

