.TH Pwait3 2 "MiNT Programmer's Manual" "Version 0.9" "Oct. 1, 1991"
.SH NAME
Pwait, Pwait3 \- get exit status of children
.SH SYNOPSIS
.nf
LONG Pwait();
LONG Pwait3( WORD flag, LONG *rusage ); 
.fi
.SH DESCRIPTION
.I Pwait3
attempts to determine the exit code for any stopped children or children
that have terminated. If bit 1 of
.I flag
is set, then children that are stopped due to job control are reported;
otherwise only children that have actually terminated are reported. A
stopped process will be reported at most once (unless it is re-started and
stopped again); similarly a terminated process will be
reported only once.
.PP
If the process does have children, but none are currently stopped or
terminated and not yet waited for, then the behavior of
.I Pwait3
is controlled by bit 0 of
.IR flag .
If it is clear, the function will wait until some child is stopped or
terminates; if it is set, the function will return immediately.
.PP
The
.I rusage
parameter, if non-zero, should point to two long words, into which
information about the child's CPU time usage is placed, as follows:
.nf
rusage[0]: milliseconds spent by child in user space
rusage[1]: milliseconds spent by child in kernel space
.fi
.PP
The
.IR Pwait ()
system call is equivalent to
.IR Pwait3 (2,
(LONG *)0),
and is provided both for convenience and for backward compatibility.
.SH RETURNS
If a child process is found, its process id is placed in the upper 16 bits
of the 32 bit value returned, and its exit status (as passed to
.I Pterm
or
.IR Ptermres ,
as determined implicitly by
.IR Pterm0 ,
or as determined by the type of signal that stopped or killed the process)
is placed in the lower 16 bits. If the process was stopped or terminated
by signal
.IR n ,
then its exit status will be (
.IR n <<
8 ) |
.IR x .
where
.I x
is 127 if the process was stopped and 0 if the process was terminated.
.PP
0 if bit 0 of
.I flag
is set and the
.I Pwait3
system call would have otherwise blocked waiting for a child to exit
or stop.
.PP
EFILNF if no unwaited for children exist
.SH "SEE ALSO"
.IR Pexec (2),
.IR Pterm (2),
.IR Pterm0 (2),
.IR Ptermres (2)
.SH BUGS
It is not possible to wait for a specific child process.
