/*********************************************************/
/*																		 	*/
/*						 	 Demo-Quelltext fr						*/
/*							die Bearbeitung von						*/
/*							 Off-Screen-Bitmaps						*/
/*																			*/
/*********************************************************/
/* sb */
/* 28.04.93 */

/* Includes */
#include <portab.h>
#include <vdi.h>
#include <aes.h>
#include <tos.h>
#include	<eddilib.h>

/* Funktionsprototypen */
WORD	open_vwk( WORD *work_out );
WORD	open_bitmap( WORD x, WORD y, MFDB *bitmap, WORD *work_out );
void	clip_screen( void );		
void	clip_bitmap( void );		
void	draw( void );

/* Globale Variablen */
WORD  s_handle,
		b_handle,
		screen_out[128],
		bitmap_out[128];
MFDB	bitmap,
		screen;

/* virtuelle Workstation ffnen */
WORD	open_vwk( WORD *work_out )
{
	WORD	count,
			dummy,
			handle,
			work_in[11];

	handle = graf_handle( &dummy, &dummy, &dummy, &dummy );

	for( count = 1; count < 10; count++ )
		work_in[count] = 1;

	work_in[0] = Getrez()+2; 
	work_in[10] = 2;								/* Rasterkoordinaten */

	v_opnvwk( work_in, &handle, work_out );

	return( handle );
}

/* Off-Screen-Bitmap ffnen */
WORD	open_bitmap( WORD x, WORD y, MFDB *bitmap, WORD *work_out )
{
	WORD	count,
			dummy,
			handle,
			work_in[20];

	handle = graf_handle( &dummy, &dummy, &dummy, &dummy );

	for ( count = 1; count < 10; count++ )
		work_in[count] = 1;

	work_in[0] = Getrez()+2; 
	work_in[10] = 2;								/* Rasterkoordinaten */
	work_in[11] = x;								/* Breite - 1 */
	work_in[12] = y;								/* Hhe - 1 */
	work_in[13] = work_in[14] = 0;			/* Pixelbreite und -Hhe des Bildschirms bernehmen */
	
	for ( count = 15; count < 20; count++ )
		work_in[count] = 0;						/* reserviert */
	
	v_opnbm( work_in, bitmap, &handle, work_out );

	return( handle );
}

/* Clipping fr den Bildschirm setzen */
void	clip_screen( void )		
{
	WORD	xyarr[4];
	
	xyarr[0] = 0;
	xyarr[1] = 0;
	xyarr[2] = screen_out[0];
	xyarr[3] = screen_out[1];
	vs_clip( s_handle, 1, xyarr );	/* Clipping fr den Bildschirm */
}

/* Clipping fr die Bitmap setzen */
void	clip_bitmap( void )		
{
	WORD	xyarr[4];
	
	xyarr[0] = 0;
	xyarr[1] = 0;
	xyarr[2] = bitmap_out[0];
	xyarr[3] = bitmap_out[1];
	vs_clip( b_handle, 1, xyarr );	/* Clipping fr den Bildschirm */
}

/* Auf der Off-Screen-Bitmap zeichnen */
void	draw( void )
{
	BYTE	bezarr[512];
	WORD	xyarr[512],
			extent[4],
			actual,
			totpts,
			totmoves;

	vsf_color( b_handle, 3 );
	vsf_interior( b_handle, 2 ); 
	vsf_style( b_handle, 1 );
	vsf_perimeter( b_handle, 1 );
	vswr_mode( b_handle, 1 );
	
	xyarr[0] = 0;
	xyarr[1] = 0;
	xyarr[2] = 250;
	xyarr[3] = 250;
	v_bar( b_handle, xyarr );
	
	vsf_color( b_handle, 1 );
	vsf_style( b_handle, 3 );
	v_bez_on( b_handle );
	v_bez_qual( b_handle, 100, &actual );
	
	xyarr[0] = 100;
	xyarr[1] = 100;
	xyarr[2] = 400;
	xyarr[3] = 100;
	xyarr[4] = 400;
	xyarr[5] = 400;
	xyarr[6] = 100;
	xyarr[7] = 400;
	
	xyarr[8] = 200;
	xyarr[9] = 200;
	xyarr[10] = 300;
	xyarr[11] = 200;
	xyarr[12] = 300;
	xyarr[13] = 300;
	xyarr[14] = 200;
	xyarr[15] = 300;

	bezarr[0] = 1;
	bezarr[1] = 0;
	bezarr[2] = 0;
	bezarr[3] = 0;
	bezarr[4] = 3;
	bezarr[5] = 0;
	bezarr[6] = 0;
	bezarr[7] = 0;
	 
	_v_bez_fill( b_handle, 8, xyarr, bezarr, extent, &totpts, &totmoves );
	v_bez_off( b_handle );
	
	v_gtext( b_handle, 50, 50, "Text!" );
}

main()
{
	WORD	xyarr[8];
	
	if (( s_handle = open_vwk( screen_out )) != 0 )
	{
		bitmap.fd_addr = 0;						/* VDI alloziert Bitmap */
		bitmap.fd_nplanes = 0;					/* Planeanzahl wie Bildschirm */
		if (( b_handle = open_bitmap( 799, 607, &bitmap, bitmap_out)) != 0 )
		{
			clip_screen();							/* Clipping fr den Bildschirm setzen */
			clip_bitmap();							/* Clipping fr die Bitmap setzen */
			draw();									/* auf der Off-Screen-Bitmap zeichnen */

			/* und jetzt die Bitmap auf den Bildschirm kopieren... */
			screen.fd_addr = 0;
			xyarr[0] = 0;
			xyarr[1] = 0;
			xyarr[2] = 799;
			xyarr[3] = 607;
			xyarr[4] = 100;
			xyarr[5] = 100;
			xyarr[6] = 899;
			xyarr[7] = 707;
			vro_cpyfm( s_handle, S_ONLY, xyarr, &bitmap, &screen );
	
			v_clsbm( b_handle );					/* Bitmap schlieen */
		}
		v_clsvwk( s_handle );					/* virtuelle Workstation schlieen */
	} 
	return(0);	
}