;     ************
;     *	symphony * -->	 IDEAL ASSEMBLER von OMIKRON
;     ************

geschw	=	3

	linea	$a			; maus aus

	pea	init			; aufruf der subroutine
	move.w	#$26,-(a7)		; INIT
	trap	#14			; im supervisor-mode
	addq.l	#6,a7

	move.w	#2,-(a7)		; bitte	einmal
	move.w	#2,-(a7)		; auf tastendruck
	trap	#13			; warten
	addq.l	#4,a7			; !! loescht den buffer	vorher nicht !!

	pea	cut			; aufruf der subroutine
	move.w	#$26,-(a7)		; CUT
	trap	#14			; im supervisor-mode
	addq.l	#6,a7

	clr.w	-(a7)
	trap	#1
;----------------------------------------------------------------


init:
	move.w	#geschw,speed
	move.w	speed,speed+2
	move.w	#1,sy			; stop synti
	moveq	#2,d0
	lea	stimme1(pc),a0
	lea	stimme2(pc),a1		; start	von st.	1 u. 2
	move.l	a1,a2
	sub.l	a0,a2
	move.l	a2,d1
	lea	pointer(pc),a1

initloop:
	moveq	#1,d3
	clr.l	4(a0)
	move.l	(a1),(a0)
	clr.l	8(a0)
	clr.l	$c(a0)
	clr.l	$14(a0)
	clr.l	$18(a0)
	clr.l	$1c(a0)
	move.l	(a1)+,a2

get_nb:
	move.b	(a2)+,d2
	btst	#7,d2
	beq.s	ino_tp
	and.b	#$7f,d2
	move.b	d2,$1d(a0)
	addq.l	#1,d3
	bra.s	get_nb

ino_tp:
	and.l	#$7f,d2
	add.l	d2,d2
	add.l	d2,d2
	lea	seqtab(pc),a2
	move.l	0(a2,d2.w),a2
	move.l	a2,$10(a0)
	move.l	d3,$04(a0)
	add.l	d1,a0
	dbf	d0,initloop
	move.b	#2,$484
	move.l	#syn,$4d2
	clr.w	sy
	rts

;------------------------------------------------------------------------------

cut:
	clr.l	$4d2
	move.w	#1,sy
	bra	syn

;------------------------------------------------------------------------------

syn:
	tst.w	sy
	beq.s	synein
	lea	ym2149(pc),a0
	moveq	#9,d0

reglloop:
	clr.b	(a0)+
	dbf	d0,reglloop
	move.b	#%11111000,ym2149+7
	bra	wrsochip

synein:
	subq.w	#1,speed
	bpl	so_work
	lea	stimme1(pc),a0
	bsr	bearbeit

	lea	stimme2(pc),a0
	bsr	bearbeit

	lea	stimme3(pc),a0
	bsr	bearbeit

	move.w	speed+2(pc),speed


so_work:

	lea	stimme1(pc),a0
	bsr	so_bearb
	move.w	d0,dummy
	move.b	d0,ym2149
	move.b	dummy,ym2149+1
	move.b	d1,ym2149+8

	lea	stimme2(pc),a0
	bsr	so_bearb
	move.w	d0,dummy
	move.b	d0,ym2149+2
	move.b	dummy,ym2149+3
	move.b	d1,ym2149+9

	lea	stimme3(pc),a0
	bsr	so_bearb
	move.w	d0,dummy
	move.b	d0,ym2149+4
	move.b	dummy,ym2149+5
	move.b	d1,ym2149+10

wrsochip:
	moveq	#$a,d0
	lea	ym2149+11(pc),a0

wr_loop:
	move.b	d0,$ffff8800
	move.b	-(a0),$ffff8802
	dbf	d0,wr_loop
	rts

;------------------------------------------------------------------------------

bearbeit:
	subq.b	#1,$0f(a0)
	bpl	return

bearb2:
	clr.b	$24(a0)
	move.l	$10(a0),a1
	move.b	(a1)+,d0
	cmp.b	#$ff,d0
	bne	noend
	move.l	(a0),a2
	add.l	4(a0),a2
	addq.l	#1,$4(a0)
	move.b	(a2)+,d0
	cmp.b	#$ff,d0
	bne	noend2
	move.l	#1,$4(a0)
	move.l	(a0),a2
	btst	#$7,(a2)
	beq	notran2
	move.b	(a2)+,d0
	and.b	#$7f,d0
	move.b	d0,$1d(a0)
	move.l	#2,$4(a0)

notran2:
	move.b	(a2),d0

noend2:
	btst	#$7,d0
	beq.s	notran
	and.b	#$7f,d0
	move.b	d0,$1d(a0)
	move.b	(a2)+,d0
	addq.l	#1,$4(a0)

notran:
	and.l	#$7f,d0
	add.l	d0,d0
	add.l	d0,d0
	lea	seqtab(pc),a2
	add.l	d0,a2
	move.l	(a2),$10(a0)
	bra	bearb2

noend:
	btst	#$5,d0
	beq	kein_anh
	bset	#$1,$28(a0)

kein_anh:
	btst	#$7,d0
	beq	nowave
	and.b	#$1f,d0
	move.b	d0,$f(a0)
	move.b	(a1)+,d0
	and.l	#$1f,d0
	add.l	d0,d0
	add.l	d0,d0
	lea	wavetab(pc),a2
	move.l	0(a2,d0.w),a2
	move.b	(a2)+,d0
	move.b	(a2),$c(a0)
	move.b	(a2)+,$d(a0)
	move.b	(a2)+,$26(a0)
	move.b	(a2),$25(a0)
	move.b	(a2)+,$27(a0)
	move.l	a2,$8(a0)
	move.l	a2,$1e(a0)
	and.l	#$7f,d0
	add.l	d0,d0
	add.l	d0,d0
	lea	arpegtab(pc),a2
	move.l	0(a2,d0.w),a2
	move.b	(a2),$1c(a0)
	move.b	(a2)+,$22(a0)
	move.l	a2,$14(a0)
	move.l	a2,$18(a0)
	move.b	(a1)+,$23(a0)
	bra	init_snd

nowave:
	btst	#$6,d0
	beq	nopause
	and.b	#$1f,d0
	move.b	d0,$0f(a0)
	clr.b	$23(a0)
	move.b	#$1,$24(a0)
	bra	init_snd

nopause:
	and.b	#$1f,d0
	move.b	d0,$0f(a0)
	move.b	(a1)+,$23(a0)

init_snd:
	bset	#6,$28(a0)
	move.l	a1,$10(a0)
	btst	#1,$28(a0)
	bne	return
	move.b	$d(a0),$c(a0)
	move.b	$22(a0),$1c(a0)
	move.l	$14(a0),$18(a0)
	move.l	$1e(a0),$08(a0)

return:
	bclr	#1,$28(a0)
	rts

;------------------------------------------------------------------------------

so_bearb:
	clr.l	d0
	subq.b	#1,$1c(a0)
	bne	noendarp
	move.b	$22(a0),$1c(a0)

nochmarp:
	move.l	$18(a0),a2
	addq.l	#1,$18(a0)
	cmp.b	#$ff,(a2)
	bne	noendar2
	move.l	$14(a0),$18(a0)
	bra	nochmarp

noendarp:
	move.l	$18(a0),a2

noendar2:
	move.b	(a2),d0
	add.b	$23(a0),d0
	add.b	$1d(a0),d0
	sub.b	#$c,d0
	bpl	noteok
	clr.l	d0

noteok:
	lea	freqtab(pc),a1
	and.l	#$7f,d0
	add.l	d0,d0
	add.l	d0,a1
	move.w	(a1),d0
	and.l	#$ffff,d0

	moveq	#0,d1
	move.b	$28(a0),d6
	btst	#6,d6
	beq	novibrat
	move.b	d1,d5
	move.b	$25(a0),d4
	move.b	$27(a0),d1
	btst	#7,d6
	bne	vibrato
	btst	#0,d6
	beq	sec_time

vibrato:
	btst	#5,d6
	bne	hochvib
	sub.b	$26(a0),d1
	bcc	wr_back
	bset	#5,$28(a0)
	moveq	#0,d1
	bra	wr_back

hochvib:
	add.b	$26(a0),d1
	cmp.b	d4,d1
	bcs	wr_back
	bclr	#5,$28(a0)
	move.b	d4,d1

wr_back:
	move.b	d1,$27(a0)

sec_time:
	lsr.b	#1,d4
	sub.b	d4,d1
	bcc	gnull
	sub.w	#$100,d1

gnull:
	add.b	#$a0,d5
	bcc	addiere

nochmal:
	add.w	d1,d1
	add.b	#$18,d5
	bcc	nochmal

addiere:
	add.w	d1,d0

novibrat:
	bchg	#0,$28(a0)
	clr.l	d1
	tst.b	$24(a0)
	bne	pauseok
	subq.b	#1,$c(a0)
	bne	endadsr
	move.b	$d(a0),$c(a0)
	move.l	8(a0),a1
	cmp.b	#$ff,1(a1)
	beq	endadsr
	addq.l	#1,$8(a0)

endadsr:
	move.l	8(a0),a1
	move.b	(a1),d1

pauseok:

	;	***   output   ***
	;	d0.w ->	frequenz
	;	d1.b ->	volume

	rts

.data
ym2149:
	.dc.b	0,0,0,0,0,0,0,%11111000,0,0,0

.even

;----------
stimme1:
	.dc.l	0	;$00
	.dc.l	0	;$04
	.dc.l	0	;$08
	.dc.b	0	;$0c
	.dc.b	0	;$0d
	.dc.b	0	;$0e
	.dc.b	0	;$0f
	.dc.l	0	;$10
	.dc.l	0	;$14
	.dc.l	0	;$18
	.dc.b	0	;$1c
	.dc.b	0	;$1d
	.dc.l	0	;$1e
	.dc.b	0	;$22
	.dc.b	0	;$23
	.dc.b	0	;$24
	.dc.b	0	;$25
	.dc.b	0	;$26
	.dc.b	0	;$27
	.dc.b	0	;$28

.even

;----------
stimme2:
	.dc.l	0	;$00
	.dc.l	0	;$04
	.dc.l	0	;$08
	.dc.b	0	;$0c
	.dc.b	0	;$0d
	.dc.b	0	;$0e
	.dc.b	0	;$0f
	.dc.l	0	;$10
	.dc.l	0	;$14
	.dc.l	0	;$18
	.dc.b	0	;$1c
	.dc.b	0	;$1d
	.dc.l	0	;$1e
	.dc.b	0	;$22
	.dc.b	0	;$23
	.dc.b	0	;$24
	.dc.b	0	;$25
	.dc.b	0	;$26
	.dc.b	0	;$27
	.dc.b	0	;$28

.even

;----------
stimme3:
	.dc.l	0	;$00
	.dc.l	0	;$04
	.dc.l	0	;$08
	.dc.b	0	;$0c
	.dc.b	0	;$0d
	.dc.b	0	;$0e
	.dc.b	0	;$0f
	.dc.l	0	;$10
	.dc.l	0	;$14
	.dc.l	0	;$18
	.dc.b	0	;$1c
	.dc.b	0	;$1d
	.dc.l	0	;$1e
	.dc.b	0	;$22
	.dc.b	0	;$23
	.dc.b	0	;$24
	.dc.b	0	;$25
	.dc.b	0	;$26
	.dc.b	0	;$27
	.dc.b	0	;$28

.even

;----------

sy:
	.dc.w	1	;	0 -> ein , 1 ->	aus

dummy:
	.dc.w	0

speed:
	.dc.w	0,0

;----------

freqtab:
	.dc.b 014,238,014,023,013,077,012,142,011,217,011,047,010,142,009,247
	.dc.b 009,103,008,224,008,097,007,232,007,119,007,011,006,166,006,071
	.dc.b 005,236,005,151,005,071,004,251,004,179,004,112,004,048,003,244
	.dc.b 003,187,003,133,003,083,003,035,002,246,002,203,002,163,002,125
	.dc.b 002,089,002,056,002,024,001,062,001,044,001,194,001,169,001,145
	.dc.b 001,123,001,101,001,081,001,062,001,044,001,028,001,012,000,253
	.dc.b 000,238,000,225,000,212,000,200,000,189,000,178,000,168,000,159
	.dc.b 000,150,000,142,000,134,000,126,000,119,000,112,000,106,000,100
	.dc.b 000,094,000,089,000,084,000,079,000,075,000,071,000,067,000,063
	.dc.b 000,059,000,056,000,053,000,050,000,047,000,044,000,042,000,039
	.dc.b 000,037,000,035,000,033,000,031,000,029,000,028,000,026,000,025
	.dc.b 000,023,000,022,000,021,000,019,000,018,000,017,000,016,000,015

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;	ab hier	stehen die, fuer den Benutzer wichtige Daten
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;
;------------------------------------------------------------------------------
;	arpeggiotab-aufbau
;	1. byte	-> geschwindigkeit
;	2. byte	-> byte	= $ff (arpeggio-tabellen)
;------------------------------------------------------------------------------
; (zeiger auf die arpeggio-tabellen)
.even
arpegtab:
	.dc.l	arp0,arp1,arp2,arp3

;	die arpeggio-tabellen
arp0:	.dc.b	1,$0,$0,$0,$0,$ff
arp1:	.dc.b	1,$c,$7,$4,$0,$ff
arp2:	.dc.b	1,$c,$7,$3,$0,$ff
arp3:	.dc.b	1,$c,$9,$5,$0,$ff


;------------------------------------------------------------------------------
; der wellentab-aufbau
; 1. byte -> arpeggio-tabell (0= kein arpeggio)
; 2. byte -> geschwindigkeit mit der die adsr-tabelle abgearbeitet wird
; 3. byte -> vibrato-geschwindigkeit
; 4. byte -> vibrato-staerke
; 5. byte -> byte = $ff	-> adrs-huellkurve
;------------------------------------------------------------------------------
.even
wavetab:
	.dc.l	wave0,wave1,wave2,wave3

wave0:	.dc.b	1,4,00,00,$f,$e,$d,$c,$b,$a,$9,$8,$7,$6,$5,$4,$3,$2,$1,$0,$ff
wave1:	.dc.b	2,4,00,00,$f,$e,$d,$c,$b,$a,$9,$8,$7,$6,$5,$4,$3,$2,$1,$0,$ff
wave2:	.dc.b	0,4,16,08,$f,$e,$d,$c,$b,$a,$9,$8,$7,$6,$5,$4,$3,$2,$1,$0,$ff
wave3:	.dc.b	0,4,08,10,$f,$e,$d,$ff


;------------------------------------------------------------------------------
;	zeiger auf die sequenz-tabellen
;------------------------------------------------------------------------------
.even
pointer:
	.dc.l	seqst1,seqst2,seqst3

seqst1:	.dc.b	$80,$04,$04,$85,$06,$06,$80,$06,$06,$85,$06,$06,$87,$06,$06
	.dc.b	$80,$04
	.dc.b	$ff

seqst2:	.dc.b	$80,$01,$01,$85,$01,$01,$87,$01,$85,$01,$80,$01,$01
	.dc.b	$80,$01,$01,$85,$01,$01,$87,$01,$85,$01,$80,$01,$01
	.dc.b	$85,$01,$01,$80,$01,$01,$85,$01,$01,$87,$01,$01
	.dc.b	$80,$01,$01,$85,$01,$01,$87,$01,$85,$01,$80,$01,$01
	.dc.b	$ff

seqst3:	.dc.b	$80,$00,$00,$02,$85,$03,$87,$02,$80,$03
	.dc.b	$85,$5,$5,$80,$5,$5,$85,$5,$5,$87,$5,$5
	.dc.b	$80,$02,$85,$03,$87,$02,$80,$03
	.dc.b	$ff


;------------------------------------------------------------------------------
;	zeiger auf die einzelnen sequenzen
;------------------------------------------------------------------------------
.even
seqtab:
	.dc.l	pause,bass0,arpt0,arpt1,haupt0,hall0,haupt1

pause:	.dc.b	$5f,$ff


bass0:	.dc.b	$81,$02,$18,$01,$18,$01,$24,$01,$18
	.dc.b	$ff

arpt0:	.dc.b	$83,$00,$3c,$03,$3c,$01,$3c,$05,$3c
	.dc.b	$ff

arpt1:	.dc.b	$83,$00,$3c,$01,$3c,$03,$3c,$01,$3c,$01,$3c,$01,$3c
	.dc.b	$ff

haupt0:	.dc.b	$83,$03,$34,$03,$30,$01,$34,$05,$30,$03,$35,$01,$32,$03
	.dc.b	$35,$01,$32,$01,$35,$01,$32,$03,$37,$03,$32,$01,$35,$05
	.dc.b	$32,$03,$34,$01,$30,$03,$34,$01,$30,$01,$34,$01,$30
	.dc.b	$ff

hall0:	.dc.b	$80,$02,$30,$20,$34,$20,$37,$20,$3c,$20,$30,$20,$34,$20
	.dc.b	$37,$20,$3c
	.dc.b	$ff

haupt1:	.dc.b	$81,$00,$3c,$01,$3c,$01,$48,$01,$3c
	.dc.b	$ff

.even
.end
