/* ------------------------------------------------------------------------
 *		CRC.LIB
 *		Assemblerroutines (68000er) for CRC calculations;
 *
 *		(c) 1994 by Jan Kriesten, D-35039 Marburg, FidoNet: 2:244/4344
 *
 *		The CRC tables are included in the library.
 * 
 *		The xxBlk-Routines will automatically branch to xxShort
 *		if blocklength < 0xffffL.
 */

#ifndef __CRC_H__
#define __CRC_H__

/*--- includes              ---*/

/*--- defines               ---*/

/*--- types                 ---*/

/*--- variables             ---*/

/*--- prototypes            ---*/

/*
 * CRC-CCITT (x^16+x^12+x^5+1)
 */
extern	unsigned int	Crc16cTab[256];

unsigned int	Crc16cStr		( unsigned char *str );
unsigned int	Crc16cBlk		( unsigned char *blk, unsigned long length );
unsigned int	Crc16cUpd		( unsigned int crc, unsigned char c );
unsigned int	Crc16cBlkUpd	( unsigned int oldcrc, unsigned char *blk, unsigned long length );
unsigned int	Crc16cShort		( unsigned int oldcrc, unsigned char *blk, int length );

/*
 *  The return values of the following functions have to be
 *  negated at the end of calculation!
 */

/*
 * CRC-16 (x^16+x^15+x^2+1)
 */
extern	unsigned int	Crc16Tab[256];

unsigned int	Crc16Str		( unsigned char *str );
unsigned int	Crc16Blk		( unsigned char *blk, unsigned long length );
unsigned int	Crc16Upd		( unsigned int crc, unsigned char c );
unsigned int	Crc16BlkUpd		( unsigned int oldcrc, unsigned char *blk, unsigned long length );
unsigned int	Crc16Short		( unsigned int oldcrc, unsigned char *blk, int length );


/*
 * CRC-32 (x^32+x^26+x^23+x^22+x^16+x^12+x^11+x^10+x^8+x^7+x^5+x^4+x^2+x+1)
 */
extern	unsigned long	Crc32Tab[256];

unsigned long	Crc32Str		( unsigned char *str );
unsigned long	Crc32Blk		( unsigned char *blk, unsigned long length );
unsigned long	Crc32Upd		( unsigned long crc, unsigned char c );
unsigned long	Crc32BlkUpd		( unsigned long oldcrc, unsigned char *blk, unsigned long length );
unsigned long	Crc32Short		( unsigned long oldcrc, unsigned char *blk, int length );

/*--- End of crc.h module  ---*/
#endif

