*************************************************************************
*																		*
*								DJ550DAT.S								*
*																		*
*************************************************************************

*************************************************************************
*																		*
*	This module contains definitions of global constants and			*
*	variables used by the assembler portion of the Hewlett-Packard		*
*	PaintJet printer driver.											*
*																		*
*	This code has been brought up-to-date with the printer				*
*	driver source received 5/31/85.										*
*	J. Shillington, Bell Northern Research								*
*																		*
*	This code has been brought up-to-date with the printer				*
*	driver source received 10/1/86.										*
*	A. Hackerfrom, Atari Corp.											*
*																		*
*	This code has been modified.  10/13/88 dlf Atari Corp.				*
*																		*
*	Modifications made by Theresa Estrada 4/10/91 Atari Corp.			*
*																		*
*************************************************************************
*	Portion de Code pour driver HP DeskJet 550c en CYMK.				*
*																		*
*   Modifi par Thierry Rodolfo	24/03/1994	(France)					*
*																		*
*	Participation de : Brainstorm developement							*
*					   Marc Abramson									*
*					   DAVID RENE										*
*																		*
*************************************************************************


	.data
	.page
*************************************************************************
*																		*
*		Locally Defined Constants and Variables							*
*																		*
*************************************************************************

	.globl	CONTRL_SIZE
	.globl	INTIN_SIZE
	.globl	PTSIN_SIZE
	.globl	INTOUT_SIZE
	.globl	PTSOUT_SIZE
	.globl	xresmx
	.globl	yresmx
	.globl	xsize
	.globl	ysize
	.globl	num_planes
	.globl	num_colors
	.globl	bytes_line
	.globl	byte_offset		* For 24 pin (NB15) implementation
	.globl	back16			*
	.globl	print_wires
	.globl	scan_line_offset
	.globl	slice_width
	.globl	slice_offset
	.globl	bytes_per_scan
	.globl	def_sl_cnt
	.globl	def_sl_sz
	.globl	def_plane_sz
	.globl	drast_sz
	.globl	dlist_sz
	.globl	drast_ad
	.globl	dlist_ad
	.globl	min_free
	.globl	max_list
	.globl	max_rast
	.globl	_g_maxrast		* global max rast buf size 9/5/91 TE
	.globl	_curalpha
	.globl	_reqalpha
	.globl	_com_port
	.globl	_vmu
	.globl	_A_PAGE
	.globl	_A_SLICE
	.globl	_G_PAGE
	.globl	_G_SLICE
	.globl	_DIV_FACT
	.globl	_DEV_TAB
	.globl	_SIZ_TAB
	.globl	_INQ_TAB
	.globl	_INQ_PTS
	.globl	_CLIP
	.globl	_XMN_CLIP
	.globl	_XMX_CLIP
	.globl	_YMN_CLIP
	.globl	_YMX_CLIP
	.globl	_m_dot
	.globl	_m_plus
	.globl	_m_star
	.globl	_m_square
	.globl	_m_cross
	.globl	_m_dmnd
	.globl	_newbuff_ad

*  DRIVER STRUCTURE VARIABLES
	.globl	_QUALITY
	.globl	CONFIG_MAP
	.globl	NPLANES
	.globl	TOTPLANES
	.globl	PLANE_VALS
	.globl	XDPI
	.globl	YDPI
	.globl	PAGESIZE
	.globl	XRES
	.globl	YRES
	.globl	PORT
	.globl	PAPER_FEED
	.globl	PRINTER_NAME
	.globl	PGSZ_TAB

	.globl	_TOPMRGN	* TE 8/10/92
	.globl	_BOTMRGN
	.globl	_LFTMRGN
	.globl	_RHTMRGN
	.globl	TOPMRGN2	* TE 8/17/92
	.globl	BOTMRGN2
	.globl	LFTMRGN2
	.globl	RHTMRGN2
	
*************************************************************************
*																		*
*			Parameter Array Sizes										*
*																		*
*************************************************************************

CONTRL_SIZE	.equ	11
INTIN_SIZE	.equ	256
PTSIN_SIZE	.equ	2048
INTOUT_SIZE	.equ	128
PTSOUT_SIZE	.equ	12

*************************************************************************
*																		*
*	HP_DJ550	 High Resolution Printer Constants						*
*																		*
*	Taille de la page 8.0 x 10.4 inches au format lettre				*
*	Exemple pour calculer la taille en point de la page:				*
*		8.0 inches * 300 DPI -1 = Nombre de point en horizontale		*
*	   10.4 inches * 300 DPI -1 = Nombre de point en verticale			*
*	Ce qui donne pour:													*
*	300 DPI en horizontale = 2399 points								*
*	300 DPI en verticale   = 3119 points								*
*	La taille en micron pour 300 DPI est calculer par la formule:		*
*		1/.00003937 = x/(1/300)	 Formule amricaine						*
*		1/.00003937/300			 Formule franaise						*
*   Le resultat doit etre arrondi!										*
*	Ce qui donne pour 300 DPI, 85 micron cette valeur doit etre			*
*	modifie dans le fichier DJ550DEP.S									*
*																		*
*************************************************************************


xresmx		ds.w	1		* maximum resolution in x
yresmx		ds.w	1		* maximum resolution in y
xsize		ds.w	1		* x pixel size in microns
ysize		ds.w	1		* y pixel size in microns

num_planes	ds.w	1		* number of planes
num_colors	ds.w	1		* number of colors on screen
bytes_line	ds.w	1		* bytes per scan line
* 							This must be an even value!!!
	.page
*************************************************************************
*																		*
*		Display List/Rasterizing Buffer Equates							*
*																		*
*************************************************************************

print_wires			ds.w	1		* eight lines per print pass
slice_width			ds.w	1		* # of lines per slice
slice_offset		ds.w	1		* minus 1 if fx80
scan_line_offset	ds.w	1		* offset to next scan in slice
bytes_per_scan		ds.w	1		*bytes_line
*
*
def_sl_cnt			ds.w	1		* default number of slices
def_sl_sz			ds.w	1		* default slice size
def_plane_sz		ds.w	1		* default raster
* 									  buffer size for 1 plane
drast_sz			ds.l	1		* default raster buffer
* 									  size for all planes
dlist_sz			ds.l	1	* Internal Display List Buffer size
min_free			ds.l	1	* Minimum Amount of Free Memory Left
max_list			ds.l	1	* Maximum Display List Buffer size
_g_maxrast						* Global maximum rasterizing buf size
max_rast:			ds.l	1	* Maximum Rasterizing Buffer size
*
dlist_ad:			ds.l	1
drast_ad:			ds.l	1
*
byte_offset			ds.l	1		* For 24 pin printers
back16				ds.l	1		* For 24 pin printers
*
_newbuff_ad			ds.l	1

*************************************************************************
*																		*
*			Text Font Buffer Equates									*
*																		*
*	These must be changed to the values for specific machines.			*
*	Ces valeures doivent etre modifies suivant le type de machine.		*
*																		*
*************************************************************************

left_offset		.equ	1
right_offset	.equ	5
max_cell_wd		.equ	9
cell_wd			.equ	(left_offset+right_offset+max_cell_wd+15)/8
cell_ht			.equ	24
cell_size		.equ	cell_ht*cell_wd

	.page
*************************************************************************
*																		*
*						Miscellaneous Variables							*
*																		*
*************************************************************************

_curalpha	dc.b	$ff		* current alpha text attributes
_reqalpha	dc.b	0		* requested alpha text attributes
_com_port	dc.b	0		* 0 for "PRN:" , $80 for "AUX:"
			dc.b	0		* ..filler..
_vmu		dc.w	0		* vertical motion unit counter

_A_PAGE		ds.w	1		* # of alpha text lines per full page
_A_SLICE	ds.w	1		* alpha text height in pixels
_G_PAGE		ds.w	1		* # of slices per page
_G_SLICE	ds.w	1		* slice height in pixels
_DIV_FACT	dc.w	1


	.page
*************************************************************************
*																		*
*								Device Table							*
*																		*
*************************************************************************

_DEV_TAB	dc.w	0		* 1		x resolution
			dc.w	0		* 2		y resolution
			dc.w	1		* 3		0=exact,1=not exact
			dc.w	0		* 4		width of pixel
			dc.w	0		* 5		height of pixel
			dc.w	0		* 6		character sizes
			dc.w	8		* 7		linestyles
			dc.w	75	* 8		linewidths
			dc.w	8		* 9		marker types
			dc.w	8		* 10	marker size
			dc.w	0		* 11	text font
			dc.w	24		* 12	area patterns
			dc.w	12		* 13	crosshatch patterns
			dc.w	16		* 14	colors at one time
			dc.w	10		* 15	number of GDP's
			dc.w	1		* 16	GDP bar
			dc.w	2		* 17	GDP arc
			dc.w	3		* 18	GDP pie
			dc.w	4		* 19	GDP circle
			dc.w	5		* 20	GDP ellipse
			dc.w	6		* 21	GDP elliptical arc
			dc.w	7		* 22	GDP elliptical pie
			dc.w	8 		* 23	GDP rounded rectangle
			dc.w	9 		* 24	GDP filled rounded rectangle
			dc.w	10		* 25	GDP justified text

* GDP attributes
		dc.w		3		* 26	GDP #1
		dc.w		0		* 27	GDP #2
		dc.w		3		* 28	GDP #3
		dc.w		3		* 29	GDP #4
		dc.w		3		* 30	GDP #5
		dc.w		0		* 31	GDP #6
		dc.w		3		* 32	GDP #7
		dc.w		0 		* 33	GDP #8
		dc.w		3 		* 34	GDP #9
		dc.w		2 		* 35	GDP #10
		dc.w		1		* 36	Color capability(0=valeur ecran)
		dc.w		1		* 37	Text Rotation
		dc.w		1		* 38	Polygonfill
		dc.w		0		* 39	Cell Array
		dc.w		16	* 40	Pallette size
		dc.w		0		* 41	# of locator devices
		dc.w		0		* 42	# of valuator devices
		dc.w		0		* 43	# of choice devices
		dc.w		0		* 44	# of string devices
		dc.w		0		* 45	Workstation Type 2 = out/in


*************************************************************************
*																		*
*								Size Table								*
*																		*
*	This table contains text, line, and marker sizes in device			*
*	coordinates.														*
*																		*
*************************************************************************

_SIZ_TAB	dc.w	0		* 1  min char width
			dc.w	0		* 2  min char height
			dc.w	0		* 3  max char width
			dc.w	0		* 4  max char height
			dc.w	1		* 5  min line width
			dc.w	0		* 6  -- not used
			dc.w	150		* 7  max line width
			dc.w	0		* 8  -- not used
			dc.w	21		* 9  min marker width
			dc.w	25		* 10 min marker height
			dc.w	168		* 11 max marker width
			dc.w	200		* 12 max marker height

	.page
*************************************************************************
*																		*
*							Extended Inquiry Table						*
*																		*
*************************************************************************

_INQ_TAB	dc.w	0				*  0  type of alpha/graphic controllers
			dc.w	1				*  1  number of background colors
			dc.w	31				*  2  text styles supported
			dc.w	0				*  3  scale rasters = false
			dc.w	3				*  4  number of planes(8 couleurs max)
			dc.w	0				*  5  video lookup table
			dc.w	50				*  6  performance factor
			dc.w	0				*  7  contour fill capability
			dc.w	1				*  8  character rotation capability
			dc.w	4				*  9  number of writing modes
			dc.w	0				*  10 highest input mode
			dc.w	1				*  11 text alignment flag
			dc.w	0				*  12 inking capability
			dc.w	0				*  13 rubber banding
			dc.w	PTSIN_SIZE/2-1	*  14 maximum vertices
			dc.w	INTIN_SIZE		*  15 maximum intin size
			dc.w	0				*  16 number of buttons on mouse
			dc.w	0				*  17 styles for wide lines
			dc.w	0				*  18 writing modes for wide lines
_CLIP		ds.w	1				*  19 clipping flag
			dc.w	0,0,0,0,0,0,0,0
			dc.w	0,0,0,0,0,0,0,0
			dc.w	0,0,0,0,0,0,0,0
			dc.w	0


*************************************************************************
*																		*
*					PTSOUT Array for Extended Inquiry					*
*																		*
*************************************************************************

_INQ_PTS	ds.w	0		*  INQ_PTS[0] = XMN_CLIP
_XMN_CLIP	ds.w	1		*  0  upper left x
_YMN_CLIP	ds.w	1		*  1  upper left y
_XMX_CLIP	ds.w	1		*  2  lower right x
_YMX_CLIP	ds.w	1		*  3  lower right y
			dc.w	0,0,0,0,0,0,0,0

	.page
*************************************************************************
*																		*
*							Marker Definitions							*
*																		*
*************************************************************************

_m_dot          dc.w    1               *  number of polylines
                dc.w    2               *  segments in polyline
                dc.w    0,0,0,0

_m_plus         dc.w    2               *  number of polylines
                dc.w    2               *  segments in polyline
                dc.w    0,-10,0,10
                dc.w    2               *  segments in polyline
                dc.w    -10,0,10,0

_m_star         dc.w    3               *  number of polylines
                dc.w    2               *  segments in polyline
                dc.w    0,-10,0,10
                dc.w    2               *  segments in polyline
                dc.w    8,8,-8,-8
                dc.w    2               *  segments in polyline
                dc.w    8,-8,-8,8

_m_square       dc.w    1               *  number of polylines
                dc.w    5               *  segments in polyline
                dc.w    -10,-10,10,-10,10,10,-10,10,-10,-10

_m_cross        dc.w    2               *  number of polylines
                dc.w    2               *  segments in polyline
                dc.w    -10,-10,10,10
                dc.w    2               *  segments in polyline
                dc.w    -10,10,10,-10

_m_dmnd         dc.w    1               *  number of polylines
                dc.w    5               *  segments in polyline
                dc.w    -10,0,0,-10,10,0,0,10,-10,0

	.page
	.bss
*************************************************************************
*																		*
*							Driver Structure							*
*																		*
*	These variables are necessary for CPX's and Accessories. 			*
*	Ces variables sont necessaire pour l'accessoire DRIVER.				*
*	Ces valeur sont celle par dfaut, qui pouront etre modifies		*
*	ensuite par l'accesoire DRIVER.										*
*																		*
*************************************************************************
	.data
DUMMY		dc.b	$5F,$46,$53,$4d,$5f,$48,$44,$52	* _FSM_HDR (En-tete)
*
_QUALITY	dc.w	1		* 1=final, 0=draft
CONFIG_MAP	dc.w	1087	* Mapping of bits. Ce champ de bit permet
* de valider ou non les modifications dans l'accessoire.
* Vous devez l'adapter suivant le type de machine.
* Description du champ de bit:
*				  bit 0 = quality				1 => 2^0	
*				  bit 1 = page size 0 below		1 => 2^1
*				  bit 2 = page size 1 below		1 => 2^2
*				  bit 3 = page size 2 below		1 => 2^3
*				  bit 4 = page size 3 below		1 => 2^4
*				  bit 5 = page size 4 below		1 => 2^5
*				  bit 6 = number of colors		1 => 2^6
*				  bit 7 = dots per inch			0
*				  bit 8 = port					0
*				  bit 9 = tractor				1 => 2^9
*				  bit 10 = tray1				0
*				  bit 11 = tray2				0
*				  bit 12 = manual				0
*				  bit 13 = 2nd page sz table	1 => 2^13
*
*		total = 1+2+4+8+16+32+64+512+8192 = 8831

* Entrez les valeurs par dfaut!

NPLANES		dc.w	4	* default number of planes

TOTPLANES	dc.w	4	* number of selectable color modes (1-4possible)

PLANE_VALS	dc.w	1	* plane 1 set if 2 colors supported
			dc.w	2	* plane 2 set if 4 colors supported
			dc.w	3	* plane 3 set if 8 colors supported
			dc.w	4	* plane 4 set if 16 colors supported

* Nombres de DPI par dfault:

XDPI		dc.w	300	* Nombre de DPI pour 1 plan
			dc.w	300	* Nombre de DPI pour 2 plan
			dc.w	300	* Nombre de DPI pour 3 plan
			dc.w	300	* Nombre de DPI pour 4 plan

YDPI		dc.w	300 * Idem
			dc.w	300
			dc.w	300
			dc.w	300

PAGESIZE	dc.w	2	* 0 = letter (Format par defaut)
* 						  1 = legal
*						  2 = a4
*						  3 = b5
*						  4 = Use XRES and YRES values

* Taille en point par defaut pour 
* le format lettre.(8.0 inches x 10.4 inches)

XRES		dc.w	2389	* Default horiz. res = 8.0"
YRES		dc.w	3321	* Default vert. res = 10.4"

PORT		dc.w	0		* 0 = parallel, 1 = serial etc..
PAPER_FEED	dc.w	1		* 0=tractor, 1=tray1, 2=tray2, 3=manual

* 26 bytes of driver name 
* 26 bytes -1 pour le nom du driver.
PRINTER_NAME	dc.b	'H','P',' ','D','J',' ','5','5'
				dc.b	'0','C',' ','C','Y','M','K',' '
				dc.b	'v',' ','1','.','5',' ',' '
				dc.b	' ',' '

*****************************************************************
*	- Page sizes reflect values that are divisible by 			*
*	  slice_width = 1 and rounded up (not down).				*
*	- Zero based so subtracted one from all values.				*
*	- All xres & yres values must be odd (since zero based).	*
*	- Default right & left margins = 1/4" (?)					*
*	Ici vous entrer les valeurs en point pour chaque taille de	*
*	page. Vous avez remarqu il non pas prvu le format A3 et 	*
*	A0 c'est super non?(quel con)								*
*****************************************************************
PGSZ_TAB
* letter: 8.0 x 10.4 in.
		dc.w	2399	* horizontal res:	300 dpi
		dc.w	3119	* vertical res:		300 dpi
* legal: 8.0 x 13.5 in.
		dc.w	2399	* horizontal res:	300 dpi
		dc.w	4049	* vertical res:		300 dpi
* A4: 7.8 x 11.2 in.
		dc.w	2389	* horizontal res:	300 dpi
		dc.w	3321	* vertical res:		300 dpi
* B5: 6.7 x 9.6 in.
		dc.w	2009	* horizontal res:	300 dpi
		dc.w	2879	* vertical res:		300 dpi

*****************************************************************
* Second set of dpi values supported - 150 DPI					*
* Second parti n'est pas uttilis pour la 550c					*
*****************************************************************
* letter: 8.0 x 10.5 in.
		dc.w	2399	* horizontal res:	150 dpi
		dc.w	3119	* vertical res:		150 dpi
* legal: 8.0 x 13.5 in.
		dc.w	2399	* horizontal res:	150 dpi
		dc.w	4049	* vertical res:		150 dpi
* A4: 7.8 x 11.2 in.
		dc.w	2389	* horizontal res:	150 dpi
		dc.w	3321	* vertical res:	150 dpi
* B5: 6.7 x 9.6 in.
		dc.w	2009	* horizontal res:	150 dpi
		dc.w	2879	* vertical res:		150 dpi

* Alors la mistre et boule de gomme. Ce sont les marges d'impressions.
* Comment les recuprent-on?
* Pourquoi rduisent-elles la taille en point du document?
* De plus ils proposent de les calculer au pif. Pas mal non?
* Donc pour moi c'est ZERO!...

_TOPMRGN	dc.w	0	* 1/4" * 300dpi ==> 0.25*300 = 75
_BOTMRGN	dc.w	0	* 1/4"
_LFTMRGN	dc.w	0	* 1/4"
_RHTMRGN	dc.w	0	* 1/4"

TOPMRGN2	dc.w	0	* 1/4" * 150dpi ==> 0.25*150 = 37.5
BOTMRGN2	dc.w	0	* 1/4"
LFTMRGN2	dc.w	0	* 1/4"
RHTMRGN2	dc.w	0	* 1/4"

	.page
*************************************************************************
*																		*
*	Data area used for the display list and rasterizing buffer			*
*																		*
*	Partitioning of the two sections of the buffer is done				*
*	dynamically.  The display list buffer is always located at			*
*	the beginning of the buffer.										*
*																		*
*************************************************************************
	.end
