{$A+,S35}
    PROGRAM mc_talk;

    {$i MC_TALK4.I}
  {$I d:\library\gemdef.pas}
const
  {$I d:\library\trixcons.pas}

    { ESC-Codes fr Anfragen an MIDI_COM }
      GET_VERW	 = 6009; { Lese Ring-Karte	 }

    { Interne Erkennungen von empfangenen bzw. fuer gesendete Nachrichten }
      talk    =5;
      anm_talk=6;
      end_talk=7;
      txt     =8;
      login   =9;
      s_mail  =10; { Anforderung, lese MAIL auf eigene Disk }
      r_mail  =11; { Mail wird gelesen !!! }
      no_mail =12; { Mail wird nicht angenommen }
      get_pic =13; { Bildschirm angefordert }
      s_pic   =14; { (Teil-) Bild als Antwort }
      no_pic  =15; { Bild kann nicht bertragen werden }
    TYPE
  {$I d:\library\trixtype.pas}

str9=string[9];

verw  = record my_name :str9;	 { Appl. Name  } 
               r_name  :str9;
	       status  :integer; { Status-Bits }
	       disk_st :integer;
	end;
	
cstr9=packed array[0..9] of char;
verw_c = record my_name :cstr9;	 { Appl. Name  } 
               r_name  :cstr9;
	       status  :integer; { Status-Bits }
	       disk_st :integer;
	end;

Karte=array[0..6] of verw;
c_karte=array[0..6] of verw_c;

     talk_adress=RECORD num,what: integer;
			rufer	: string;
		 END;

     bild_typ=packed record
	       len    :integer;
	       von,bis:integer; { relativer Bereich }
	       pic    :packed array[1..1900] of integer;
	      end;

     user_def=RECORD
		CASE what:integer OF
		     talk:(quest:talk_adress);
		    s_pic:(xpic :bild_typ);
	      END;

     mailing=record got_quest:boolean;
		    pfad:string;
	     end;

     anytyp  =RECORD
		CASE byte OF
		 1:(ver:c_karte);
		 2:(use:user_def)
	      END;

     openline=RECORD onlin :boolean;
		     aktiv :boolean;
		     called:boolean;
		     who   :string;
	      END;

	  connect=ARRAY [1..6] OF openline;
	  recieve=ARRAY [1..9] OF string;

	  flagtype=record dirok,verwok,mailwork,
			  neutxt,neudia,glocke,ok_pic,err_pic,
			  waitpic,okkiebitz:boolean;
		   end;

      dta_typ=packed record
              reserved: packed array [0..17] of byte;
              res0    : integer;
              res1    : byte;
              attribut: byte;
              zeit    : integer;
              datum   : integer;
              laenge  : long_integer;
              name    : packed array [1..14] of char;
             end;

      dta_ptr=^dta_typ;       


    VAR   ring_ptr :pointer; { Pointer fuer Ring-Kommunikation (immer global)}
	  apl_nr,
	  men_id,
	  main_wind:integer;
	  men_name :str255;
	  wname:window_title;

	  flags    :flagtype;
	  ring_def :karte;   { Ringstatus Datentyp			     }

	  name	   :string;  { Name der Applikation (fuer den Ring)	     }
	  lognam   :string;  { Name des Users, Nur fuer diese Applikation    }

	  teldesk  :dialog_ptr; { Die Bedienungsobeflche im Telefonmodus    }
	  maindesk :dialog_ptr; { Die Bedienungsobeflche im Normalmodus     }
	  readpic  :dialog_ptr;

	  modus    :integer; {0=closed,1=Normalmodus,2=Telefonmodus }
	  lw	   :char;    {Netzlaufwerk}
	  talking  :connect; { Verwaltung der direkten Kommunikation	     }
	  rzeil,szeil:recieve;{}

	  mailbox :array[1..6] of mailing;
	  mailsend:array[1..6] of integer;
	  mailpfad:string; { zielpfad fr ankommende Mail }

	  alrt	   :str255;
	  alerg    :integer;

	  screen   :packed Array[0..15999] of integer; { ST Screen as Ints. }
	  paclen   :integer;

  {$I d:\library\trixsubs.pas}
  {$I library\RING_SUB.I}	  { Externals fuer MIDI_COM	      }

  function GETSTAD(buffer:long_integer):integer;external;
  function STADPAC(quell,ziel:long_integer):integer;external;
  function gettree(var anz:integer):tree_ptr;external;
  FUNCTION GETGLOB(ADR:TREE_PTR):LONG_INTEGER;EXTERNAL;
  FUNCTION appl_write_msg(VAR Puffer:message_buffer;id,Anzahl: SHORT_INTEGER): SHORT_INTEGER;
  EXTERNAL;
  FUNCTION set_bit(bci,num:integer):integer;external;

Procedure Bconout (dev,c:integer);
Bios(3);

Function Physbase : Long_Integer;
XBios(2);

Function Fcreate (Var name : cstring;
		  attr : Integer) : Integer;
Gemdos($3C);

function fopen(var name:cstring;mode:integer):integer;
gemdos($3D);

procedure fclose(handle:integer);
gemdos($3E);

function FREAD(handle:integer;COUNT:LONG_INTEGER;var BUFFER:integer):LONG_integer;
gemdos($3F);

function FWRITE(HANDLE:INTEGER;COUNT:LONG_INTEGER;VAR BUFFER:integer):LONG_INTEGER;
gemdos($40);

function dgetdrv:integer;
gemdos($19);

function dgetpath(var path:cstring;drive:integer):integer;
gemdos($47);

Function Malloc (nbytes : Long_Integer) : Long_Integer;
Gemdos($48);

Procedure Mfree (maddr : Long_Integer);
Gemdos($49);

procedure fixdia(dia:tree_ptr);
var i:integer;

procedure fixchilds(parent,ind1:integer);
var hlp:integer;
begin
 hlp:=ind1;
 repeat
  Obj_Fix(dia,hlp);
  if dia^[hlp].ob_head>=0 then
   fixchilds(hlp,dia^[hlp].ob_head);
  hlp:=dia^[hlp].ob_next;
 until hlp=parent;
end;

begin
 i:=0;
 repeat
  Obj_Fix(dia,i);
  if dia^[i].ob_head>=0 then
   fixchilds(i,dia^[i].ob_head);
  i:=dia^[i].ob_next;
 until i=-1;
end;

procedure init_rsc;
var dia:tree_ptr;
    i,anz:integer;
    ERG:LONG_INTEGER;

begin
 dia:=gettree(anz);
 ERG:=GETGLOB(DIA);
 for i:=0 to anz-1 do
 begin
  FIND_DIALOG(i,DIA);
  fixdia(dia);
 end;
end;

  procedure boot_drive(var path:string);
  var il:long_integer;
      i:integer;
      hlp:string;
      lw:char;

  begin
   super(true);
   il:=Wpeek($000446);
   super(false);
   i:=int(il);
   lw:=chr(ord('A')+i);
   hlp:=concat(lw,':',path);
   path:=hlp;
  end;

  FUNCTION r_mouse:boolean;
  { mouse_pos=true <=> linke maustaste wird gedrueckt }
  VAR intin :int_in_parms;
  intout:int_out_parms;
  adrin :addr_in_parms;
  adrout:addr_out_parms;

  BEGIN
   aes_call(79,intin,intout,adrin,adrout);
   r_mouse:=(intout[3]=2);
  END;

procedure on_glocke;
begin
 bconout(2,27);
 bconout(2,106);
 bconout(2,27);
 bconout(2,89);
 bconout(2,32);
 bconout(2,105);
 bconout(5,10);
 bconout(5,10);
 bconout(2,27);
 bconout(2,107);
 bconout(2,7);
end;

procedure off_glocke;
begin
 bconout(2,27);
 bconout(2,106);
 bconout(2,27);
 bconout(2,89);
 bconout(2,32);
 bconout(2,105);
 bconout(2,32);
 bconout(2,32);
 bconout(2,27);
 bconout(2,107);
end;

   FUNCTION umrech(num:integer):integer;

   { Da jeder Ringteilnehmer sich selbst als Nr. 0 ansieht, muss der
     Empfnger einer Nachricht erst feststellen, welche Nummer der
     Absender aus der eigenen Sicht hat, um ihm zu antworten.
     Beispiel:
      Es seien 4 Rechner angeschlossen. ( Rechner 0..3 )
      Das Programm sendet an Rechner Nr. 1 also eine Station weiter.

      Rechner Nr. 1 ist aus eigener Sicht wieder Nr.0 und mu, um dem
      richtigen Rechner zu antworten an seinen direkten Vorgnger senden.
      In diesem Fall an den Rechner mit der Nr. 3. => Umrech(1)=3;

      ACHTUNG: Bevor UMRECH korrekt arbeiten kann, mu die Variable
	       >ring_def< belegt worden sein !!!			}

   VAR i:integer;

   BEGIN
    i:=6;
    WHILE ((ring_def[i].status & 7)<>7) DO i:=i-1;
    num:=num-1;
    WHILE num<>0 DO
    BEGIN
     i:=i-1;
     num:=num-1;
    END;
    umrech:=i;
   END;

procedure do_redraw(handle,x0,y0,w0,h0:integer);
var x1,y1,w1,h1:integer;

begin
 begin_update;
 hide_mouse;
 first_rect(handle,x1,y1,w1,h1);
 while (w1<>0) and (h1<>0) do
 begin
  if rect_intersect(x0,y0,w0,h0,x1,y1,w1,h1) then
  begin
   obj_draw(maindesk,0,3,x1,y1,w1,h1);
  end;
  next_rect(handle,x1,y1,w1,h1);
 end;
 show_mouse;
 end_update;
end;

  procedure trans_picture(ziel:integer;var info:anytyp);
  var bufadr:long_integer;
      screnadr,e0:long_integer;
      erg:integer;
      i,j,e:integer;
      dummy:string;
      et:boolean;

  begin
   if not flags.waitpic and flags.okkiebitz then
   begin
    BUFADR:=Adr_integer(screen[0]);
    screnadr:=physbase;
    e:=stadpac(screnadr,bufadr);
    dummy:='';
    if e>0 then
    begin
     erg:=e;
     i:=0;j:=1;
     repeat
      info.use.what:=s_pic;
      info.use.xpic.len:=erg;
      info.use.xpic.von:=i;
      while (j<=1900) and (i<=((erg+1) div 2)) do
      begin
       info.use.xpic.pic[j]:=screen[i];
       i:=i+1;j:=j+1;
      end;
      info.use.xpic.bis:=i-1;
      et:=transmit(ring_ptr,sizeof(anytyp),ziel,dummy,info);
      j:=1;
     until (2*i)>erg;
    end
    else
    begin
     info.use.what:=no_pic;
     et:=transmit(ring_ptr,20,ziel,dummy,info);
    end;
   end
   else
   begin
    info.use.what:=no_pic;
    et:=transmit(ring_ptr,20,ziel,dummy,info);
   end;
  end;

procedure my_ctopstr(var quell:cstr9;var ziel:str9);
var i:integer;
begin
 i:=0;
 while (ord(quell[i])<>0) do
 begin
  ziel[i+1]:=quell[i];
  i:=i+1;
 end;
 ziel[0]:=chr(i);
end;

procedure req_pkarte(var r_def:karte;var ver:c_karte);
var i:integer;
begin
  for i:=0 to 6 do
  begin
   r_def[i].status := ver[i].status;
   r_def[i].disk_st:= ver[i].disk_st;
   my_ctopstr(ver[i].r_name,r_def[i].r_name);
   my_ctopstr(ver[i].my_name,r_def[i].my_name);
  end;
end;

    procedure msg_reader(var flags:flagtype);
    { Interpreter fuer eingehende Nachrichten }

    VAR esc,len,i,j:integer;
	info:anytyp;
	erg:boolean;
	dummy:string;

    BEGIN
     wait(1);
     { Solange Nachrichten im Puffer sind werden diese gelesen
       und bearbeitet }
     WHILE lese(ring_ptr,info,esc,len) DO
     BEGIN
      IF esc<>0 THEN { Ringverwaltung wurde Uebertragen }
      BEGIN
       req_pkarte(ring_def,info.ver);
       flags.verwok:=true;
       flags.neudia:=true;
      END
      ELSE
      BEGIN
       IF info.use.what=talk THEN { Jemand moechte Telefonieren }
       BEGIN
	CASE info.use.quest.what OF
	 anm_talk:BEGIN { Ich werde angerufen }
		   esc:=umrech(info.use.quest.num);
		   talking[esc].who:=info.use.quest.rufer;
		   talking[esc].onlin:=true;
		   flags.neudia:=true;
		   write(chr(7)); { einmal klingeln lassen }
		   if (not talking[esc].called) and
		      (modus=2) then
		   begin
		    talking[esc].called:=true;
		    info.use.what:=talk;
		    info.use.quest.num:=esc;
		    info.use.quest.rufer:=lognam;
		    info.use.quest.what:=anm_talk;
		    dummy:='';
		    {*** bermittle den Anruf an Rechner (esc) }
		    erg:=transmit(ring_ptr,30,esc,dummy,info);
		   end;
		  END;
	 get_pic :BEGIN { Ich werde angerufen }
	   esc:=umrech(info.use.quest.num);
		   trans_picture(esc,info);
		  END;
	 end_talk:BEGIN { Der Anrufer hat es Aufgegeben und hat aufgelegt }
		   esc:=umrech(info.use.quest.num);
		   talking[esc].called:=false;
		   if talking[esc].onlin then talking[esc].aktiv:=false;
		   talking[esc].onlin:=false;
		   flags.neudia:=true;
		  END;
	 txt	 :begin
		   FOR i:=1 TO 8 DO rzeil[i]:=rzeil[i+1];
		   esc:=umrech(info.use.quest.num);
		   writev(rzeil[9],talking[esc].who:8,'> ',
			  info.use.quest.rufer);
		   flags.neutxt:=true;
		  end;
	 login	 :begin
		   esc:=umrech(info.use.quest.num);
		   if talking[esc].who='' then
		   begin
		    talking[esc].who:=info.use.quest.rufer;
		    info.use.quest.rufer:=lognam;
		    info.use.quest.num:=esc;
		    dummy:='';
		    erg:=transmit(ring_ptr,40,esc,dummy,info);
		   end else
		    talking[esc].who:=info.use.quest.rufer;
		   if mc_neustat(ring_ptr) then
		   begin
		    get_karte(ring_ptr);
		    flags.verwok:=false;
		   end;
		  end;
	 r_mail  :begin
		   esc:=umrech(info.use.quest.num);
		   mailsend[esc]:=r_mail;
		  end;
	 no_mail :begin
		   esc:=umrech(info.use.quest.num);
		   mailsend[esc]:=no_mail;
		  end;
	 s_mail  :begin
		   esc:=umrech(info.use.quest.num);
		   mailbox[esc].got_quest:=true;
		   mailbox[esc].pfad:=info.use.quest.rufer;
		   flags.mailwork:=true;
		  end;
	END;{case}
       END
       else
       begin
	IF info.use.what=s_pic THEN
	BEGIN
	 j:=1;
	 for i:=info.use.xpic.von to info.use.xpic.bis do
	 begin
	  screen[i]:=info.use.xpic.pic[j];
	  j:=j+1;
	 end;
	 writev(dummy,info.use.xpic.len-1:5);
	 set_dtext(readpic,picleng,dummy,system_font,te_left);
	 writev(dummy,(2*info.use.xpic.bis):5);
	 set_dtext(readpic,picget,dummy,system_font,te_left);
	 show_dialog(readpic);
	 flags.err_pic:=false;
	 flags.ok_pic:=2*info.use.xpic.bis>=info.use.xpic.len-1;
	 if flags.ok_pic then
	 begin
	  paclen:=info.use.xpic.len div 2;
	  for i:=paclen to 15999 do screen[i]:=0;
	 end;
	end;
	IF info.use.what=no_pic THEN
	BEGIN
	 flags.err_pic:=true;
	end;
   end;
  END;
 END;
END;

    FUNCTION show_karte:integer;
    { Anzeigen der Ringverwaltung }

    VAR i,j,erg:integer;
	dia:dialog_ptr;

    BEGIN
     find_dialog(listuser,dia);
     center_dialog(dia);

{*** Anfordern der Ringverwaltung }
     get_karte(ring_ptr);
     flags.verwok:=false;
     while not flags.verwok do msg_reader(flags);

     { Setze Dialog fuer alle Online-Rechner auf normal }
     FOR i:=ring1 TO ring6 DO
     BEGIN
      j:=i-ring1+1;
      IF (ring_def[j].status & 7)=7
       THEN obj_setstate(dia,i,normal,false)
       ELSE obj_setstate(dia,i,disabled,false);
     END;

     { Setze im Dialog die Namen der angemeldeten Applikationen }
     FOR i:=apl1 TO apl6 DO
     BEGIN
      j:=i-apl1+1;
      IF (ring_def[j].status & 263)=263 THEN
       set_dtext(dia,i,ring_def[j].my_name,system_font,te_left)
      ELSE
       set_dtext(dia,i,'Desktop',system_font,te_left);
     END;

     { Setze im Dialog, an welchen Rechnern ein Drucker angeschlossen ist}
     FOR i:=druck1 TO druck6 DO
     BEGIN
      j:=i-druck1+1;
      IF (ring_def[j].status & 135)=135 THEN
       set_dtext(dia,i,'JA  ',system_font,te_left)
      ELSE
       set_dtext(dia,i,'NEIN',system_font,te_left);
     END;

     { login namen einsetzen }
     FOR i:=log1 TO log6 DO
     BEGIN
      j:=i-log1+1;
      IF talking[j].who<>'' then set_dtext(dia,i,talking[j].who,system_font,te_left)
			    ELSE set_dtext(dia,i,'no Login',system_font,te_left);
     END;
     begin_update;
     erg:=do_dialog(dia,0);
     obj_setstate(dia,erg,normal,false);
     erg:=erg-ring1+1;
     end_dialog(dia);
     end_update;
     IF (erg<1) OR (erg>6) THEN erg:=0;
     show_karte:=erg;
     { Rueckmeldung, welcher Rechner angewaehlt wurde }
    END;


    PROCEDURE show_txt(win,half:integer);
    { Anzeige der empfangenen Texte in der oberen Hlfte des Bildschirms }

    VAR x,y,w,h     :integer;
	px,py,pw,ph :integer;
	i,j	    :integer;

    BEGIN
     work_rect(win,x,y,w,h);
     {$P-}
     y:=y+teldesk^[0].ob_h;
     {$P=}
     begin_update;
     hide_mouse;
     paint_rect(x,y+1,w,half-y-1);
     py:=half-3;
     FOR i:=9 DOWNTO 1 DO
     BEGIN
      draw_string(x+1,py,rzeil[i]);
      py:=py-16;
     END;
     show_mouse;
     end_update;
    END;

    function min_leng(var szeil:string):integer;
    { schlieende Leerzeichen entfernen }
    var i:integer;

    begin
     i:=length(szeil);
     while (i>1) and (szeil[i]=' ') do i:=i-1;
     szeil[0]:=chr(i); {Laenge neu besetzen }
     min_leng:=i;
    end;

    PROCEDURE send_line;
    { sende eine Textzeile an alle ausgewhlten Rechner }

    VAR com:anytyp;
	i,len:integer;
	dummy:string;
	erg:boolean;

    BEGIN
     gotoxy(1,22);
     dummy:='';
     { Da nicht alle Programme mit dem Namen "MC_TALK" die
       Nachricht empfangen sollen, muss ich diese einzeln
       an alle Rechner versenden }
     len:=min_leng(szeil[9]);
     FOR i:=1 TO 6 DO
     BEGIN
      IF (talking[i].aktiv) THEN
      BEGIN
       com.use.what:=talk;
       com.use.quest.num:=i;
       com.use.quest.rufer:=szeil[9];
       com.use.quest.what:=txt;
{*** Verschicke die Textzeile an Rechner >i< }
       erg:=transmit(ring_ptr,len+8,i,dummy,com);
      END;
     END;
    END;

    PROCEDURE key_interpret(tast:integer;win,half:integer;VAR curx:integer);
    { Da gleichzeitiges senden und empfangen mglich sein soll, kann hier
      nicht die Pascalfunktion "READLN" verwendet werden, denn es muss auch
      whrend des tippens moeglich sein, weitere Nachrichten zu empfangen }

    VAR ch:char;
	i,j:integer;
	x,y,w,h,py:integer;

    BEGIN
     begin_update;
     hide_mouse;
     work_rect(win,x,y,w,h);
     py:=y+h-3;
     IF (tast=7181) OR (curx>67) THEN { RETURN falls RETURN-Taste oder
					       Zeilenende }
     BEGIN
      szeil[9,curx+1]:=' ';
      send_line;
      { Alle Zeilen um eins Hochkopieren }
      FOR i:=1 TO 8 DO szeil[i]:=szeil[i+1];

      { 9. Zeile neu initialisieren }
      szeil[9]:='_	   ';
      WHILE length(szeil[9])<70 DO szeil[9]:=concat(szeil[9],'		');

      { Untere Haelfte ganz neu zeichnen }
      curx:=0;
      paint_style(0);
      paint_rect(x,half+1,w,h+y-half);
      py:=y+h-19;
      FOR i:=8 DOWNTO 1 DO
      BEGIN
       draw_string(x+1,py,szeil[i]);
       py:=py-16;
      END;
     END
     ELSE
     IF (tast=3592) OR (tast=21375) THEN { Backspace oder Delete }
     BEGIN
      IF curx>0 THEN
      BEGIN
       szeil[9,curx]:='_';
       szeil[9,curx+1]:=' ';
       curx:=curx-1;
      END;
     END
     ELSE
     IF tast=283 THEN { Esc }
     BEGIN
      szeil[9]:='_	   ';
      WHILE length(szeil[9])<70 DO szeil[9]:=concat(szeil[9],'		');
      curx:=0;
     END
     ELSE
     BEGIN { Druckbare Zeichen }
      ch:=chr(tast & $00FF);
      IF ch IN [' '..'}','','','','','','',''] THEN
      BEGIN
       curx:=curx+1;
       szeil[9,curx]:=ch;
       szeil[9,curx+1]:='_';
      END;
     END;
     draw_string(x+1,y+h-3,szeil[9]);
     show_mouse;
     end_update;
    END;

procedure show_tel(win:integer;var half:integer);
var  i,x,y,w,h,py:integer;
     dia:dialog_ptr;

begin
 begin_update;
 hide_mouse;
 work_rect(win,x,y,w,h);
 find_dialog(teflon,dia); { Telefon-Anzeige finden }
 {$P-}
 y:=y+dia^[rahmtele].ob_h;
 h:=h-dia^[rahmtele].ob_h;
 {$P=}
 paint_style(0);
 paint_rect(x,y,w,h);
 half:=y+(h DIV 2);   { Fenster in zwei haelften unterteilen }
 pline(x,half,x+w,half);
 show_txt(win,half);

 { Untere Haelfte anzeigen }
 py:=y+h-3;
 FOR i:=9 DOWNTO 1 DO
 BEGIN
  draw_string(x+1,py,szeil[i]);
  py:=py-16;
 END;
 show_mouse;
 end_update;
end;

PROCEDURE start_talk(var win,curx:integer);
VAR com:anytyp;
    dummy:string;
    wnam:string;
    erg:boolean;
    i,x,y,w,h,py:integer;
    dia:dialog_ptr;

BEGIN
 G_SET_PORT(open_port(1));
 get_karte(ring_ptr);
 flags.verwok:=false;
 while not flags.verwok do msg_reader(flags);
 FOR i:=1 TO 6 DO { pruefen, ob ich angerufen wurde }
 BEGIN
  IF talking[i].onlin THEN
  BEGIN
   talking[i].called:=true;
   com.use.what:=talk;
   com.use.quest.num:=i;
   com.use.quest.rufer:=lognam;
   com.use.quest.what:=anm_talk;
   dummy:='';
{** Ja ich bin nun sprechbereit an alle Anrufer senden }
   erg:=transmit(ring_ptr,40,i,dummy,com);
  END
  else talking[i].called:=false;
 END;
 draw_mode(1);
 text_color(1);

 { Bildschirm initialisieren }
 work_rect(0,x,y,w,h);
 set_wsize(win,x,y,w,h);  { Fenster =ganzer Bildschirm }
 set_clip(x,y,w,h);
 work_rect(win,x,y,w,h);
 find_dialog(teflon,dia); { Telefon-Anzeige finden }
 {$P-}
 dia^[rahmtele].ob_y:=y;
 {$P=}

 { 9. Zeile neu initialisieren }
 curx:=0;
 szeil[9]:='_	      ';
 WHILE length(szeil[9])<70 DO szeil[9]:=concat(szeil[9],'	   ');
end;

procedure tel_redraw(handle,x0,y0,w0,h0:integer; var half:integer);
var x1,y1,w1,h1:integer;

begin
 begin_update;
 hide_mouse;
 paint_color(white);
 first_rect(handle,x1,y1,w1,h1);
 while (w1<>0) and (h1<>0) do
 begin
  if rect_intersect(x0,y0,w0,h0,x1,y1,w1,h1) then
  begin
   set_clip(x1,y1,w1,h1);
   paint_rect(x1,y1,w1,h1);
   show_tel(handle,half);
   obj_draw(teldesk,0,3,x1,y1,w1,h1);
  end;
  next_rect(handle,x1,y1,w1,h1);
 end;
 show_mouse;
 end_update;
 work_rect(handle,x1,y1,w1,h1);
 set_clip(x1,y1,w1,h1);
end;


procedure pass_wind(dia:dialog_ptr;win:integer);
var x,y,w,h:integer;
    difh,h1:integer;
begin
 border_rect(win,x,y,w,h1);
 work_rect(win,x,y,w,h);
 difh:=h1-h;
 {$P-}
 w:=dia^[0].ob_w;
 h:=dia^[0].ob_h+difh-1;
 x:=dia^[0].ob_x;
 y:=dia^[0].ob_y-difh+1;
 {$P=}
 set_wsize(win,x,y,w,h);
 work_rect(win,x,y,w,h);
end;


procedure do_end_talk(var flags:flagtype;win:integer);
VAR com:anytyp;
    dummy:string;
    erg:boolean;
    i:integer;

{ Beenden der Kommunikation }
begin
 begin_update;
 hide_mouse;
 Close_Port(Get_port);
 pass_wind(maindesk,win);
 show_mouse;
 end_update;
 FOR i:=1 TO 6 DO
 BEGIN
 { Mitteilung an alle, fuer die es Interessant ist: Ich lege auf }
  IF (talking[i].called)
     or (talking[i].onlin)
     or (talking[i].aktiv) THEN
  BEGIN
   com.use.what:=talk;
   com.use.quest.num:=i;
   com.use.quest.rufer:=lognam;
   com.use.quest.what:=end_talk;
   dummy:='';
{*** Abmeldung uebertragen }
   erg:=transmit(ring_ptr,30,i,dummy,com);
  END;
  talking[i].onlin:=false;
  talking[i].aktiv:=false;
  talking[i].called:=false;
 END;
 flags.neudia:=true;
END;



{ ****** Setzen von Datum und Uhrzeit des Systems *************** }
procedure set_time;
var dia:dialog_ptr;
    t,m,j,st,mi,s,i:integer;
    hlp,h1:string;
    dhlp:str255;

begin
 find_dialog(indat,dia);
 center_dialog(dia);
 GetDate(t,m,j);
 GetTime(st,mi,s);
 writev(hlp,t);
 if length(hlp)=1 then h1:=concat('0',hlp)
		  else h1:=hlp;
 set_dedit(dia,tag,'__','99',h1,system_font,te_left);
 writev(hlp,m);
 if length(hlp)=1 then h1:=concat('0',hlp)
		  else h1:=hlp;
 set_dedit(dia,monat,'__','99',h1,system_font,te_left);
 writev(h1,j);
 set_dedit(dia,jahr,'____','9999',h1,system_font,te_left);
 writev(hlp,st);
 if length(hlp)=1 then h1:=concat('0',hlp)
		  else h1:=hlp;
 set_dedit(dia,std,'__','99',h1,system_font,te_left);
 writev(hlp,mi);
 if length(hlp)=1 then h1:=concat('0',hlp)
		  else h1:=hlp;
 set_dedit(dia,minut,'__','99',h1,system_font,te_left);
 i:=do_dialog(dia,tag);
 obj_setstate(dia,i,normal,false);
 end_dialog(dia);
 if i<>dcan then
 begin
  get_dedit(dia,std,dhlp);
  readv(dhlp,st);
  get_dedit(dia,minut,dhlp);
  readv(dhlp,mi);
  s:=0;
  SetTime(st,mi,s);
  get_dedit(dia,tag,dhlp);
  readv(dhlp,t);
  get_dedit(dia,monat,dhlp);
  readv(dhlp,m);
  get_dedit(dia,jahr,dhlp);
  readv(dhlp,j);
  SetDate(t,m,j);
  if i=sall then systemzeit(ring_ptr);
 end;
end;

    procedure do_login(var logn:string);
    var dia:dialog_ptr;
	log:str255;
	info:anytyp;
	i:integer;
	erg:boolean;
	dummy:string;

    begin
     if mc_neustat(ring_ptr) then
     begin
      get_karte(ring_ptr);
      flags.verwok:=false;
      while not flags.verwok do msg_reader(flags);
     end;
     { Username eingeben }
     find_dialog(dologin,dia);
     set_dedit(dia,logname,'________','XXXXXXXX',lognam,system_font,te_left);
     center_dialog(dia);
     begin_update;
     i:=do_dialog(dia,logname);
     obj_setstate(dia,i,normal,false);
     get_dedit(dia,logname,log);
     end_dialog(dia);
     logn:=log;
     end_update;
     info.use.quest.what:=login;
     info.use.quest.rufer:=logn;
     info.use.what:=talk;
     dummy:='';
     for i:=1 to 6 do
     begin
      if ring_def[i].my_name=name then
      begin
       info.use.quest.num:=i;
       erg:=transmit(ring_ptr,80,i,dummy,info);
      end;
     end;
     wait(100);
    end;

procedure set_md;
var i:integer;
    called:boolean;

begin
 called:=false;
 for i:=1 to 6 do called:=called or talking[i].onlin;
 if called then
 begin
  obj_setstate(maindesk,phone,selected,false);
 end
 else
  obj_setstate(maindesk,phone,normal,false);
end;

procedure set_td;
{ Bei der Kommunikation wird angezeigt, welche Teilnehmer gerade
  mithoeren beziehungsweise Empfangsbereit sind }
VAR i:integer;
    nam:string;

BEGIN
 FOR i:=1 TO 6 DO
 BEGIN
  IF  ((ring_def[i].status & 263)=263)
   AND (ring_def[i].my_name=name) THEN { Alle Rechner auf denen dieses
					 Programm laeuft knnen erreicht
					 werden }
  BEGIN
   { wenn der Empfnger meine Nachrichten empfangen soll ist er aktiv }
   IF talking[i].aktiv THEN obj_setstate(teldesk,i,selected,false)
		       ELSE obj_setstate(teldesk,i,normal,false);

   { Namen der Empfnger anzeigen }
   if talking[i].who<>'' then
    set_dtext(teldesk,i+txt1-1,talking[i].who,small_font,te_center)
   else
    set_dtext(teldesk,i+txt1-1,'==Online==',small_font,te_center);

   { wenn der Empfnger den Hoerer abgenommen hat ist er online }
   IF talking[i].onlin THEN
    obj_setstate(teldesk,i+txt1-1,selected,false)
   ELSE
    obj_setstate(teldesk,i+txt1-1,normal,false);
  END
  ELSE
  BEGIN
   obj_setstate(teldesk,i,disabled,false);
   obj_setstate(teldesk,i+txt1-1,disabled,false);
  END;
 END;
END;

procedure set_glocke(var flags:flagtype);
var i:integer;
    called:boolean;

begin
 called:=false;
 for i:=1 to 6 do called:=called or talking[i].onlin;
 if called then
 begin
  on_glocke;
  flags.glocke:=true;
 end;
end;

procedure mail_answer(i,what:integer);
var erg:boolean;
    info:anytyp;
    dummy:string;

begin
 dummy:='';
 info.use.what:=talk;
 info.use.quest.num:=i;
 info.use.quest.what:=what;
 mailbox[i].got_quest:=false;
 erg:=transmit(ring_ptr,16,i,dummy,info);
end;

Function Dcreate (Var path : cstring) : Long_Integer;
Gemdos($39);

Function Fsfirst (Var pspec : cstring;
                  attr : Integer) : Long_Integer;
Gemdos($4E);

Function Fgetdta : dta_ptr;
Gemdos($2F);

function suchpfad(i:integer;var pfad,quelle:string):boolean;
var test:file of char;
    num,j:integer;
    erg:long_integer;
    filname,hlp:string;
    neupfad:cstring;
    dta:dta_typ;
    dta_adr:dta_ptr;

begin
 j:=length(quelle);
 while quelle[j]<>'\' do j:=j-1;
 filname:=copy(quelle,j+1,length(quelle)-j);

 writev(pfad,mailpfad,talking[i].who);
 ptocstr(pfad,neupfad);
 dta_adr:=Fgetdta;
 dta:=dta_adr^;
 erg:=fsfirst(neupfad,16);
 if (erg<0) or ((dta_adr^.attribut & 16)=0) then erg:=Dcreate(neupfad);
 dta_adr^:=dta;

 if erg>=0 then
 begin
  writev(hlp,pfad,'\',filname);
  reset(test,hlp);
  if io_result=0 then
  begin
   j:=length(filname);
   while (filname[j]<>'.') and (j>0) do j:=j-1;
   if j>0 then filname[j]:='_';
   if length(filname)>8 then filname[0]:=chr(8);
   num:=0;
   repeat
    num:=num+1;
    writev(hlp,pfad,'\',filname,'.',num);
    reset(test,hlp);
   until io_result<>0;
  end;
  pfad:=hlp;
  rewrite(test,pfad);
  suchpfad:=(io_result=0);
  close(test);
 end else suchpfad:=false
end;

procedure copy_file(i:integer;var ziel,quell:string);
var hquell,hziel:integer;
    count,erg,h:long_integer;
    hlp:string;
    buff:array[1..1024] of integer; {2K Puffer}
    cziel,cquell:cstring;

begin
 writev(hlp,lw,':\R',I,'\',QUELL);
 ptocstr(hlp,cquell);
 hquell:=fopen(cquell,0);
 ptocstr(ziel,cziel);
 hziel:=fopen(cziel,1);
 count:=2048;
 erg:=0;
 if (hquell>0) and (hziel>0) then
 begin
  repeat
   erg:=fread(hquell,count,buff[1]);
   if erg>0 then h:=fwrite(hziel,erg,buff[1]);
  until (erg<count) or (h<erg);
 end;
 if (hquell>0) then fclose(hquell);
 if (hziel>0) then fclose(hziel);
end;

procedure get_mail(var flags:flagtype);
var test:file of char;
    pfad:string;
    i	:integer;
    erg :boolean;

begin
 flags.mailwork:=false;
 for i:=1 to 6 do
 begin
  if mailbox[i].got_quest then
  begin
   mailbox[i].got_quest:=false;
   if mailpfad='' then mail_answer(i,no_mail)
   else
   if not suchpfad(i,pfad,mailbox[i].pfad) then mail_answer(i,no_mail)
   else
   begin
    copy_file(i,pfad,mailbox[i].pfad);
    msg_reader(flags);
    mail_answer(i,r_mail);
   end;
  end;
 end;
end;

function not_locked(var pf:string):boolean;
var i,j:integer;
    loc_tst:cstring;
(* erstellt 17.2.92 *)

begin
 i:=1;
 while i<=length(pf) do
 begin
  loc_tst[i-1]:=pf[i];
  if loc_tst[i-1]='\' then j:=i;
  i:=i+1;
 end;
 loc_tst[j]:='M';
 loc_tst[j+1]:='I';
 loc_tst[j+2]:='D';
 loc_tst[j+3]:='I';
 loc_tst[j+4]:='_';
 loc_tst[j+5]:='C';
 loc_tst[j+6]:='O';
 loc_tst[j+7]:='M';
 loc_tst[j+8]:='.';
 loc_tst[j+9]:='L';
 loc_tst[j+10]:='O';
 loc_tst[j+11]:='C';
 loc_tst[j+12]:=CHR(0);
 i:=fopen(LOC_TST,1);
 if i>0 then fclose(i)
 ELSE
 BEGIN
  loc_tst[3]:='M';
  loc_tst[4]:='_';
  loc_tst[5]:='C';
  loc_tst[6]:='_';
  loc_tst[7]:='L';
  loc_tst[8]:='O';
  loc_tst[9]:='C';
  loc_tst[10]:='K';
  loc_tst[11]:='.';
  loc_tst[12]:='P';
  loc_tst[13]:='A';
  loc_tst[14]:='R';
  loc_tst[15]:=CHR(0);
  i:=fopen(LOC_TST,1); 
  if i>0 then fclose(i)
 end;
 if i>0 then fclose(i);
 not_locked:=(i<0);
end;

procedure do_mail;
var dia:dialog_ptr;
    i,ok:integer;
    zpfad,zdatei:string;
    hlp:cstring;
    erg,leave:boolean;
    info:anytyp;
    dummy:string;

begin
 while lognam='' do do_login(lognam);
 i:=dgetpath(hlp,dgetdrv+1);
 ctopstr(hlp,zdatei);
 zpfad:=concat(chr(ord('A')+dgetdrv),':',zdatei,'\*.*');
 zdatei:='';
 begin_update;
 repeat
  leave:=true;
  erg:=get_in_file(zpfad,zdatei);
  if erg then
  begin
   if (zdatei[1]=lw) then
   begin
    i:=do_alert('[3][MC_TALK:|MAIL kann nicht vom|Netz-Laufwerk eingelesen werden][ Hmmm.. ]',1);
    leave:=false;
   end
   else
   begin
    leave:=not_locked(zdatei);
    if not leave then
     i:=do_alert('[3][MC_TALK:|MAIL-FILE ist Zugriffsgeschtzt|versenden nicht mglich][ Sorry!! ]',1);
   end;
  end;
 until (erg=false) or leave;
 end_update;

 if erg then
 begin
  find_dialog(selmail,dia);
  center_dialog(dia);
  for i:=mlog1 to mlog6 do
  begin
   if ring_def[i].my_name=name then
   begin
    obj_setstate(dia,i+mlog6,normal,false);
    if talking[i].who='' then
     set_dtext(dia,i,'no login',system_font,te_left)
    else
     set_dtext(dia,i,talking[i].who,system_font,te_left)
   end
   else
   begin
    obj_setstate(dia,i+mlog6,disabled,false);
    set_dtext(dia,i,'no login',system_font,te_left)
   end;
  end;
  begin_update;
  ok:=do_dialog(dia,0);
  obj_setstate(dia,ok,normal,true);
  obj_setstate(dia,ok,disabled,true);
  end_update;
  for i:=1 to 6 do
  begin
   if (obj_state(dia,i+mlog6) & selected)<>0 then
   begin
    mailsend[i]:=s_mail;
    dummy:='';
    info.use.what:=talk;
    info.use.quest.num:=i;
    info.use.quest.what:=s_mail;
    info.use.quest.rufer:=zdatei;
    erg:=transmit(ring_ptr,90,i,dummy,info);
   end
   else mailsend[i]:=0;
  end;
  repeat
   erg:=false;
   msg_reader(flags);
   wait(500);
   if flags.mailwork then get_mail(flags);
   for i:=1 to 6 do
   begin
    erg:=erg or (mailsend[i]=s_mail);
    if ((obj_state(dia,i+mlog6) & selected)<>0) and
       (mailsend[i]<>s_mail) then
    begin
     obj_setstate(dia,i+mlog6,normal,true);
     if mailsend[i]=r_mail then
      set_dtext(dia,i,'OK',system_font,te_center)
     else
      set_dtext(dia,i,'ERROR',system_font,te_center);
    end;
   end;
   begin_update;
   show_dialog(dia);
   end_update;
  until not erg;
  begin_update;
  obj_setstate(dia,ok,normal,false);
  set_dtext(dia,ok,'Fertig',system_font,te_center);
  ok:=do_dialog(dia,0);
  end_dialog(dia);
  obj_setstate(dia,ok,normal,false);
  set_dtext(dia,ok,'Mail senden',system_font,te_center);
  end_update;
 end;
end;

procedure flcon0(var flags:flagtype);
begin
 if flags.neudia then
 begin
  set_md;
  set_td;
  set_glocke(flags);
  flags.neudia:=false;
 end;
end;

procedure ask_bild;
var ziel:integer;
    info:anytyp;
    dummy:string;
    erg:boolean;

begin
 FIND_DIALOG(getpic,readpic);
(* center_dialog(readpic);*)
 dummy:='00000';
 set_dtext(readpic,picleng,dummy,system_font,te_left);
 dummy:='00000';
 set_dtext(readpic,picget,dummy,system_font,te_left);
 ziel:=show_karte;
 if ziel>0 then
 begin
(*  show_dialog(readpic);*)
  dummy:='';
  flags.waitpic:=true;
  flags.ok_pic:=false;
  flags.err_pic:=false;
  info.use.what:=talk;
  info.use.quest.num:=ziel;
  info.use.quest.what:=get_pic;
  erg:=transmit(ring_ptr,20,ziel,dummy,info);
 end;
end;

  procedure xshow;
  var bufadr:long_integer;
      hlp:cstring;
      screnadr:long_integer;
      zpfad,zdatei:string;
      buffer:long_integer;
      e2,i:integer;
      erg:boolean;

  begin
   begin_update;
   screnadr:=physbase;
   buffer:=malloc(-1);
   if buffer>=32000 then
   begin
    buffer:=malloc(32000);
    BUFADR:=Adr_Integer(screen[0]);
    e2:=do_alert('[3][MC_TALK:|Zurckschalten mit dem|rechten Mouse-Button][ Ah Ja! ]',1);
    hide_mouse;
    Move_L( screnadr, buffer, 8000);
    e2:=getstad(bufadr);
    show_mouse;
    while not r_mouse do e2:=0;
    hide_mouse;
    Move_L(buffer,screnadr,8000);
    show_mouse;
    mfree(buffer);
    e2:=do_alert('[3][MC_TALK:|Importiertes Bild speichern?| STAD-Format (.PAC)][ Ja | Nein ]',2);
    if e2=1 then
    begin
     i:=dgetpath(hlp,dgetdrv+1);
     ctopstr(hlp,zdatei);
     zpfad:=concat(chr(ord('A')+dgetdrv),':',zdatei,'\*.PAC');
     zdatei:='';
     erg:=get_in_file(zpfad,zdatei);
     if erg then
     begin
      ptocstr(zdatei,hlp);
      e2:=Fcreate (hlp,0);
      if e2>0 then buffer:=fwrite(e2,2*paclen,screen[0]);
      fclose(e2);
     end;
    end;
   end
   else
   begin
    e2:=do_alert('[3][MC_TALK:|Nicht genug Speicher|zum Bildschirm sichern][ Schade ]',1);
   end;
   end_update;
  end;

procedure flcon1(var flags:flagtype);
var i:integer;
begin
 if flags.neudia then
 begin
  set_md;
  set_td;
  if front_window<>main_wind then flcon0(flags)
  else
  begin
   begin_update;
   show_dialog(maindesk);
   end_update;
   flags.neudia:=false;
  end;
 end;
 if flags.waitpic then
 begin
  if flags.err_pic then
  begin
   end_dialog(readpic);
   flags.waitpic:=false;
   i:=do_alert('[3][MC_TALK:|Bildschirm kann nicht|importiert werden][ Nanu? ]',1);
  end;
  if flags.ok_pic then
  begin
   xshow;
   flags.waitpic:=false;
   end_dialog(readpic);
  end;
 end;
end;

procedure flcon2(var flags:flagtype;win,half:integer);
begin
 if front_window=main_wind then
 begin
  if flags.neudia then
  begin
   set_md;
   set_td;
   begin_update;
   show_dialog(teldesk);
   end_update;
   flags.neudia:=false;
  end;
  if flags.neutxt then
  begin
   show_txt(win,half);
   flags.neutxt:=false;
  end;
 end;
end;

procedure printwahl;
var hlp:c_string;
    ADR,i,j:INTEGER;
    msg:message_buffer;
    dia:dialog_ptr;

begin
 begin_update;
 find_dialog(prwahl,dia);
 center_dialog(dia);
 i:=do_dialog(dia,0);
 end_dialog(dia);
 end_update;
 Obj_SetState(Dia,i,normal,false);
 hlp[0]:='M';
 hlp[1]:='I';
 hlp[2]:='D';
 hlp[3]:='I';
 hlp[4]:='_';
 hlp[5]:='C';
 hlp[6]:='O';
 hlp[7]:='M';
 hlp[8]:=CHR(0);
 i:=0;
 if (Obj_State(dia,egal) & selected) <>0 then i:=-1
 else
 begin
  for j:=r0 to r6 do
   if (Obj_State(dia,j) & selected) <>0 then i:=set_bit(i,j-2);
 end;
 set_prconf(i,ring_ptr);
end;

procedure mbcon1(dummy:integer;var schluss:boolean;var modus,win,curx:integer);

begin
 IF (dummy>0) THEN { Wenn ja, dann entsprechend reagieren }
 BEGIN
  CASE dummy OF
   leavenet:do_login(lognam);
   weristda:dummy:=show_karte;
   phone   :BEGIN
	     modus:=2;
	     if lognam='' then do_login(lognam);
	     start_talk(win,curx);
	    END;
   alltime :set_time;
   mailsys :do_mail;
   Kiebitz :ask_bild;
   prselect:printwahl;
  END; {case}
 end;
END;

procedure mbcon2(num:integer;var flags:flagtype);
var info:anytyp;
    erg:boolean;
    dummy:string;

begin
 IF (num>=tel1) AND (num<=tel6) THEN
 BEGIN
 { ist der rechner (num) aktiv, so wird er inaktiv (kann meine Sendungen
   nicht mehr empfangen }
  IF talking[num].aktiv THEN talking[num].aktiv:=false
  ELSE
  BEGIN
  { Ist er nicht aktiv, aber noch am Telefon, so wird er wieder aktiv }
   IF (talking[num].onlin) and (talking[num].called) THEN
    talking[num].aktiv:=true
   ELSE
   BEGIN
   { Ansonsten wird er angerufen, falls ich ihn anrufen kann }
    IF ((ring_def[num].status & 263)=263) AND
	(ring_def[num].my_name=name) THEN
    BEGIN
     info.use.what:=talk;
     info.use.quest.num:=num;
     info.use.quest.rufer:=lognam;
     info.use.quest.what:=anm_talk;
     dummy:='';
{*** bermittle den Anruf an Rechner (num) }
     erg:=transmit(ring_ptr,30,num,dummy,info);
     talking[num].aktiv:=true;
     talking[num].called:=true;
    END;
   END;
  end;
  flags.neudia:=true;
 END;
END;

procedure do_init;
var i:integer;
    info:anytyp;
    dummy:string;
    erg:boolean;

BEGIN
 { Initialisierung der Talk-Anschluesse }
 FOR i:=1 TO 6 DO
 BEGIN
  talking[i].onlin:=false;
  talking[i].aktiv:=false;
  talking[i].called:=false;
  talking[i].who:='';
  mailbox[i].got_quest:=false;
  mailbox[i].pfad:='';
  mailsend[i]:=0;
 END;

 { Sende- und Lesepuffer initialisieren }
 FOR i:=1 TO 9 DO
 BEGIN
  szeil[i]:='';
  rzeil[i]:='';
 END;
 szeil[9]:='	     ';
 WHILE length(szeil[9])<70 DO szeil[9]:=concat(szeil[9],'	   ');

 find_dialog(main,maindesk);
 find_dialog(teflon,teldesk);

 repeat
  wait(500);
 until not mc_busy(ring_ptr);

 get_karte(ring_ptr);
 flags.verwok:=false;
 while not flags.verwok do msg_reader(flags);
 
 info.use.quest.what:=login;
 info.use.quest.rufer:='';
 info.use.what:=talk;
 dummy:='';
 for i:=1 to 6 do
 begin
  if ring_def[i].my_name=name then
  begin
   info.use.quest.num:=i;
   erg:=transmit(ring_ptr,80,i,dummy,info);
  end;
 end;
 wait(100);
 info.use.quest.what:=login;
 info.use.quest.rufer:=lognam;
 info.use.what:=talk;
 dummy:='';
 for i:=1 to 6 do
 begin
  if ring_def[i].my_name=name then
  begin
   info.use.quest.num:=i;
   erg:=transmit(ring_ptr,80,i,dummy,info);
  end;
 end;
 wait(100);
 set_md;
 set_td;
end;{do_init}

procedure begin_mctalk(var flags:flagtype);
var x,y,w,h:integer;
begin
 begin_update;
 wname:=' MC_TALK ';
 main_wind:=new_window(g_close|g_move|g_name,wname,0,0,0,0);
 if main_wind<>no_window then
 begin
  if flags.glocke then
  begin
   flags.glocke:=false;
   off_glocke;
  end;
 {$P-}
 w:=maindesk^[0].ob_w;
 h:=maindesk^[0].ob_h;
 x:=maindesk^[0].ob_x;
 y:=maindesk^[0].ob_y;
 {$P=}
  open_window(main_wind,x,y,w,h);
  pass_wind(maindesk,main_wind);
  show_dialog(maindesk);
  modus:=1;
 end;
 end_update;
 flags.waitpic:=false;
 flags.ok_pic:=false;
 flags.err_pic:=false;
end;

        procedure norm_string(var  str:string);
        { loescht fuehrende,doppelte und schliessende Leerzeichen }
        { normiert einen string auf klein-schreibung }

        var     i,j,k:integer;
                st1:str255;
                bool:boolean;

        begin
         st1:=str;
         j:=length(st1);
         if j>0 then
         begin
          i:=1;
          k:=1;
          bool:=true;
          repeat
           if st1[i]<>' ' then
           begin
            st1[k]:=st1[i];
            i:=i+1;
            k:=k+1;
            bool:=false;
           end
           else
           if (st1[i]=' ') and not bool then
           begin
            st1[k]:=st1[i];
            i:=i+1;
            k:=k+1;
            bool:=true;
           end
           else i:=i+1;
          until i>j;
          k:=k-1;
          if bool then k:=k-1;
          if k>0 then str:=copy(st1,1,k);
         end;
        end;


procedure read_inf(var pfad:string);
var t	 :file of text;
    help,hlp,zeile :string;
    num:integer;

begin
 flags.okkiebitz:=true;
 help:='\MC_TALK.INF';
 boot_drive(help);
 reset(t,help);
 if io_result<>0 then
 begin
  pfad:='';
  lognam:='';
 end
 else
 begin
  while not eof(t) do
  begin
   readln(t,zeile);
   if pos('loginname:',zeile)<>0 then
   begin
    hlp:=copy(zeile,11,length(zeile)-10);
    norm_string(hlp);
    lognam:=hlp;
   end
   else
   if pos('mail_pfad:',zeile)<>0 then
   begin
    hlp:=copy(zeile,11,length(zeile)-10);
    norm_string(hlp);
    pfad:=hlp;
   end
   else
   if pos('stop_kieb:',zeile)<>0 then
   begin
    hlp:=copy(zeile,11,length(zeile)-10);
    readv(hlp,num);
    if io_result=0 then flags.okkiebitz:=(num=0);
   end;
  end;
 end;
 close(t);
end;

    PROCEDURE start_netz;
    VAR erg:boolean;
	i,j:integer;
	msg : Message_Buffer ;
	event,dummy,mx,my,bcnt,taste,bstate:integer;
	half,curx:integer;
	timer:long_integer;
	schluss:boolean;

    BEGIN
     begin_mctalk(flags);
     flags.glocke:=false;

     REPEAT
      timer:=(10-(5*modus))*10;
      event:=get_event(e_button|e_message|e_keyboard|e_timer,1,1,2,timer,
		       false,0,0,0,0,false,0,0,0,0,
		       msg,taste,bstate,bcnt,mx,my,dummy);

      { wurde Nachricht empfangen ?? }
      msg_reader(flags);
      if flags.mailwork then get_mail(flags);

      case modus of { reagieren auf vernderte Flags }
       0:flcon0(flags);
       1:flcon1(flags);
       2:flcon2(flags,main_wind,half);
      end;{case}

      { Wurde der linke Maus-Button betaetigt ??? }
      IF ((event & e_button)<>0) AND (bcnt>1) then
      BEGIN
       case modus of	{ Auswerten von Mausclicks }
	1:mbcon1(obj_find(maindesk,0,7,mx,my),schluss,modus,main_wind,curx);
	2:mbcon2(obj_find(teldesk,0,7,mx,my),flags);
       end;{case}
      end;

      IF ((event & e_keyboard)<>0) then
      begin
       if modus=2 THEN
       begin
	i:=(taste div 256)-58;
	IF (i>=tel1) AND (i<=tel6) THEN
	 mbcon2(i,flags)
	else
	 key_interpret(taste,main_wind,half,curx);
       end
       else
       if modus=1 then
       begin
	i:=0;
	case taste of
	  5120 : i:=phone;    { ALT T => Telefon }
	 12544 : i:=weristda; { ALT N => Netz-Karte }
	  7680 : i:=leavenet; { ALT A => Anmeldung }
	  7936 : i:=alltime;  { ALT S => Systemzeit }
	 12800 : i:=mailsys;  { ALT M => Mailbox }
	  9472 : i:=Kiebitz;  { ALT K => Bild importieren }
	  8192 : i:=prselect; { ALT D => Drucker konfigurieren }
	end;{case}
	mbcon1(i,schluss,modus,main_wind,curx);
       end;
      end;

      if (event & e_message)<>0 THEN
      case msg[0] of
       AC_open	:begin
		  if modus=0 then begin_mctalk(flags);
		 end;
       AC_close :begin
		  if modus=2 then Close_Port(Get_port);
		  modus:=0;
		 end;
       wm_closed:begin
		  if modus=2 then do_end_talk(flags,main_wind);
		  if modus=1 then
		  begin
		   close_window(main_wind);
		   delete_window(main_wind);
		  end;
		  modus:=modus-1;
		  if modus<0 then modus:=0;
		 end;
       wm_redraw:case modus of
		  1: do_redraw(msg[3],msg[4],msg[5],msg[6],msg[7]);
		  2: tel_redraw(msg[3],msg[4],msg[5],msg[6],msg[7],half);
		 end; { case }
       wm_topped:begin
		  if flags.glocke then
		  begin
		   flags.glocke:=false;
		   off_glocke;
		  end;
		  bring_to_front(msg[3]);
		 end;
       wm_moved :begin
		  if modus=1 then
		  begin
		   {$P-}
		   maindesk^[0].ob_x:=msg[4];
		   maindesk^[0].ob_y:=msg[5]+19;
		   set_wsize(msg[3],msg[4],msg[5],msg[6],msg[7]);
		   {$P=}
		  end;
		 end;
      end;

     UNTIL false;
    END;

function test_ring:boolean;
var dia:dialog_ptr;

begin
 find_dialog(initial,dia);
 center_dialog(dia);
 begin_update;
 show_dialog(dia);
 wait(1000);
 name:='MC_TALK';
 if anmeld_ring(name,15000,ring_ptr) then
 begin
  wait(500);
  if mc_closed(ring_ptr) then
  begin
   set_dtext(dia,inmeld,'MIDI-RING O.K.',system_font,te_left);
   show_dialog(dia);
   do_init;
   test_ring:=true;
  end
  else
  begin
   ring_ptr:=abmeld_ring(ring_ptr);
   test_ring:=false;
   set_dtext(dia,inmeld,'MIDI-RING ERROR',system_font,te_left);
   show_dialog(dia);
   wait(2500);
  end;
 end;
 end_dialog(dia);
 end_update;
 set_dtext(dia,inmeld,'Bitte warten',system_font,te_left);
end;

procedure first_wait;
var msg 	: Message_Buffer ;
    event,dummy : integer;
    timer	: long_integer;

begin
 ring_ptr:=nil;
 for dummy:=1 to 2 do
 begin
  wait(6000);
  if test_ring then start_netz;
 end;
 REPEAT
  event:=get_event(e_message,1,1,2,timer,
		   false,0,0,0,0,false,0,0,0,0,
		   msg,dummy,dummy,dummy,dummy,dummy,dummy);

  if (event & e_message)<>0 THEN
  case msg[0] of
   AC_open  :begin
	      if test_ring then start_netz;
	     end;
  end;{ case }
 UNTIL false;
end;

procedure get_sys;
var f1:file of text;
    num:integer;
    zeile,hlp:string;

begin
 lw:='M';
 hlp:='\MIDI_COM.INF';
 boot_drive(hlp);
 reset(f1,HLP);
 NUM:=io_result;
 if num<>0 then
 begin
  reset(f1,'MIDI_COM.INF');
  NUM:=io_result;
 END;
 if num=0 then
 begin
  while not eof(f1) do
  begin
   readln(f1,zeile);
   if pos('micodrive:',zeile)<>0 then
   begin
    hlp:=copy(zeile,11,length(zeile)-10);
    readv(hlp,num);
    if (io_result=0) then lw:=chr(num+65);
   end;
  end;
 end;
 close(f1);
end;

    BEGIN
     io_check(false);
     lw:='M';
     apl_nr:=appl_init;
     if apl_nr>=0 then
     BEGIN
      men_name:='  MC_Talk';
      men_id:=menu_register(apl_nr,men_name);
      init_mouse;
      read_inf(mailpfad);
      get_sys;
      init_rsc;
      first_wait;
     END;
    end.


