/* Schnittstellen-Treiber fr MIDI-COM */
/***************************************/	

/* ber einen COOKIE-Eintrag <MCDR> werden MIDI_COM die folgenden	*/
/* vier Funktionen in der Struktur <io_port> zur Verfgung gestellt.*/
/* damit sollte es nun mglich sein, MIDI_COM auch mit beliebigen	*/
/* Schnittstellen zu betreiben. 									*/

/* Fehler-berprfungen mssen nicht stattfinden, da MIDI-COM eine  */
/* eigene CRC-Prfsumme benutzt. 									*/

typedef struct 
{
/* SENDE schickt LEN+1 Bytes aus buff ber die Schnittstelle */
/* z.B.: SENDE(49,&FOO); sendet 50 Bytes (0..49)             */
	void (*SENDE)(int LEN,char *buff);

/* LESE versucht <len> bytes aus dem Schnittstellenbuffer nach <buff>
   zu kopieren. Diese Funktion darf nicht blokieren, falls <len> Bytes
   nach einer gewissen Zeit nicht eingetroffen sind 
   LESE == 0 wenn die angeforderte Anzahl von bytes gelesen werden 
             konnten
        != 0 Irgend ein Fehler ist aufgetreten  */
   
   long (*LESE)(int len,char *buff);

/* CLEAR_BUFF fhrt einen RESET auf dem Schnittstellenpuffer durch */	
   void (*CLEAR_BUFF)(void);

/* STATUS == -1 wenn Zeichen im Schnittstellenpuffer vorhanden sind
          ==  0 keine Zeichen verfgbar*/
	int  (*STATUS)(void);
/* Fuell-STATUS ==   0 zuwenig Zeichen im Schnittstellenpuffer vorhanden
                ==  1 genug Zeichen verfgbar*/
	int  (*Fuellung)(void);
}io_port;

static void MSEND(int LEN,char *buff);
static long LESE(int len,char *buff);
static void MIDEIN(void);
static int mdstat(void);
static int fil_request(void);

io_port	port={MSEND,LESE,MIDEIN,mdstat,fil_request};

#ifndef _COOKIE_H
#define _COOKIE_H

union clong {
	char	aschar[4];
	long	aslong;
};

struct cookie {
	union clong tag;
	long value;
};

typedef struct cookie COOKIE;

#define CJAR	((COOKIE **) 0x5a0L)

#endif /* _COOKIE_H */

