#include <stddef.h>			 /* Standard-Definitionen */
#include <string.h>      /* String-Library */
#include "mc_lib.h"

static long get_cookie(void)
{
	COOKIE  *cokie;
	
	cokie = 	*CJAR;
	if (cokie) 
	{
		while (cokie->tag.aslong != 0) 
		{
			if (!strncmp(cokie->tag.aschar, "MICO",4))
			{
				infos=(CINFO *)cokie->value;
			}
			cokie++;
		}
	}
	return(0);
}

long mygemdos(msg_typ *mc_msg)
{
 long   old_super_stack,erg;
 
 old_super_stack = Super( 0L );
 erg=MC_direct_call(mc_msg);
 Super((void *) old_super_stack );
 return( erg );
}

int get_mc_sys(syspar *sys,all_proc *allprocs)
{

  long		test;
  msg_typ   mc_msg;

	if (MiNT==0)
	{
		(void)Supexec(get_cookie);
		if (infos==NULL) MiNT=2;
			else	MiNT=1;
	}
	if (MiNT==1)
	{
		mc_msg.what =   0;
		*sys        = (sys_par *)mygemdos(&mc_msg);
		mc_msg.what =   1;
		*allprocs 	= (all_proc )mygemdos(&mc_msg);
		return(1);
	}
	else
	if (MiNT==2)
	{

    	mc_msg.what =   0;
	    test        =   trap111(&mc_msg);
    	if (test>0)	/* ist MIDI-COM nicht aktiviert, existiert GEMDOS 111 nicht =>-34*/
	    {
			*sys    = (sys_par *) test;
			mc_msg.what =   1;
			*allprocs = (all_proc) trap111(&mc_msg);
			return(1);
		}
	}
  return(0);
}

long	mc_message(msg_typ *mc_msg)
{
	if (MiNT==1)
		return(mygemdos(mc_msg));
	else
	    return(trap111(mc_msg));
}

long write_message(int what, int an, int size,char *name,void *ptr)
{
  msg_typ   mc_msg;

  mc_msg.what =   what;
  mc_msg.size=size;
  mc_msg.ptr=ptr;
  mc_msg.name=name;
  mc_msg.an=an;
  mc_msg.fill=0;
  return(mc_message(&mc_msg));

}


int anmeld_ring(char *name,int buff_size,io_rec *io_ptr)
{
 buff_size-=1;
 if (buff_size<1999) buff_size=1999;
 if (buff_size>29999) buff_size=29999;
 if (io_ptr->ibuf==NULL)
 {
  io_ptr->ibuf=Malloc(buff_size);
 };
 io_ptr->size=buff_size+1; /* groesse des Buffers      */
 io_ptr->   nl  =0;           /* naechste Leseposition    */
 io_ptr->   nw  =0;           /* naechste Schreibposition */
 io_ptr->   blow=0;           /* status/fehler            */
 io_ptr->   bhig=-1;          /* Ack: msg gelesen         */
 if (!write_message(_ASSIGN,0,0,name,io_ptr)) return(TRUE);
 return(FALSE);
}


io_rec *abmeld_ring(io_rec *read_buf)
{
   write_message(_GOOD_BYE,0,0,NULL,NULL);
   if (read_buf)
   {
   	Mfree(read_buf->ibuf);
   }
   return(NULL);
}

long transmit(int size,int an,char *name,void *dat_adr)
{  
 return(write_message(_SEND_DATA,an,size,name,dat_adr));
}

typedef	union
{
	int asint;
	char	aschar[2];
}konv1;

int lese(io_rec *read_buf,char *bufa1,int *esc,int *len)
{
 int i;
 konv1	help;
 
 *esc=0;
 if (read_buf->nl==read_buf->nw) return(FALSE);
 help.aschar[0]=read_buf->ibuf[read_buf->nl++];
 if (read_buf->nl==read_buf->size) read_buf->nl=0;
 help.aschar[1]=read_buf->ibuf[read_buf->nl++];
 if (read_buf->nl==read_buf->size) read_buf->nl=0;
 if (help.asint>4000)
 {
   	*esc=help.asint;
	help.aschar[0]=read_buf->ibuf[read_buf->nl++];
	if (read_buf->nl==read_buf->size) read_buf->nl=0;
	help.aschar[1]=read_buf->ibuf[read_buf->nl++];
	if (read_buf->nl==read_buf->size) read_buf->nl=0;
	*len=help.asint;
 }
 for (i=0;i<=help.asint-3;i++)
 {
	bufa1[i]=read_buf->ibuf[read_buf->nl++];
	if (read_buf->nl==read_buf->size) read_buf->nl=0;
 }
 return(TRUE);
}

void get_Karte(void)
{
 write_message(_GET_VERW,0,0,NULL,NULL);
}


int mc_busy(io_rec *read_buf)
/* ring geschlossen und im sende-Modus */
{
 return(((read_buf->blow & 7)==7) && ((read_buf->blow & 64)==64));
}

int mc_closed(io_rec *read_buf)
/* ring geschlossen */
{
 return(((read_buf->blow & 7)==7));
}

int mc_neustat(io_rec *read_buf)
/* ring-Verwaltung wurde gendert */
{
 return(((read_buf->blow & 2048)==2048));
}
