
#include <aes.h>
#include <vdi.h>
#include <tos.h>
#include <ext.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <portab.h>

#include "midnight.h"	/* ACC_str + MOD_str + defines fr Module + ACC */

		/* Funktionen aus MOSTART.S, die ber Pointer aufgerufen werden	*/
extern int		EVNT_ask( long wait_ms );
extern long		rnd24( long wert );
extern int		Sound( SND_str *SND_struct );
extern int		ScreenSave( int flag, char *Name );

extern MOD_str MOD_struct;

Value	*Value_s = NULL;		/* zeigt auf eine Liste von Pointern	*/


/*
	GRUNDLEGENDES !
	Da die Module ab und zu einmal aufgerufen werden und eben nicht 
	kontinuierlich die Kontrolle ber die Register haben, kann es bei
	Benutzung einer Variablen ber mehrere Programmteile (M_INIT,M_SWITCH...)
	zu Problemen kommen, da ja inzwischen wieder 'Sonstwer' in den Registern
	'rumgespielt hat. Deshalb sind solche Variablen als 'static' zu deklarieren,
	im Notfall (wenn's nicht klappt) auch als Volatile.
	Sicher ist sicher...
*/



int		pxy[4];
volatile static int handle;		/* darf nicht im Register stehn			*/

long invert( ACC_str *As,long nr );


#define MUCH 20

ULONG MOD_main( int Mode, ACC_str *As )
{
	long nr1,nr2;
	int fl;

	switch( Mode )
	{	case M_INIT:
			MOD_struct.U.b = 0x003f;
			v_opnvwk( As->work_in,&handle,As->work_out );
			if( !handle ) return( 0 );

			pxy[0]=As->x;
			pxy[1]=As->y;
			pxy[2]=As->x+As->w;
			pxy[3]=As->y+As->h;
			vs_clip( handle,1,pxy );
			break;
		case M_SWITCH:
			break;
		case M_DO_IT:
			vsf_perimeter( handle,0 );
			vswr_mode( handle,MD_XOR );
			
			nr1=nr2= Random();

			fl=0;
			do
			{
				if( fl<64 )
					nr1= invert( As,nr1 );
				else
					nr2= invert( As,nr2 );

				fl= (fl+1) & 127;
				if( (fl==0) || (fl==64) ) EVNT_ask( 1000 );
			} while( !EVNT_ask( 50 ) );

			break;
		case M_EXIT:
			if( handle ) v_clsvwk( handle );
			break;
	}

	return( 1 );
}


long invert( ACC_str *As,long nr )
{
	register int i;

	for( i=0;i<MUCH;i++ )
	{	pxy[2]= (pxy[0]= (nr=rnd24(nr)) % (As->w-50))+50;
		pxy[3]= (pxy[1]= (nr=rnd24(nr)) % (As->h-50))+50;
		vsf_color( handle, ((nr=rnd24(nr)) % ((1<<As->planes)-1) ) +1 );
		v_bar( handle,pxy );
	}
	return( nr );
}
