
#include <vdi.h>
#include <tos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <portab.h>

#include "midnight.h"	/* ACC_str + MOD_str + defines fr Module + ACC */

extern MOD_str	MOD_struct;
#define Ms MOD_struct

Value	Values[3]=
	{	T_EDIT,0,60000L,"Frequenz (0=INF nehmen)",
		T_BUTTON,0,(long)"DMA-Format","\0",
		T_TITEL|T_END,0,0,"V1.1, HzN 1.93 (Dudeldi)"
	};

Value	*Value_s = Values;		/* zeigt auf eine Liste von Pointern	*/


/*
	GRUNDLEGENDES !
	Da die Module ab und zu einmal aufgerufen werden und eben nicht 
	kontinuierlich die Kontrolle ber die Register haben, kann es bei
	Benutzung einer Variablen ber mehrere Programmteile (M_INIT,M_SWITCH...)
	zu Problemen kommen, da ja inzwischen wieder 'Sonstwer' in den Registern
	'rumgespielt hat. Deshalb sind solche Variablen als 'static' zu deklarieren,
	im Notfall (wenn's nicht klappt) auch als Volatile.
	Sicher ist sicher...
*/



int		pxy[10];
volatile static int handle;		/* darf nicht im Register stehn			*/

void pop_note( int x,int y,int w );


ULONG MOD_main( int Mode, ACC_str *As )
{
	int		dim,y;
	long	x,length;
	static	UBYTE *snd= NULL;
	static	SND_str krach = { NULL,NULL,NULL,7000,0x0000 };
	int		file;
	char	stri[100];

	switch( Mode )
	{	case M_INIT:
			MOD_struct.U.b = 0x003f;
			v_opnvwk( As->work_in,&handle,As->work_out );
			if( !handle ) return( 0 );	/* Workstation ffnen, wenn's geht	*/
			dim= strlen(MOD_struct.MyName);	/* Eigenen Namen bearbeiten		*/
			strcpy( &MOD_struct.MyName[dim-3],"INF" );	/* und zu INF machen*/
			file= Fopen( MOD_struct.MyName,0 );	/* INF Datei ffnen			*/
			if( file<0 ) return( 0 );
			dim= Fread( file,99,stri );			/* und einlesen				*/
			Fclose( file );
			if( dim<0 ) return( 0 );			/* das ging daneben			*/

			x= atoi(stri);						/* Am Anfang stehen die Hz	*/
			if( x<20 ) x= 7000;					/* 7000Hz, wenn Wert < 20Hz	*/

			if( Ms.Werte[1] ) krach.SND_repeat|=0x8000L;
												/* DMA-Abspielformat setzen	*/

			if( Ms.Werte[0] ) x= Ms.Werte[0];	/* Vorgegebene Frequenz ?	*/
			krach.SND_Hz= x;

			x=0;
			if( *stri!=' ' )					/* Anfang des Pfades suchen	*/
			{	for( x=0;stri[x] && (stri[x]!=' ');x++ );
				x++;
			}
			stri[dim]='\0';
			file= Fopen( stri+x,0 );			/* Der Rest ist der Pfad	*/
			if( file<0 ) return( 0 );			/* einer SND Datei: ffnen	*/

			length= Fseek( 0,file,2 );			/* Dateilnge ermitteln		*/
			Fseek( 0,file,0 );

					/* Da der Speicherbereich fr einen Sound, der ber	*/
					/* DMA abgespielt werden soll (ab STE), im ST-RAM	*/
					/* liegen MUSS (!), wird hier auf Mxalloc geprft.	*/
			x= krach.SND_Hz;

					/* wenn DMA-Fraquenz gewhlt und Mxalloc vorhanden:	*/
			if( ((x==6258L) || (x==12517L) || (x==25033L) || (x==50066L)) &&
				( Mxalloc(-1,0) != -32L ) )
			{	snd= (UBYTE*)Mxalloc( length,0 );	/* Mxalloc existiert.	*/
				if( !snd )							/* Wenn kein ST-RAM da,	*/
				{	krach.SND_Hz++;					/* DMA-Frequenz weg und	*/
					snd= (UBYTE*)Malloc( length );	/* mit normalem Malloc.	*/
				}
			}
			else
				snd= (UBYTE*)Malloc( length );		/* ST-RAM mit Malloc	*/

			if( !snd ) return( 0 );		/* Kein Speicher frei, tsch...	*/

			Fread( file,length,snd );	/* Speicher holen und SND einlesen	*/
			Fclose( file );
			krach.SND_start= snd;		/* Die Pointer auf Anfang und Ende	*/
			krach.SND_end= snd+length;	/* des Sounds setzen.				*/

			pxy[0]=As->x;				/* jetzt nur noch clippen...		*/
			pxy[1]=As->y;
			pxy[2]=As->x+As->w;
			pxy[3]=As->y+As->h;
			vs_clip( handle,1,pxy );
			break;
		case M_SWITCH:
			v_bar( handle,pxy );		/* nur schwarz machen				*/
			break;
		case M_DO_IT:
			vsf_interior( handle,2 );
			vsf_perimeter( handle,0 );

			Sound( &krach );			/* nun endloses spielen des Sounds.	*/

			x= 0;
			y= 0;
			dim= 1;
			do
			{	vsf_style( handle,8 );
				vsf_color( handle,1 );
				pop_note( x,y,dim );	/* alte Note lschen.				*/

				if( As->planes!=1 ) vsf_color( handle,Random()%(1<<As->planes) );
				else vsf_style( handle,Random()&7 );
										/* Entsprechend den Farben setzen.	*/

				x= As->x+Random()%As->w;	/* neue Position und Gre.		*/
				y= As->y+Random()%As->h;
				dim= (As->w*((Random()&7)+2))>>7;
				pop_note( x,y,dim );	/* neue Note setzen.				*/
			} while( !EVNT_ask(Random()&255+100) );/* Warten, warten,warten.*/

			Sound( NULL );				/* Sounds abbrechen.				*/
			break;
		case M_EXIT:
			if( snd ) Mfree( snd );		/* Speicher freigeben und			*/
			if( handle ) v_clsvwk( handle );	/* Workstation schlieen	*/
			break;
	}

	return( 1 );	/* Und Tsch...	*/
}


void pop_note( int x,int y,int w )
{
	int m;

	m= 3*w/2;							/* Verhltnis x- zu y-Radius.		*/
	v_ellipse( handle,x,y,m,w );		/* Note zeichenen,					*/
	pxy[0]= x+m-(w>>3);
	pxy[2]= x+m;
	pxy[1]= y-(w*3);
	pxy[3]= y;
	v_bar( handle,pxy );				/* und den Hals der Note.			*/
}
