.TH Fsymlink 2 "MiNT Programmer's Manual" "Version 1.0" "Feb. 1, 1993"
.SH NAME
Fsymlink \- create a symbolic link to a file
.SH SYNOPSIS
.nf
LONG Fsymlink( char *oldname, char *newname );
.fi
.SH DESCRIPTION
.I Fsymlink
creates a new symbolic link (a "soft link") for the file currently named
.IR oldname .
If the
.I Fsymlink
call is successful, then after the call the file may be referred to by
either name. A call to
.I Fdelete
on the new name will not affect the existence of the file, just of the
symbolic link.
A a call to
.I Fdelete
with the name
.I oldname
will actually delete the file, and future references with
.I newname
will fail.
.PP
Unlike hard links, symbolic links may be made between files on different
devices or even different types of file systems.
.SH RETURNS
0 on success
.PP
EINVFN if the file system does not allow symbolic links
.PP
An appropriate error code if the new symbolic link cannot be created.
.SH "SEE ALSO"
.IR Flink (2),
.IR Freadlink (2),
.IR Frename (2)
.SH BUGS
No check is made for the existence of the file named
.IR oldname ;
this could be construed as a feature.
.PP
Most file systems (including the GEMDOS file system) do not support
symbolic links.

