.TH Psetpgrp 2 "MiNT Programmer's Manual" "Version 1.03" "Feb. 24, 1993"
.SH NAME
Psetpgrp \- set the process group number for a process
.SH SYNOPSIS
.nf
WORD Psetpgrp(WORD pid, WORD newgrp);
.fi
.SH DESCRIPTION
.I Psetpgrp
sets the process group of the process with process id
.I pid
to the number
.IR newgrp .
The process must have the same user id as the current process, or must
be a child of that process. If
.I pid
is 0, the process group of the current process is set. If
.I newgrp
is 0, then the process group is set equal to the process id of the process.
If
.I newgrp
is -1, then the process group is not changed, and the current process group
number is returned.
.SH RETURNS
The new process group number, if successful.
.PP
EFILNF if process
.I pid
does not exist.
.PP
EACCDN if the process with id
.I pid
has a different user id and is not a child of the calling process.
.SH "SEE ALSO"
.IR Pkill (2),
.IR Pgetpgrp (2),
.IR Pgetpid (2)
