.TH Psigreturn 2 "MiNT Programmer's Manual" "Version 1.0" "Feb. 1, 1993"
.SH NAME
Psigreturn \- exit from a signal handler
.SH SYNOPSIS
.nf
void Psigreturn();
.fi
.SH DESCRIPTION
.I Psigreturn
is used to prepare to exit from a signal handler. This is done automatically
by the kernel when a signal handler returns, so it is needed only before
a program uses the C
.I longjmp
function (or some similar facility) to do a non-local jump.
.I Psigreturn
will fail (harmlessly) if no signal is being processed at the time it is
called.
.PP
Note that the MiNT library
.I longjmp
function already contains a call to
.IR Psigreturn ,
so if you're using that library you don't need to worry about this.
.SH "SEE ALSO"
.IR Psignal (2)
.SH BUGS
Calling
.I Psigreturn
from a signal handler, and then actually returning from that handler, is
likely to produce extremely unpleasant results.
