MODULE  netview;
FROM    BIOS            IMPORT  RW,RWAbs,Device,BConOut,BConIn,BConStat;
FROM    XBIOS           IMPORT  ScreenPhysicalBase,IOREC,IORECPTR,
                                SerialDevice,IORec;
FROM    SYSTEM          IMPORT  ADR,ADDRESS,BYTE;
FROM    GEMDOS          IMPORT  Term;
FROM    ASCII           IMPORT  ESC;
FROM    NETWORK         IMPORT  GetOpt,PHYSLOW;

CONST   DEBUG   =       FALSE;

TYPE    message =       ARRAY [0..255] OF CARDINAL;
VAR         char                        :       CHAR;
            result                      :       LONGINT;
            i,r                         :       CARDINAL;
            ok,init                     :       BOOLEAN;
            cmd                         :       ARRAY [0..127] OF LONGCARD;
            ch                          :       LONGCARD;
            screen1,screen0             :       message;
            meminfo                     :       POINTER TO ARRAY [0..511]
                                                OF BYTE;

PROCEDURE       phybase(): CARDINAL;
BEGIN
  IF PHYSLOW THEN
        RETURN CARDINAL(LONGCARD(078000H) DIV LONGCARD(512));
  ELSE
        RETURN CARDINAL(LONGCARD(0F8000H) DIV LONGCARD(512));
  END;
END     phybase;

PROCEDURE       compare;
BEGIN
                  meminfo:=ScreenPhysicalBase();
                  FOR i:=0 TO 63 DO
                    screen0[i]:=0;
                    FOR r:=0 TO 511 DO
                        IF NOT init THEN screen0[i]:=1 END;
                        screen0[i]:=screen0[i]+CARDINAL(meminfo^[0]);
                        meminfo:=ADDRESS(LONGCARD(meminfo)+LONGCARD(1));
                    END;
                  END;
                  init:=TRUE;
END     compare;

BEGIN
   GetOpt; (* see if the remote is a 520 *)

 LOOP
      result:=RWAbs(Read,ADR(screen1),1,3,31);
      compare;
      FOR i:=0 TO 63 DO
        IF screen0[i]#screen1[i] THEN
           result:=RWAbs(Read,ScreenPhysicalBase()+ADDRESS(i*512),1,
                         phybase()+i,31);
        END;
      END;
      WHILE BConStat(CON) DO
        ch:=BConIn(CON);
        IF (ch DIV 65536) = 61H THEN EXIT END;
        cmd[0]:=1;
        cmd[1]:=ch;
        result:=RWAbs(Write,ADR(cmd),1,2,31);
      END;
 END;
 ok:=Term(0);
END     netview.

