/* Mag!X Patch - ein Patch fr Mag!X 2.0
   17.12.93 Harald Sommerfeldt
   nach einem Patch von Wilfried Behne
*/

#include <tos.h>
#include <string.h>

int	patch( const char *info, int fh, long offset, const char *data, const char *patch, size_t patchlen )
{
	char	buffer[12];

	Cconws( info );
	if ( Fseek( offset, fh, 0 /* FS_SET */ ) != offset )
	{
		Cconws( "Fseek() hat nicht geklappt!?\r\n" );
		return 0;
	}
	if ( Fread( fh, patchlen, buffer ) != patchlen )
	{
		Cconws( "Fread() hat nicht geklappt!?\r\n" );
		return 0;
	}
	if ( !memcmp( buffer, patch, patchlen ) )
	{
		Cconws( "ist schon gepatcht!\r\n" );
		return 0;
	}
	if ( memcmp( buffer, data, patchlen ) )
	{
		Cconws( "ist irgendwie suspekt!?\r\n" );
		return 0;
	}
	if ( Fseek( offset, fh, 0 /* FS_SET */ ) != offset )
	{
		Cconws( "der 2te Fseek() hat nicht geklappt!?\r\n" );
		return 0;
	}
	if ( Fwrite( fh, patchlen, patch ) != patchlen )
	{
		Cconws( "Fwrite() hat nicht geklappt!?\r\n" );
		return 0;
	}
	Cconws( "ok\r\n" );
	return 1;
}

const char  data1[] = { '\x30', '\xfc', '\x00', '\x01', '\xe7', '\x48' };
const char patch1[] = { '\x52', '\x58', '\x72', '\x03', '\xe3', '\x68' };

const char  data2[] = { '\x20', '\xd9', '\x30', '\x91' };
const char patch2[] = { '\x51', '\xc9', '\xff', '\xf0' };

const char  data3[] = { '\x00', '\x00', '\x00', '\x07', '\x00', '\x01',
                        '\x00', '\x01', '\x00', '\x01', '\x00', '\x00' };
const char patch3[] = { '\x00', '\x01', '\x00', '\x00', '\x00', '\x07',
                        '\x00', '\x01', '\x00', '\x01', '\x00', '\x01' };

main()
{
	int	fh;

	Cconws( "\033p Mag!X 2.0 Patch - 17.12.93 Harald Sommerfeldt \033q\r\n\r\n" );
	fh = (int)Fopen( "MAG!X.RAM", 0 );	/* so sollte man's eigentlich nicht machen! */
	if ( fh > 0 )
	{
		if ( Fseek( 0L, fh, 2 /* FS_END */ ) == 148491L )
		{
			patch( "Patch 1: ", fh, 0x1a348L, data1, patch1, sizeof( patch1 ) );
			patch( "Patch 2: ", fh, 0x1a360L, data2, patch2, sizeof( patch2 ) );
			patch( "Patch 3: ", fh, 0x1a3d0L, data3, patch3, sizeof( patch3 ) );
		}
		else Cconws( "MAG!X.RAM hat falsche Dateilnge!\r\n" );
		Fclose( fh );
	}
	else Cconws( "MAG!X.RAM nicht gefunden!\r\n" );
	Cconin();

	return 0;
}
